---
navigation:
  parent: example-setups/example-setups-index.md
  title: Пример «Основной сети»
  icon: controller
---

# Пример «Основной сети»

Многие другие установки ссылаются на "Основную сеть". Вы также можете спросить, как все эти [устройства](../ae2-mechanics/devices.md) объединяются
в функциональную систему. Вот пример:

<GameScene zoom="2.5" interactive={true}>
  <ImportStructure src="../assets/assemblies/treelike_network_structure.snbt" />

    <BoxAnnotation color="#dddddd" min="3.9 0 1.9" max="9.1 5 7.1" thickness="0.05">
        Большая группа поставщиков шаблонов и сборщиков предоставляет много места для изготовления шаблонов для создания, каменорезки и ковки.
        Шахматный узор позволяет поставщикам использовать несколько сборщиков параллельно, сохраняя при этом компактность.
        Группы по 8 штук делают невозможным неправильную маршрутизацию каналов.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="3.9 0 9.9" max="5.1 3 12.1" thickness="0.05">
        Некоторые машины, с подсетью труб для передачи своих результатов в поставщики.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="-0.1 0 8.9" max="1.1 3 13.1" thickness="0.05">
      Некоторые терминалы и различные утилитарные приспособления. (вероятно, вам нужен только терминал для крафта, а не обычный терминал и терминал для крафта)
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="-0.1 0 -0.1" max="2.1 3 8.1" thickness="0.05">
      Набор процессоров для изготовления. Несколько с большим объемом памяти и несколько с меньшим объемом памяти.
      Вероятно, в реальной установке вам понадобится больше блоков совместной обработки изготовления, но для этой сцены это будет немного многовато.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="5.9 0 13.9" max="7.1 1 15.1" thickness="0.05">
      Ваш контроллер должен находиться в центре вашей базы и, вероятно, быть немного больше, чем этот. Форма палки подойдет лучше всего.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="11.9 0 7.9" max="13.1 4 13.1" thickness="0.05">
        Различные методы хранения данных с помощью дисководов или шин хранения. Обратите внимание, что все они объединены в группы по 8.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="10.9 0 0.9" max="13.1 2 7.1" thickness="0.05">
        Различные методы хранения данных с помощью дисководов или шин хранения. Обратите внимание, что все они объединены в группы по 8.
    </BoxAnnotation>

  <IsometricCamera yaw="315" pitch="30" />
</GameScene>
