---
navigation:
  parent: example-setups/example-setups-index.md
  title: Авторегулируемый генератор булыжника
  icon: minecraft:cobblestone
---

# Авторегулируемый генератор булыжника

Автоматизация генератора булыжника проста: просто обратите <ItemLink id="annihilation_plane" /> в стандартный ванильный
ручной генератор булыжника. Однако в результате этого ваша сеть в конечном итоге забивается булыжником, поэтому необходимо ввести некоторые ограничения

Из-за того, как работают плоскости уничтожения (они действуют как <ItemLink id="import_bus" />), мы не можем просто поместить <ItemLink id="level_emitter" />
напротив <ItemLink id="export_bus" /> с <ItemLink id="redstone_card" /> (поскольку нельзя напрямую переходить от импорта к экспорту
без промежуточного хранения). Нам нужно пойти немного более окольным путем.

<ItemLink id="toggle_bus" /> позволяют подключать и отключать части вашей сети с помощью сигналов редстоуна, но при этом
сеть перезагружается. Есть простой способ обойти эту проблему: поместите шину переключения в [подсеть](../ae2-mechanics/subnetworks.md),
 чтобы перезагружалась только подсеть.

Мы можем иметь автономные <ItemLink id="annihilation_plane" /> и <ItemLink id="storage_bus" /> [подсети](../ae2-mechanics/subnetworks.md),
 подключенные к <ItemLink id="interface" /> в основной сети. Шина переключения будет подключать и отключать подсеть от
<ItemLink id="quartz_fiber" />, отключая питание плоскостей.

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/regulated_cobble_gen.snbt" />

<BoxAnnotation color="#dddddd" min="3 2 2" max="7 2.3 3">
        (1) Плоскости уничтожения: нет графического интерфейса для настройки, но можно зачаровать на "Эффективность" и "Прочность", чтобы снизить потребление энергии.
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 2 2" max="2.3 3 3">
        (2) Шина хранения: с настройкой по умолчанию.
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.3 2.3 2" max="2.7 2.7 2.3">
        (3) Шина переключения: Очень важно, чтобы шина переключения находилась в
        подсети, а не в основной сети.
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.3 3 2.3" max="2.7 3.3 2.7">
        (4) Излучатель уровня: настроен на булыжник и нужное количество, установлен режим "Излучать при уровне ниже лимита".
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 2 3" max="2 3 2">
        (5) Интерфейс: с настройкой по умолчанию
  </BoxAnnotation>

<DiamondAnnotation pos="0 2.5 1.5" color="#00ff00">
        В основную сеть
    </DiamondAnnotation>

<DiamondAnnotation pos="5 1.5 3.5" color="#00ff00">
        Затопленные ступеньки не дают воде стекать и превращать лаву в обсидиан.
    </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## Настройки

* <ItemLink id="annihilation_plane" /> (1) Не имеют графического интерфейса для настройки, но могут быть зачарованы на "Эффективность" и "Прочность" для снижения энергопотребления.
* <ItemLink id="storage_bus" /> (2) находятся в своей настройке по умолчанию.
* <ItemLink id="toggle_bus" /> (3) должен находиться на стороне подсети кварцевого волокна, а не на стороне основной сети или основная
   сеть будет перезагружаться при каждом переключении.
* <ItemLink id="level_emitter" /> (4) настроен на нужный предмет и количество, установлен режим "Излучать при уровне ниже лимита".
*  <ItemLink id="interface" /> (5) находится в своей настройке по умолчанию.

## Как это работает

1. Генератор булыжника создает некоторое количество булыжников.
2. <ItemLink id="annihilation_plane" /> разбивают булыжник. 
3. <ItemLink id="storage_bus" /> хранит булыжник в <ItemLink id="interface" />, отправляя его в основную сеть.
4. Когда количество булыжника в основной сети превышает установленное количество, <ItemLink id="level_emitter" /> перестает
   посылать сигнал, отключая <ItemLink id="toggle_bus" />.
5. Это отключает питание подсети, останавливая работу плоскостей уничтожения.
