---
navigation:
  title: Начало (1.20+)
  position: 10
---

<div class="notification is-info">
  Следующая информация применяется только к Applied Energistics 2 для версии Minecraft 1.20 и новее.
</div>

# Начало

## Получение первоначальных материалов

<GameScene zoom="4" background="transparent">
  <ImportStructure src="assets/assemblies/meteor_interior.snbt" />
</GameScene>

Чтобы начать работать с Applied Energistics 2, для начало вам необходимо найти [метеорит](ae2-mechanics/meteorites.md). Они встречаются довольно часто и из-за того, что они оставляют огромные кратеры возле себя, вы вероятнее всего находили хотя бы один во время своего путешествия.
Если же вы не находили, тогда скрафтите <ItemLink id="meteorite_compass" />, который показывает на точку, где находится ближайший <ItemLink id="mysterious_cube" />.

Когда вы найдёте метеорит, скопайте его центр. Там вы найдёте друзы истинного кварца, бутоны истинного кварца, [цветущие блоки истинного кварца](items-blocks-machines/budding_certus.md) разных вариантов, а также Таинственный куб в центре.

Вскапывайте друзы истинного кварца и любые блоки истинного кварца, которые вы найдёте. Также не забудьте забрать цветущие блоки истинного кварца, но стоит отметить, что без Шёлкового касания при добыче они будут деградировать на 1 уровень.

Ни в коем случае не ломайте Безупречный цветущий блок истинного кварца, даже с Шёлковым касанием он будет деградировать на 1 уровень, то есть до Потресканного/Несовершенного цветущего блока истинного кварца. Его будет невозможно восстановить обратно до безупречного.

Также добудьте Таинственный куб в центре метеорите, куб даст вам все 4 печати для вырезателя.

## Выращивание истинного кварца

<GameScene zoom="4" background="transparent">
<ImportStructure src="assets/assemblies/budding_certus_1.snbt" />
</GameScene>

Бутоны истинного кварца растут со [цветущих блоков истинного кварца](items-blocks-machines/budding_certus.md), это похоже на то, как растёт аметист. Если вы сломаете бутон до того как тот вырастет до конца, тогда выпадет 1 <ItemLink id="certus_quartz_dust" />, зачарование "Удачи" не изменяет количество. Если же вы сломаете полностью вырасшую дрозу, тогда выпадет 4 <ItemLink id="certus_quartz_crystal" /> и уже их количество может быть увеличено с помощью Удачи

Вот все 4 уровня цветущего блока истинного кварца: Безупречный, Потресканный/Несовершенный, Потресканный/Сколотый, Повреждённый.

<GameScene zoom="4" background="transparent">
<ImportStructure src="assets/assemblies/budding_blocks.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>

Каждый раз когда бутон вырастает до другой стадии, цветущий блок имеет шанс деградировать на 1 уровень, что по тихоньку превращает его в обычный блок истинного кварца. Цветущий блок может быть починен (и новый цветущий блок может быть создан) при кидании цветущего блока (или блока истинного кварца) в воду с одним или более <ItemLink id="charged_certus_quartz_crystal" />.

<RecipeFor id="damaged_budding_quartz" />

Безупречный цветущий блок истинного кварца не будет деградировать и будет генерировать истинный кварц вечно. Однако этот блок не может быть создан или перемещён с помощью кирки, даже если на ней есть Шёлковое касание (но блок *может* быть перемещён с помощью [пространственного хранилища](ae2-mechanics/spatial-io.md))

Самостоятельно бутоны истинного кварца растут крайне медленно. К счастью, <ItemLink id="growth_accelerator" /> значительно ускоряет данный процесс, когда поставлен вплотную к цветущиму блоку. Вам следует построить несколько из них в первую очередь.

<GameScene zoom="4" background="transparent">
<ImportStructure src="assets/assemblies/budding_certus_2.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>

Если у вас не хватает кварца, чтобы сделать <ItemLink id="energy_acceptor" /> или <ItemLink id="vibration_chamber" />,
то тогда вы можете сделать <ItemLink id="crank" /> и поставить его на нужный ускоритель

Автоматическая добыча истинного кварца [описана здесь](example-setups/simple-certus-farm.md).

## Небольшое замечание по поводу Флюиса

Другой материал, который вам понадобится это Флюис, который вы уже использовали для создания ускорителей роста. Флюисовые кристаллы получается если кинуть заряженный истинный кварц, редстоун и незерский кварц в воду. Выполнение этого автоматически «остается в качестве упражнения для читателя».

<ItemLink id="charger" /> необходим для производства <ItemLink id="charged_certus_quartz_crystal" />, сообщаем это вам, в случае если вы не сделали Зарядник сами.

## Вырезание нескольких процессоров

В вашей добыче с метеорита вы найдёте 4 печати для вырезателя со сломанного Таинственного куба. Они используются в <ItemLink id="inscriber" /> для создания 3 типов процессоров. 

<ItemGrid>
  <ItemIcon id="silicon_press" />

  <ItemIcon id="logic_processor_press" />

  <ItemIcon id="calculation_processor_press" />

  <ItemIcon id="engineering_processor_press" />
</ItemGrid>

Вырезатель - это двусторонняя машина, такая же, как ванильная печь. При вставке сверху или снизу предметы помещаются в верхние или нижние слоты, а при вставке сбоку или сзади - в центральный слот. Результаты можно вытащить сбоку или сзади.

Чтобы облегчить автоматизацию работы с воронками (и, возможно, уменьшить количество "спагетти" из труб), вырезатели можно поворачивать с помощью <ItemLink id="certus_quartz_wrench" />.

Произведите несколько процессоров каждого типа, чтобы подготовиться к следующему шагу - созданию базовой MЭ сети. Автоматизация производства процессоров "оставлена на усмотрение читателя"

## Технология Материя Энергия: МЭ Сети и Хранилище

### Что такое МЭ Хранилище?

Оно произносится как Эм-Йе, и расшифровывается как Материя Энергия (я хз как это иначе переводить)

Материя Энергия это главный компонент Applied Energistics 2, это как будто Мульти-Блочный сундук, но версия от Сумасшедшего учённого. Оно с ног на голову переворачивает вашу ситуацию с хранением предметов. МЭ крайне сильно отличается от других систем хранения в Minecraft и может потребовать немного нестандартного мышления, чтобы его использовать. Однако как только вы начнёте так размышлять, вы поймёте, что огромные объёмы памяти в крошечном пространстве и множество терминалов пользования - это всего лишь вершина айсберга того, что становится возможным благодаря AE2.

### Что мне следует знать для начала?

Для начала, МЭ хранит вещи внутри других вещей, называемых [Ячейкой хранения](items-blocks-machines/storage_cells.md); Всего существует 5 уровней, с постепенным увеличением количества хранимых предметов. Кстати, чтобы использовать Ячейки Хранения вам необходимо поместить их внутрь либо <ItemLink id="chest" />, либо же <ItemLink id="drive" />.

<ItemLink id="chest" /> показывает содержимое ячейки, как только она помещается внутрь, и вы можете добавлять и удалять из нее предметы, как если бы это был <ItemLink id="minecraft:chest" />, за исключением того, что предметы хранятся в ячейках хранилища, а не в самом <ItemLink id="chest" />.

Хотя <ItemLink id="chest" /> - это отличный способ познакомиться с концепцией ME, чтобы действительно воспользоваться преимуществами, вам нужно создать [МЭ Сеть](ae2-mechanics/me-network-connections.md).

## Ваша самая первая МЭ Сеть

Сейчас, после того как у вас появились базовые материалы и машины из Applied Energistics 2, вы можете сделать вашу первую МЭ (Материя Энергия) сеть. Она будет самой базовой, без автокрафта, без логистики, просто красивое, простое, хранилище с возможностью поиска.

<GameScene zoom="6" interactive={true}>
<ImportStructure src="assets/assemblies/tiny_me_system.snbt" />

</GameScene>

*   Ваш лист ингредиентов:
    * 1x <ItemLink id="drive" />
    * 1x <ItemLink id="terminal" /> или <ItemLink id="crafting_terminal" />
    * 1x <ItemLink id="energy_acceptor" />
    * Несколько [кабелей](items-blocks-machines/cables.md), неважно стеклянных, покрытых или умных
    * Несколько [ячеек хранения](items-blocks-machines/storage_cells.md), рекомендуется 4k для хорошего сочетания емкости и типов (эффективнее было бы [раздел](items-blocks-machines/cell_workbench.md) смесь 4k и 1k, но это сложности, которые мы не будем сейчас рассматривать)
---
1.  Положите диск.
2.  Приёмник энергии (и некоторые другие AE2 [устройства](ae2-mechanics/devices.md)) выпускаются в двух режимах - кубическом и плоском. Между ними можно переключаться в сетке крафта. Если ваш приемник энергии - куб, положите его рядом с накопителем. Если это плоский квадрат, положите на накопитель кабель и поместите на него приёмник.
3.  Запустите энергию в приемник энергии с помощью кабеля/трубы из вашего любимого мода на генерацию энергии.
4.  Положите кабель поверх накопителя (или на уровне глаз) и поместите на него свой терминал или терминал изготовления.
5.  Поместите ячейки хранения в накопитель.
6.  Профит
7.  Повозитесь с настройками терминала
8.  Наслаждайтесь своей невероятной силой и способностями
9.  Осознайте, что эта сеть, по большому счету, довольно мала.

### Расширение вашей сети

Итак, у вас есть базовое хранилище и доступ к нему, это хорошее начало, но, скорее всего, вы захотите автоматизировать некоторые процессы.

Отличный пример - разместить <ItemLink id="export_bus" /> на вершине печи, чтобы
сбрасывать руду, а <ItemLink id="import_bus" />
в нижней части печи для извлечения готовых слитков из печи.

<ItemLink id="export_bus" /> позволяет экспортировать предметы из сети в прикрепленный инвентарь, а <ItemLink id="import_bus" /> импортирует предметы из присоединенного инвентаря в сеть.

### Преодоление лимитов

На данный момент вы, вероятно, приближаетесь к 8 или около того [устройств](ae2-mechanics/devices.md), как только вы достигнете 9 устройств, вам придется начать управлять [каналами](ae2-mechanics/channels.md). Многие устройства, но не все, требуют наличия канала для функционирования.

По умолчанию сеть поддерживает 8 каналов, если вы нарушите этот лимит, вам придется добавить <ItemLink id="controller" /> в вашу сеть, это позволит вам значительно расширить её. [Умные кабели](items-blocks-machines/cables.md) позволят вам увидеть, как каналы направляются по вашей сети. Используйте их в самом начале, чтобы узнать, как работают каналы, или если у вас много редстоуна и светящегося камня.
