/*
 * Decompiled with CFR 0.152.
 */
package me.gonkas.playernametags;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.UUID;
import me.gonkas.playernametags.commands.ConfigCommand;
import me.gonkas.playernametags.commands.NameTagCommand;
import me.gonkas.playernametags.handlers.ConfigHandler;
import me.gonkas.playernametags.handlers.NameTagHandler;
import me.gonkas.playernametags.util.Strings;
import me.gonkas.playernametags.util.TextType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public final class PlayerNameTags
extends JavaPlugin {
    public static PlayerNameTags INSTANCE;
    public static boolean PLUGINISLOADED;
    public static ConsoleCommandSender CONSOLE;
    private static final String PLUGINPREFIX = "[PlayerNameTags/";
    private static final String ERRORPREFIX = "\u00a7c[PlayerNameTags/ERROR] ";
    private static final String INFOPREFIX = "\u00a77[PlayerNameTags/INFO] ";
    private static final String WARNPREFIX = "\u00a7e[PlayerNameTags/WARN] ";
    public static File PLUGINFOLDER;
    public static File BACKUPSFOLDER;
    public static File NAMETAGSFOLDER;
    public static FileConfiguration CONFIG;
    public static final int NAMEFILEVERSION = 1;
    public static ScoreboardManager SCOREBOARDMANAGER;
    public static Scoreboard MAINSCOREBOARD;
    public static Team TEAM;
    private static boolean requestNamefileBackup;

    public void onEnable() {
        INSTANCE = this;
        this.saveDefaultConfig();
        this.reloadConfig();
        CONFIG = this.getConfig();
        CONSOLE = Bukkit.getConsoleSender();
        if (!PLUGINFOLDER.exists()) {
            PLUGINFOLDER.mkdir();
        }
        if (!BACKUPSFOLDER.exists()) {
            BACKUPSFOLDER.mkdir();
        }
        if (!NAMETAGSFOLDER.exists()) {
            NAMETAGSFOLDER.mkdir();
        }
        this.getCommand("pntconfig").setExecutor((CommandExecutor)new ConfigCommand());
        this.getCommand("nametag").setExecutor((CommandExecutor)new NameTagCommand());
        if (!CONFIG.getBoolean("enable-plugin")) {
            PlayerNameTags.consoleError("Plugin is disabled! Use '/pntconfig set enable-plugin true' to enable the plugin!", new String[0]);
            return;
        }
        PlayerNameTags.load();
    }

    public static void load() {
        if (PLUGINISLOADED) {
            return;
        }
        PlayerNameTags.consoleInfo("Loading plugin...", new String[0]);
        ConfigHandler.load();
        PlayerNameTags.updateNameFileSystem();
        SCOREBOARDMANAGER = Bukkit.getScoreboardManager();
        MAINSCOREBOARD = SCOREBOARDMANAGER.getMainScoreboard();
        TEAM = MAINSCOREBOARD.getTeam("PlayerNameTags");
        if (TEAM == null) {
            TEAM = MAINSCOREBOARD.registerNewTeam("PlayerNameTags");
        }
        Bukkit.getOnlinePlayers().forEach(p -> TEAM.addPlayer((OfflinePlayer)p));
        TEAM.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        TEAM.setCanSeeFriendlyInvisibles(false);
        NameTagHandler.load();
        Bukkit.getPluginManager().registerEvents((Listener)new NameTagHandler(), (Plugin)INSTANCE);
        PlayerNameTags.consoleInfo("Loaded successfully.", new String[0]);
        PLUGINISLOADED = true;
    }

    public void onDisable() {
        PlayerNameTags.unload();
    }

    public static void unload() {
        if (!PLUGINISLOADED) {
            return;
        }
        NameTagHandler.unload();
        ConfigHandler.unload();
        TEAM.unregister();
        INSTANCE.saveConfig();
        PLUGINISLOADED = false;
    }

    public static void enable() {
        CONFIG.set("enable-plugin", (Object)true);
        INSTANCE.saveConfig();
        PlayerNameTags.load();
    }

    public static void disable() {
        PlayerNameTags.consoleError("Disabling plugin! Use '/pntconfig enable-plugin true' to re-enable the plugin!", new String[0]);
        CONFIG.set("enable-plugin", (Object)false);
        PlayerNameTags.unload();
    }

    public static void consoleError(String message, String ... args) {
        CONSOLE.sendMessage(String.format(ERRORPREFIX + message, args));
    }

    public static void consoleInfo(String message, String ... args) {
        CONSOLE.sendMessage(String.format(INFOPREFIX + message, args));
    }

    public static void consoleWarn(String message, String ... args) {
        CONSOLE.sendMessage(String.format(WARNPREFIX + message, args));
    }

    private static void updateNameFileSystem() {
        File old_namefile = new File(PLUGINFOLDER, "player_names.yml");
        if (!old_namefile.exists()) {
            return;
        }
        PlayerNameTags.consoleWarn("Old namefile detected! Updating to new nametag file system...", new String[0]);
        YamlConfiguration nametags = YamlConfiguration.loadConfiguration((File)old_namefile);
        nametags.getValues(false).forEach((path, value) -> {
            try {
                UUID.fromString(path);
            }
            catch (IllegalArgumentException e) {
                return;
            }
            File new_namefile = new File(NAMETAGSFOLDER, path + ".yml");
            YamlConfiguration nametag = YamlConfiguration.loadConfiguration((File)new_namefile);
            if (!nametags.contains(path + ".prefix") || Strings.formatText(nametags.getString(path + ".prefix"), TextType.PREFIX) == null) {
                nametag.set("prefix", (Object)"");
            } else {
                nametag.set("prefix", (Object)nametags.getString(path + ".prefix"));
            }
            if (!nametags.contains(path + ".name") || Strings.formatText(nametags.getString(path + ".name"), TextType.NAME) == null) {
                nametag.set("name", (Object)(Bukkit.getOfflinePlayer((UUID)UUID.fromString(path)).getName() + "\u00a7r"));
            } else {
                nametag.set("name", (Object)nametags.getString(path + ".name"));
            }
            if (!nametags.contains(path + ".suffix") || Strings.formatText(nametags.getString(path + ".suffix"), TextType.SUFFIX) == null) {
                nametag.set("suffix", (Object)"");
            } else {
                nametag.set("suffix", (Object)nametags.getString(path + ".suffix"));
            }
            if (!nametags.contains(path + ".hidden") || !(nametags.get(path + ".hidden") instanceof Boolean)) {
                nametag.set("hidden", (Object)false);
            } else {
                nametag.set("hidden", (Object)nametags.getBoolean(path + ".hidden"));
            }
            try {
                nametag.save(new_namefile);
            }
            catch (IOException ignored) {
                requestNamefileBackup = true;
            }
        });
        if (requestNamefileBackup) {
            PlayerNameTags.consoleError("Some nametags were not updated properly! Creating old system backup...", new String[0]);
            File namefile_backups_folder = new File(BACKUPSFOLDER, "old_namefiles");
            if (!namefile_backups_folder.exists()) {
                namefile_backups_folder.mkdir();
            }
            String filename = "namefile_" + Instant.now().toString().split("\\.")[0].replaceAll(":", ".") + ".yml";
            try {
                Files.copy(old_namefile.toPath(), new File(namefile_backups_folder, filename).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                PlayerNameTags.consoleError("Unable to create backup! Cancelling namefile deletion. Please update manually or delete the file.", new String[0]);
                return;
            }
            PlayerNameTags.consoleWarn("Created backup successfully. Deleting old namefile...", new String[0]);
        }
        if (!old_namefile.delete()) {
            PlayerNameTags.consoleError("Unable to delete old namefile! Please delete it manually.", new String[0]);
        } else {
            PlayerNameTags.consoleInfo("Successfully deleted old namefile", new String[0]);
        }
    }

    static {
        PLUGINISLOADED = false;
        PLUGINFOLDER = new File("plugins/PlayerNameTags");
        BACKUPSFOLDER = new File(PLUGINFOLDER, "backups");
        NAMETAGSFOLDER = new File(PLUGINFOLDER, "nametags");
        requestNamefileBackup = false;
    }
}

