/*
 * Decompiled with CFR 0.152.
 */
package me.gonkas.playernametags.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.gonkas.playernametags.PlayerNameTags;
import me.gonkas.playernametags.handlers.ConfigHandler;
import me.gonkas.playernametags.util.Strings;
import me.gonkas.playernametags.util.TextType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class NameTagHandler
implements Listener {
    private static final HashMap<Player, ArrayList<String>> PLAYERNAMES = new HashMap(0);
    private static final HashMap<Player, Boolean> PLAYERNAMESTOGGLE = new HashMap(0);
    private static final HashMap<Player, ArmorStand> PLAYERSTANDS = new HashMap(0);
    private static final HashMap<String, Map<TextType, String>> OFFLINEPLAYERNAMES = new HashMap(0);
    private static final HashMap<String, Boolean> OFFLINEPLAYERTOGGLE = new HashMap(0);

    public static void load() {
        Bukkit.getOnlinePlayers().forEach(NameTagHandler::loadPlayer);
    }

    public static void unload() {
        Bukkit.getOnlinePlayers().forEach(NameTagHandler::unloadPlayer);
        PlayerNameTags.consoleWarn("Saving all queued offline players' nametags...", new String[0]);
        OFFLINEPLAYERNAMES.forEach((p, v) -> NameTagHandler.createNameTagConfig(p, v, NameTagHandler.isHidden(p)));
        PlayerNameTags.consoleInfo("Finished saving offline players' nametags.", new String[0]);
    }

    private static void loadPlayer(Player player) {
        File namefile = NameTagHandler.getNameFile((OfflinePlayer)player);
        if (namefile == null) {
            return;
        }
        YamlConfiguration nametag = YamlConfiguration.loadConfiguration((File)namefile);
        String prefix = NameTagHandler.getPrefix(player.getName()).isEmpty() ? nametag.getString("prefix") : NameTagHandler.getPrefix(player.getName());
        String name = NameTagHandler.getName(player.getName()).isEmpty() ? nametag.getString("name") : NameTagHandler.getName(player.getName());
        String suffix = NameTagHandler.getSuffix(player.getName()).isEmpty() ? nametag.getString("suffix") : NameTagHandler.getSuffix(player.getName());
        boolean hidden = !OFFLINEPLAYERTOGGLE.containsKey(player.getName()) ? nametag.getBoolean("hidden") : NameTagHandler.isHidden(player.getName());
        OFFLINEPLAYERNAMES.remove(player.getName());
        OFFLINEPLAYERTOGGLE.remove(player.getName());
        if (prefix == null || name == null || suffix == null) {
            PlayerNameTags.consoleError("Unable to load player %s's namefile! Creating backup...", player.getName());
            String filename = String.valueOf(player.getUniqueId()) + "_" + Instant.now().toString().split("\\.")[0].replaceAll(":", ".") + ".yml";
            try {
                Files.copy(namefile.toPath(), new File(PlayerNameTags.BACKUPSFOLDER, filename).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                PlayerNameTags.consoleError("Unable to create backup! Cancelling namefile load. Please create the file manually or restart the plugin.", new String[0]);
                return;
            }
            PlayerNameTags.consoleInfo("Created backup successfully. Deleting name file...", new String[0]);
            if (!namefile.delete()) {
                PlayerNameTags.consoleError("Unable to delete name file! Please delete it manually and restart the server.", new String[0]);
                return;
            }
            PlayerNameTags.consoleInfo("Successfully deleted player %s's name file. Reloading player...", player.getName());
            NameTagHandler.loadPlayer(player);
            return;
        }
        NameTagHandler.createNameTag(player, prefix, name, suffix, hidden);
        PlayerNameTags.consoleInfo("Creating Name Tag for player '%s'.", player.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unloadPlayer(Player player) {
        if (!NameTagHandler.hasName(player)) {
            return;
        }
        File namefile = new File(PlayerNameTags.NAMETAGSFOLDER, String.valueOf(player.getUniqueId()) + ".yml");
        YamlConfiguration nametag = YamlConfiguration.loadConfiguration((File)namefile);
        nametag.set("version", (Object)1);
        nametag.set("prefix", (Object)NameTagHandler.getPrefix(player));
        nametag.set("name", (Object)NameTagHandler.getName(player));
        nametag.set("suffix", (Object)NameTagHandler.getSuffix(player));
        nametag.set("hidden", (Object)NameTagHandler.isNameTagToggled(player));
        PlayerNameTags.consoleInfo("Attempting to save player name for '%s'.", player.getName());
        try {
            nametag.save(namefile);
        }
        catch (IOException e) {
            PlayerNameTags.consoleError("Unable to save player name file!", new String[0]);
        }
        finally {
            PlayerNameTags.consoleInfo("Successfully saved player name file.", new String[0]);
        }
        PLAYERNAMES.remove(player);
        PLAYERNAMESTOGGLE.remove(player);
        PLAYERSTANDS.get(player).remove();
        PLAYERSTANDS.remove(player);
        player.playerListName((Component)Component.text((String)player.getName()));
        player.displayName((Component)Component.text((String)player.getName()));
        PlayerNameTags.TEAM.removePlayer((OfflinePlayer)player);
        PlayerNameTags.consoleInfo("Deleted name tag entity for player '%s'.", player.getName());
    }

    private static void createNameTag(Player player, String prefix, String name, String suffix, boolean isNameTagHidden) {
        if (PLAYERSTANDS.containsKey(player)) {
            return;
        }
        TextComponent nick = Component.text((String)(prefix + (prefix.isEmpty() ? "" : " ") + name + (suffix.isEmpty() ? "" : " ") + suffix));
        ArmorStand stand = (ArmorStand)player.getWorld().spawn(player.getLocation(), ArmorStand.class);
        stand.customName((Component)nick);
        stand.setCustomNameVisible(true);
        stand.setVisible(false);
        stand.setGravity(false);
        stand.getAttribute(Attribute.SCALE).setBaseValue(0.0625);
        if (!player.addPassenger((Entity)stand)) {
            PlayerNameTags.consoleWarn("Unable to anchor armor stand onto player '%s'.", player.getName());
        }
        PLAYERSTANDS.put(player, stand);
        NameTagHandler.setFullName(player, prefix, name, suffix);
        NameTagHandler.forceConfigChanges(player);
        NameTagHandler.toggleNameTag(player, !isNameTagHidden);
        PlayerNameTags.TEAM.addPlayer((OfflinePlayer)player);
        player.playerListName((Component)nick);
        player.displayName((Component)nick);
        PlayerNameTags.consoleInfo("Successfully created Name Tag '%s\u00a7r' for player '%s'.", name, player.getName());
    }

    public static void updateNameTag(Player player) {
        if (!PLAYERNAMES.containsKey(player)) {
            return;
        }
        NameTagHandler.forceConfigChanges(player);
        TextComponent name = Component.text((String)NameTagHandler.getFullName(player));
        PLAYERSTANDS.get(player).customName((Component)name);
        player.playerListName((Component)name);
        player.displayName((Component)name);
        PlayerNameTags.consoleInfo("Updated name tag for player '%s' to '%s\u00a7r'.", player.getName(), NameTagHandler.getFullName(player));
    }

    public static void forceConfigChanges(Player player) {
        List<String> name = List.of(NameTagHandler.getPrefix(player), NameTagHandler.getName(player), NameTagHandler.getSuffix(player));
        name.forEach(Strings::deformatText);
        if (Strings.textLength(name.getFirst()) > ConfigHandler.getMaxPrefixLength() || ConfigHandler.hasInvalidChars(name.getFirst())) {
            NameTagHandler.setPrefix(player, "");
        }
        if (Strings.textLength(name.get(1)) > ConfigHandler.getMaxNameLength() || ConfigHandler.hasInvalidChars(name.get(1))) {
            NameTagHandler.setName(player, player.getName());
        }
        if (Strings.textLength(name.getLast()) > ConfigHandler.getMaxSuffixLength() || ConfigHandler.hasInvalidChars(name.getLast())) {
            NameTagHandler.setSuffix(player, "");
        }
    }

    @EventHandler
    public static void onPlayerJoin(PlayerJoinEvent event) {
        if (!PlayerNameTags.PLUGINISLOADED) {
            return;
        }
        Player player = event.getPlayer();
        NameTagHandler.loadPlayer(player);
        if (event.joinMessage() != null) {
            event.joinMessage(event.joinMessage().replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(player.getName()).replacement(NameTagHandler.getFullName(player)).build()));
        }
    }

    @EventHandler
    public static void onPlayerQuit(PlayerQuitEvent event) {
        if (!PlayerNameTags.PLUGINISLOADED) {
            return;
        }
        Player player = event.getPlayer();
        if (event.quitMessage() != null) {
            event.quitMessage(event.quitMessage().replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(player.getName()).replacement(NameTagHandler.getFullName(player)).build()));
        }
        NameTagHandler.unloadPlayer(player);
    }

    @EventHandler
    public static void onWorldChange(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        Location to = event.getTo();
        if (to.getWorld() == player.getWorld()) {
            return;
        }
        ArmorStand stand = PLAYERSTANDS.get(player);
        stand.teleport(to);
        Bukkit.getScheduler().runTaskLater((Plugin)PlayerNameTags.INSTANCE, () -> {
            if (!player.addPassenger((Entity)stand)) {
                PlayerNameTags.consoleWarn("Unable to anchor armor stand onto player '%s'.", player.getName());
            }
        }, 10L);
    }

    @EventHandler
    public static void onPlayerCrouch(PlayerToggleSneakEvent event) {
        if (!PlayerNameTags.PLUGINISLOADED) {
            return;
        }
        Player player = event.getPlayer();
        if (event.isCancelled() || player.isInvisible() || player.isFlying() || NameTagHandler.isNameTagToggled(player)) {
            return;
        }
        if (PLAYERSTANDS.containsKey(event.getPlayer())) {
            NameTagHandler.setNameVisible(event.getPlayer(), event.getPlayer().isSneaking());
        }
    }

    @EventHandler
    public static void onSpectatorMode(PlayerGameModeChangeEvent event) {
        if (!PlayerNameTags.PLUGINISLOADED) {
            return;
        }
        Player player = event.getPlayer();
        if (event.isCancelled() || player.isInvisible() || NameTagHandler.isNameTagToggled(player)) {
            return;
        }
        if (PLAYERSTANDS.containsKey(player)) {
            NameTagHandler.setNameVisible(player, event.getNewGameMode() != GameMode.SPECTATOR);
        }
    }

    @EventHandler
    public static void onPlayerInvis(EntityPotionEffectEvent event) {
        Player player;
        if (!PlayerNameTags.PLUGINISLOADED) {
            return;
        }
        Player player2 = player = event.getEntityType() == EntityType.PLAYER ? (Player)event.getEntity() : null;
        if (player == null) {
            return;
        }
        if (!PLAYERSTANDS.containsKey(player) || event.getModifiedType() != PotionEffectType.INVISIBILITY || NameTagHandler.isNameTagToggled(player)) {
            return;
        }
        if (event.getAction() == EntityPotionEffectEvent.Action.ADDED) {
            NameTagHandler.setNameVisible((Player)event.getEntity(), false);
        } else if (event.getAction() != EntityPotionEffectEvent.Action.CHANGED) {
            NameTagHandler.setNameVisible((Player)event.getEntity(), true);
        }
    }

    @EventHandler
    public static void onPlayerDeath(PlayerDeathEvent event) {
        if (!PlayerNameTags.PLUGINISLOADED) {
            return;
        }
        Player player = event.getPlayer();
        if (event.deathMessage() != null) {
            event.deathMessage(event.deathMessage().replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(player.getName()).replacement(NameTagHandler.getFullName(player)).build()));
        }
    }

    @EventHandler
    public static void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!PlayerNameTags.PLUGINISLOADED) {
            return;
        }
        event.getPlayer().addPassenger((Entity)PLAYERSTANDS.get(event.getPlayer()));
    }

    public static String getPrefix(Player player) {
        return NameTagHandler.hasPrefix(player) ? PLAYERNAMES.get(player).getFirst() : "";
    }

    public static boolean hasPrefix(Player player) {
        return PLAYERNAMES.containsKey(player) && !PLAYERNAMES.get(player).getFirst().isEmpty();
    }

    public static void setPrefix(Player player, String prefix) {
        if (PLAYERNAMES.containsKey(player)) {
            PLAYERNAMES.get(player).set(0, prefix);
        } else {
            PLAYERNAMES.put(player, new ArrayList<String>(List.of(prefix, "", "")));
        }
        NameTagHandler.updateNameTag(player);
    }

    public static String getName(Player player) {
        return NameTagHandler.hasName(player) ? PLAYERNAMES.get(player).get(1) : player.getName();
    }

    public static String getTrueName(Player player) {
        return Strings.deformatText(NameTagHandler.getName(player));
    }

    public static boolean hasName(Player player) {
        return PLAYERNAMES.containsKey(player) && !PLAYERNAMES.get(player).get(1).isEmpty();
    }

    public static void setName(Player player, String name) {
        if (PLAYERNAMES.containsKey(player)) {
            PLAYERNAMES.get(player).set(1, name);
        } else {
            PLAYERNAMES.put(player, new ArrayList<String>(List.of("", name, "")));
        }
        NameTagHandler.updateNameTag(player);
    }

    public static String getSuffix(Player player) {
        return NameTagHandler.hasSuffix(player) ? PLAYERNAMES.get(player).getLast() : "";
    }

    public static boolean hasSuffix(Player player) {
        return PLAYERNAMES.containsKey(player) && !PLAYERNAMES.get(player).getLast().isEmpty();
    }

    public static void setSuffix(Player player, String suffix) {
        if (PLAYERNAMES.containsKey(player)) {
            PLAYERNAMES.get(player).set(2, suffix);
        } else {
            PLAYERNAMES.put(player, new ArrayList<String>(List.of("", "", suffix)));
        }
        NameTagHandler.updateNameTag(player);
    }

    public static String getFullName(Player player) {
        StringBuilder fullname = new StringBuilder(NameTagHandler.getName(player));
        if (NameTagHandler.hasPrefix(player)) {
            fullname.insert(0, NameTagHandler.getPrefix(player) + " ");
        }
        if (NameTagHandler.hasSuffix(player)) {
            fullname.append(" ").append(NameTagHandler.getSuffix(player));
        }
        return fullname.toString();
    }

    public static void setFullName(Player player, String prefix, String name, String suffix) {
        NameTagHandler.setPrefix(player, prefix);
        NameTagHandler.setName(player, name);
        NameTagHandler.setSuffix(player, suffix);
    }

    public static boolean isNameVisible(Player player) {
        return PLAYERSTANDS.containsKey(player) ? PLAYERSTANDS.get(player).isCustomNameVisible() : player.isInvisible();
    }

    public static void setNameVisible(Player player, boolean bool) {
        if (PLAYERSTANDS.containsKey(player)) {
            PLAYERSTANDS.get(player).setCustomNameVisible(bool);
        }
    }

    public static boolean isNameTagToggled(Player player) {
        return PLAYERNAMESTOGGLE.containsKey(player) && PLAYERNAMESTOGGLE.get(player) == false;
    }

    public static void toggleNameTag(Player player, boolean bool) {
        if (PLAYERNAMESTOGGLE.containsKey(player)) {
            PLAYERNAMESTOGGLE.replace(player, bool);
            NameTagHandler.setNameVisible(player, bool);
        } else {
            PLAYERNAMESTOGGLE.put(player, bool);
            NameTagHandler.setNameVisible(player, bool);
        }
    }

    public static void toggleNameTag(Player player) {
        NameTagHandler.toggleNameTag(player, PLAYERNAMESTOGGLE.get(player) == false);
    }

    public static File getNameFile(OfflinePlayer player) {
        File file = new File(PlayerNameTags.NAMETAGSFOLDER, String.valueOf(player.getUniqueId()) + ".yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
                if (player instanceof Player) {
                    NameTagHandler.createNameTagConfig(player.getPlayer());
                }
            }
            catch (IOException e) {
                PlayerNameTags.consoleError("Unable to create player %s's namefile!", player.getName());
                return null;
            }
        }
        return file;
    }

    public static boolean hasNameFile(OfflinePlayer player) {
        return new File(PlayerNameTags.NAMETAGSFOLDER, String.valueOf(player.getUniqueId()) + ".yml").exists();
    }

    public static String getFromFile(OfflinePlayer player, TextType text) {
        if (!NameTagHandler.hasNameFile(player)) {
            return null;
        }
        YamlConfiguration nametag = YamlConfiguration.loadConfiguration((File)NameTagHandler.getNameFile(player));
        return switch (text) {
            default -> throw new MatchException(null, null);
            case TextType.NAME -> nametag.getString("name");
            case TextType.PREFIX -> nametag.getString("prefix");
            case TextType.SUFFIX -> nametag.getString("suffix");
        };
    }

    public static void createNameTagConfig(Player player) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)NameTagHandler.getNameFile((OfflinePlayer)player));
        config.set("prefix", (Object)"");
        config.set("name", (Object)player.getName());
        config.set("suffix", (Object)"");
        config.set("hidden", (Object)false);
        NameTagHandler.saveNameTagConfig((OfflinePlayer)player, config);
    }

    public static void createNameTagConfig(String offline_player_name, Map<TextType, String> nametag, boolean hidden) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)offline_player_name);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)NameTagHandler.getNameFile(player));
        config.set("prefix", (Object)(nametag.get((Object)TextType.PREFIX) != null ? nametag.get((Object)TextType.PREFIX) : ""));
        config.set("name", nametag.get((Object)TextType.NAME) != null ? nametag.get((Object)TextType.NAME) : player.getName() + "\u00a7r");
        config.set("suffix", (Object)(nametag.get((Object)TextType.SUFFIX) != null ? nametag.get((Object)TextType.SUFFIX) : ""));
        config.set("hidden", (Object)hidden);
        NameTagHandler.saveNameTagConfig(player, config);
    }

    public static void saveNameTagConfig(OfflinePlayer player, YamlConfiguration config) {
        try {
            config.save(NameTagHandler.getNameFile(player));
        }
        catch (IOException e) {
            PlayerNameTags.consoleError("Unable to save player %s's namefile!", player.getName());
        }
    }

    public static String getPrefix(String offline_player_name) {
        if (!OFFLINEPLAYERNAMES.containsKey(offline_player_name) || !OFFLINEPLAYERNAMES.get(offline_player_name).containsKey((Object)TextType.PREFIX)) {
            return "";
        }
        return OFFLINEPLAYERNAMES.get(offline_player_name).get((Object)TextType.PREFIX);
    }

    public static String getName(String offline_player_name) {
        if (!OFFLINEPLAYERNAMES.containsKey(offline_player_name) || !OFFLINEPLAYERNAMES.get(offline_player_name).containsKey((Object)TextType.NAME)) {
            return "";
        }
        return OFFLINEPLAYERNAMES.get(offline_player_name).get((Object)TextType.NAME);
    }

    public static String getSuffix(String offline_player_name) {
        if (!OFFLINEPLAYERNAMES.containsKey(offline_player_name) || !OFFLINEPLAYERNAMES.get(offline_player_name).containsKey((Object)TextType.SUFFIX)) {
            return "";
        }
        return OFFLINEPLAYERNAMES.get(offline_player_name).get((Object)TextType.SUFFIX);
    }

    public static boolean isHidden(String offline_player_name) {
        return OFFLINEPLAYERTOGGLE.containsKey(offline_player_name) && OFFLINEPLAYERTOGGLE.get(offline_player_name) != false;
    }

    public static String getFullName(String offline_player_name) {
        StringBuilder fullname = new StringBuilder(NameTagHandler.getName(offline_player_name));
        if (!NameTagHandler.getPrefix(offline_player_name).isEmpty()) {
            fullname.insert(0, NameTagHandler.getPrefix(offline_player_name) + " ");
        }
        if (!NameTagHandler.getSuffix(offline_player_name).isEmpty()) {
            fullname.append(" ").append(NameTagHandler.getSuffix(offline_player_name));
        }
        return fullname.toString();
    }

    public static void setPrefix(String offline_player_name, String prefix) {
        if (OFFLINEPLAYERNAMES.containsKey(offline_player_name)) {
            if (OFFLINEPLAYERNAMES.get(offline_player_name).containsKey((Object)TextType.PREFIX)) {
                OFFLINEPLAYERNAMES.get(offline_player_name).replace(TextType.PREFIX, prefix);
            } else {
                OFFLINEPLAYERNAMES.get(offline_player_name).put(TextType.PREFIX, prefix);
            }
        } else {
            OFFLINEPLAYERNAMES.put(offline_player_name, new HashMap<TextType, String>(Map.of(TextType.PREFIX, prefix)));
        }
    }

    public static void setName(String offline_player_name, String name) {
        if (OFFLINEPLAYERNAMES.containsKey(offline_player_name)) {
            if (OFFLINEPLAYERNAMES.get(offline_player_name).containsKey((Object)TextType.NAME)) {
                OFFLINEPLAYERNAMES.get(offline_player_name).replace(TextType.NAME, name);
            } else {
                OFFLINEPLAYERNAMES.get(offline_player_name).put(TextType.NAME, name);
            }
        } else {
            OFFLINEPLAYERNAMES.put(offline_player_name, new HashMap<TextType, String>(Map.of(TextType.NAME, name)));
        }
    }

    public static void setSuffix(String offline_player_name, String suffix) {
        if (OFFLINEPLAYERNAMES.containsKey(offline_player_name)) {
            if (OFFLINEPLAYERNAMES.get(offline_player_name).containsKey((Object)TextType.SUFFIX)) {
                OFFLINEPLAYERNAMES.get(offline_player_name).replace(TextType.SUFFIX, suffix);
            } else {
                OFFLINEPLAYERNAMES.get(offline_player_name).put(TextType.SUFFIX, suffix);
            }
        } else {
            OFFLINEPLAYERNAMES.put(offline_player_name, new HashMap<TextType, String>(Map.of(TextType.SUFFIX, suffix)));
        }
    }

    public static void setHidden(String offline_player_name, boolean hidden) {
        if (OFFLINEPLAYERTOGGLE.containsKey(offline_player_name)) {
            OFFLINEPLAYERTOGGLE.replace(offline_player_name, hidden);
        } else {
            OFFLINEPLAYERTOGGLE.put(offline_player_name, hidden);
        }
    }
}

