/*
 * Decompiled with CFR 0.152.
 */
package me.gonkas.playernametags.commands;

import java.util.List;
import java.util.stream.Stream;
import me.gonkas.playernametags.PlayerNameTags;
import me.gonkas.playernametags.handlers.ConfigHandler;
import me.gonkas.playernametags.handlers.NameTagHandler;
import me.gonkas.playernametags.util.ConfigVarType;
import me.gonkas.playernametags.util.Strings;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigCommand
implements CommandExecutor,
TabCompleter {
    private static final String ENABLECOLORS = "enable-colors";
    private static final String ENABLEFORMATTING = "enable-formatting";
    private static final String ENABLEPLUGIN = "enable-plugin";
    private static final String MAXNAMELENGTH = "max-name-length";
    private static final String MAXPREFIXLENGTH = "max-prefix-length";
    private static final String MAXSUFFIXLENGTH = "max-suffix-length";
    private static final String VALIDNAMECHARACTERS = "valid-name-characters";
    private static final List<String> SUBCOMMANDS = List.of("get", "preset", "reset", "set");
    private static final List<String> OPTIONS = List.of("enable-colors", "enable-formatting", "enable-plugin", "max-name-length", "max-prefix-length", "max-suffix-length", "valid-name-characters");
    private static final List<String> BOOLEANPRESETS = List.of("ENABLED", "DISABLED", "DEFAULT");
    private static final List<String> TEXTLENGTHPRESETS = List.of("DEFAULT", "MINECRAFT_LENGTH", "HALF_MINECRAFT_LENGTH", "UNLIMITED");
    private static final List<String> CHARSPRESETS = List.of("DEFAULT", "ALL_CHARACTERS", "MINECRAFT", "DEFAULT_NO_SPACES", "DEFAULT_LOWERCASE", "DEFAULT_UPPERCASE", "DEFAULT_NO_LETTERS", "LETTERS_ONLY", "LETTERS_ONLY_LOWERCASE", "LETTERS_ONLY_UPPERCASE", "NUMBERS_ONLY", "SPECIAL_CHARACTERS_ONLY");

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        if (sender == null) {
            ConfigCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            ConfigCommand.$$$reportNull$$$0(1);
        }
        if (s == null) {
            ConfigCommand.$$$reportNull$$$0(2);
        }
        if (args == null) {
            ConfigCommand.$$$reportNull$$$0(3);
        }
        if (!PlayerNameTags.PLUGINISLOADED) {
            if (args[1].equals(ENABLEPLUGIN) && (args[0].equals("preset") && args[2].equals("ENABLED") || args[0].equals("reset") || args[0].equals("set") && args[2].equals("true"))) {
                sender.sendMessage("\u00a7aEnabling PlayerNameTags!");
                PlayerNameTags.enable();
            } else {
                sender.sendMessage("\u00a7cPlugin PlayerNameTags is disabled! Enable using '/pntconfig reset enable-plugin', '/pntconfig set enable-plugin true', or '/pntconfig preset enable-plugin ENABLED'.");
            }
            return true;
        }
        if (args.length == 0 || !SUBCOMMANDS.contains(args[0])) {
            sender.sendMessage("\u00a7cInvalid command usage! Use '/pntconfig <get|preset|reset|set> <option>'.");
            return true;
        }
        if (args.length == 1 || !OPTIONS.contains(args[1])) {
            sender.sendMessage("\u00a7cInvalid sub-command usage! Use '/pntconfig " + args[0] + "<option>" + (String)(args[0].equals("reset") ? "" : "<" + (args[0].equals("set") ? "value" : args[0]) + ">") + ".");
            return true;
        }
        switch (args[0]) {
            case "get": {
                switch (args[1]) {
                    case "enable-colors": {
                        sender.sendMessage(ConfigHandler.getAllowColors() ? "\u00a7aColors are enabled." : "\u00a7cColors are disabled.");
                        break;
                    }
                    case "enable-formatting": {
                        sender.sendMessage(ConfigHandler.getAllowFormatting() ? "\u00a7aFormatting is enabled." : "\u00a7cFormatting is disabled.");
                        break;
                    }
                    case "enable-plugin": {
                        sender.sendMessage("\u00a7aPlugin is enabled.");
                        break;
                    }
                    case "max-name-length": {
                        sender.sendMessage("\u00a7aMaximum name length is " + String.valueOf(ConfigHandler.getMaxNameLength() == Integer.MAX_VALUE ? "unlimited" : Integer.valueOf(ConfigHandler.getMaxNameLength())) + ".");
                        break;
                    }
                    case "max-prefix-length": {
                        sender.sendMessage("\u00a7aMaximum prefix length is " + String.valueOf(ConfigHandler.getMaxPrefixLength() == Integer.MAX_VALUE ? "unlimited" : Integer.valueOf(ConfigHandler.getMaxPrefixLength())) + ".");
                        break;
                    }
                    case "max-suffix-length": {
                        sender.sendMessage("\u00a7aMaximum suffix length is " + String.valueOf(ConfigHandler.getMaxSuffixLength() == Integer.MAX_VALUE ? "unlimited" : Integer.valueOf(ConfigHandler.getMaxSuffixLength())) + ".");
                        break;
                    }
                    case "valid-name-characters": {
                        sender.sendMessage("\u00a7aValid text characters are \"" + ConfigHandler.getValidChars() + "\".");
                    }
                }
                break;
            }
            case "preset": {
                if (args.length == 2) {
                    sender.sendMessage("\u00a7cInvalid preset given! Match the presets displayed during command usage.");
                    return true;
                }
                block39 : switch (args[1]) {
                    case "enable-colors": {
                        switch (args[2]) {
                            case "ENABLED": 
                            case "DEFAULT": {
                                ConfigHandler.setAllowColors(true);
                                break block39;
                            }
                            case "DISABLED": {
                                ConfigHandler.setAllowColors(false);
                                break block39;
                            }
                        }
                        sender.sendMessage("\u00a7cInvalid preset given! Match the presets displayed during command usage.");
                        return true;
                    }
                    case "enable-formatting": {
                        switch (args[2]) {
                            case "ENABLED": 
                            case "DEFAULT": {
                                ConfigHandler.setAllowFormatting(true);
                                break block39;
                            }
                            case "DISABLED": {
                                ConfigHandler.setAllowFormatting(false);
                                break block39;
                            }
                        }
                        sender.sendMessage("\u00a7cInvalid preset given! Match the presets displayed during command usage.");
                        return true;
                    }
                    case "enable-plugin": {
                        switch (args[2]) {
                            case "ENABLED": 
                            case "DEFAULT": {
                                sender.sendMessage("\u00a7aPlugin already enabled!");
                                return true;
                            }
                            case "DISABLED": {
                                PlayerNameTags.disable();
                                break block39;
                            }
                        }
                        sender.sendMessage("\u00a7cInvalid preset given! Match the presets displayed during command usage.");
                        return true;
                    }
                    case "max-name-length": {
                        switch (args[2]) {
                            case "DEFAULT": {
                                ConfigHandler.setMaxNameLength(24);
                                break block39;
                            }
                            case "MINECRAFT_LENGTH": {
                                ConfigHandler.setMaxNameLength(16);
                                break block39;
                            }
                            case "HALF_MINECRAFT_LENGTH": {
                                ConfigHandler.setMaxNameLength(8);
                                break block39;
                            }
                            case "UNLIMITED": {
                                ConfigHandler.setMaxNameLength(Integer.MAX_VALUE);
                                break block39;
                            }
                        }
                        sender.sendMessage("\u00a7cInvalid preset given! Match the presets displayed during command usage.");
                        return true;
                    }
                    case "max-prefix-length": {
                        switch (args[2]) {
                            case "DEFAULT": {
                                ConfigHandler.setMaxPrefixLength(24);
                                break block39;
                            }
                            case "MINECRAFT_LENGTH": {
                                ConfigHandler.setMaxPrefixLength(16);
                                break block39;
                            }
                            case "HALF_MINECRAFT_LENGTH": {
                                ConfigHandler.setMaxPrefixLength(8);
                                break block39;
                            }
                            case "UNLIMITED": {
                                ConfigHandler.setMaxPrefixLength(Integer.MAX_VALUE);
                                break block39;
                            }
                        }
                        sender.sendMessage("\u00a7cInvalid preset given! Match the presets displayed during command usage.");
                        return true;
                    }
                    case "max-suffix-length": {
                        switch (args[2]) {
                            case "DEFAULT": {
                                ConfigHandler.setMaxSuffixLength(24);
                                break block39;
                            }
                            case "MINECRAFT_LENGTH": {
                                ConfigHandler.setMaxSuffixLength(16);
                                break block39;
                            }
                            case "HALF_MINECRAFT_LENGTH": {
                                ConfigHandler.setMaxSuffixLength(8);
                                break block39;
                            }
                            case "UNLIMITED": {
                                ConfigHandler.setMaxSuffixLength(Integer.MAX_VALUE);
                                break block39;
                            }
                        }
                        sender.sendMessage("\u00a7cInvalid preset given! Match the presets displayed during command usage.");
                        return true;
                    }
                    case "valid-name-characters": {
                        switch (args[2]) {
                            case "DEFAULT": {
                                ConfigHandler.setValidChars("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.,+-/*!?' ");
                                break block39;
                            }
                            case "ALL_CHARACTERS": {
                                ConfigHandler.setValidChars("");
                                break block39;
                            }
                            case "MINECRAFT": {
                                ConfigHandler.setValidChars("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_");
                                break block39;
                            }
                            case "DEFAULT_NO_SPACES": {
                                ConfigHandler.setValidChars("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.,+-/*!?'");
                                break block39;
                            }
                            case "DEFAULT_LOWERCASE": {
                                ConfigHandler.setValidChars("abcdefghijklmnopqrstuvwxyz1234567890_.,+-/*!?' ");
                                break block39;
                            }
                            case "DEFAULT_UPPERCASE": {
                                ConfigHandler.setValidChars("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.,+-/*!?' ");
                                break block39;
                            }
                            case "DEFAULT_NO_LETTERS": {
                                ConfigHandler.setValidChars("1234567890_.,+-/*!?' ");
                                break block39;
                            }
                            case "LETTERS_ONLY": {
                                ConfigHandler.setValidChars("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
                                break block39;
                            }
                            case "LETTERS_ONLY_LOWERCASE": {
                                ConfigHandler.setValidChars("abcdefghijklmnopqrstuvwxyz");
                                break block39;
                            }
                            case "LETTERS_ONLY_UPPERCASE": {
                                ConfigHandler.setValidChars("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
                                break block39;
                            }
                            case "NUMBERS_ONLY": {
                                ConfigHandler.setValidChars("1234567890");
                                break block39;
                            }
                            case "SPECIAL_CHARACTERS_ONLY": {
                                ConfigHandler.setValidChars("_.,+-/*!?' ");
                                break block39;
                            }
                        }
                        sender.sendMessage("\u00a7cInvalid preset given! Match the presets displayed during command usage.");
                        return true;
                    }
                }
                sender.sendMessage("Set " + args[1] + " to preset '" + args[2].toUpperCase() + "'.");
                break;
            }
            case "reset": {
                String string;
                if (args[1].equals(ENABLEPLUGIN)) {
                    sender.sendMessage("\u00a7ePlugin is already enabled!");
                    return true;
                }
                String string2 = string = args[1];
                int n = -1;
                switch (string.hashCode()) {
                    case -617064198: {
                        if (!string.equals(ENABLECOLORS)) break;
                        n = 0;
                        break;
                    }
                    case 715668975: {
                        if (!string.equals(ENABLEFORMATTING)) break;
                        n = 1;
                        break;
                    }
                    case -1330378369: {
                        if (!string.equals(MAXNAMELENGTH)) break;
                        n = 2;
                        break;
                    }
                    case 159392216: {
                        if (!string.equals(MAXPREFIXLENGTH)) break;
                        n = 3;
                        break;
                    }
                    case -2130520007: {
                        if (!string.equals(MAXSUFFIXLENGTH)) break;
                        n = 4;
                        break;
                    }
                    case 1579761435: {
                        if (!string.equals(VALIDNAMECHARACTERS)) break;
                        n = 5;
                    }
                }
                sender.sendMessage("Reset '" + string2 + "' to '" + String.valueOf(switch (n) {
                    case 0 -> ConfigHandler.resetAllowColors();
                    case 1 -> ConfigHandler.resetAllowFormatting();
                    case 2 -> ConfigHandler.resetMaxNameLength();
                    case 3 -> ConfigHandler.resetMaxPrefixLength();
                    case 4 -> ConfigHandler.resetMaxSuffixLength();
                    case 5 -> ConfigHandler.resetValidChars();
                    default -> "";
                }) + "'.");
                break;
            }
            case "set": {
                if (args.length == 2) {
                    sender.sendMessage("\u00a7cInvalid value given! Match the options or value type displayed during command usage.");
                    return true;
                }
                block155 : switch (ConfigVarType.getType(args[2])) {
                    case BOOLEAN: {
                        switch (args[1]) {
                            case "enable-colors": {
                                ConfigHandler.setAllowColors(Boolean.parseBoolean(args[2]));
                                break block155;
                            }
                            case "enable-formatting": {
                                ConfigHandler.setAllowFormatting(Boolean.parseBoolean(args[2]));
                                break block155;
                            }
                            case "enable-plugin": {
                                PlayerNameTags.disable();
                                break block155;
                            }
                            case "valid-name-characters": {
                                ConfigHandler.setValidChars(args[2]);
                                break block155;
                            }
                        }
                        sender.sendMessage("\u00a7cInvalid value given! Match the options or value type displayed during command usage.");
                        break;
                    }
                    case INTEGER: {
                        if (Integer.parseInt(args[2]) <= 0) {
                            sender.sendMessage("\u00a7cText lengths must be at least 1!");
                            return true;
                        }
                        switch (args[1]) {
                            case "max-name-length": {
                                ConfigHandler.setMaxNameLength(Integer.parseInt(args[2]));
                                break block155;
                            }
                            case "max-prefix-length": {
                                ConfigHandler.setMaxPrefixLength(Integer.parseInt(args[2]));
                                break block155;
                            }
                            case "max-suffix-length": {
                                ConfigHandler.setMaxSuffixLength(Integer.parseInt(args[2]));
                                break block155;
                            }
                        }
                        sender.sendMessage("\u00a7cInvalid value given! Match the options or value type displayed during command usage.");
                        break;
                    }
                    case STRING: {
                        if (args[1].equals(VALIDNAMECHARACTERS)) {
                            StringBuilder chars = new StringBuilder(args[2]);
                            for (int i = 3; i < args.length; ++i) {
                                chars.append(args[i]);
                            }
                            ConfigHandler.setValidChars(chars.toString());
                            break;
                        }
                        sender.sendMessage("\u00a7cInvalid value given! Match the options or value type displayed during command usage.");
                    }
                }
                sender.sendMessage("Set '" + args[1] + "' to '" + args[2] + "'.");
            }
        }
        if (!args[0].equals("get")) {
            Bukkit.getOnlinePlayers().forEach(NameTagHandler::updateNameTag);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        if (sender == null) {
            ConfigCommand.$$$reportNull$$$0(4);
        }
        if (command == null) {
            ConfigCommand.$$$reportNull$$$0(5);
        }
        if (s == null) {
            ConfigCommand.$$$reportNull$$$0(6);
        }
        if (args == null) {
            ConfigCommand.$$$reportNull$$$0(7);
        }
        return switch (args.length) {
            case 1 -> SUBCOMMANDS.stream().filter(n -> Strings.containsIgnoreCase(n, args[0])).toList();
            case 2 -> OPTIONS.stream().filter(n -> Strings.containsIgnoreCase(n, args[1])).toList();
            case 3 -> {
                if (args[0].equals("preset")) {
                    switch (args[1]) {
                        case "enable-colors": 
                        case "enable-formatting": 
                        case "enable-plugin": {
                            yield BOOLEANPRESETS.stream().filter(n -> Strings.containsIgnoreCase(n, args[2])).toList();
                        }
                        case "max-name-length": 
                        case "max-prefix-length": 
                        case "max-suffix-length": {
                            yield TEXTLENGTHPRESETS.stream().filter(n -> Strings.containsIgnoreCase(n, args[2])).toList();
                        }
                        case "valid-name-characters": {
                            yield CHARSPRESETS.stream().filter(n -> Strings.containsIgnoreCase(n, args[2])).toList();
                        }
                    }
                    yield List.of();
                }
                if (args[0].equals("set")) {
                    switch (args[1]) {
                        case "enable-colors": 
                        case "enable-formatting": 
                        case "enable-plugin": {
                            yield Stream.of("true", "false").filter(n -> Strings.containsIgnoreCase(n, args[2])).toList();
                        }
                        case "max-name-length": 
                        case "max-prefix-length": 
                        case "max-suffix-length": {
                            yield List.of("<length>");
                        }
                        case "valid-name-characters": {
                            yield List.of("<characters>");
                        }
                    }
                    yield List.of();
                }
                yield List.of();
            }
            default -> List.of();
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "me/gonkas/playernametags/commands/ConfigCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onCommand";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onTabComplete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

