/*
 * Decompiled with CFR 0.152.
 */
package me.gonkas.playernametags.commands;

import java.util.List;
import me.gonkas.playernametags.PlayerNameTags;
import me.gonkas.playernametags.handlers.ConfigHandler;
import me.gonkas.playernametags.handlers.NameTagHandler;
import me.gonkas.playernametags.util.Strings;
import me.gonkas.playernametags.util.TextType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameTagCommand
implements CommandExecutor,
TabCompleter {
    private static final List<String> SUBCOMMANDS = List.of("copy", "get", "reset", "set", "toggle");
    private static final List<String> COMPONENTS = List.of("name", "prefix", "suffix");

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        Player target;
        if (sender == null) {
            NameTagCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            NameTagCommand.$$$reportNull$$$0(1);
        }
        if (s == null) {
            NameTagCommand.$$$reportNull$$$0(2);
        }
        if (args == null) {
            NameTagCommand.$$$reportNull$$$0(3);
        }
        if (!PlayerNameTags.PLUGINISLOADED) {
            sender.sendMessage("\u00a7cPlugin PlayerNameTags is disabled! Enable using '/pntconfig reset enable-plugin', '/pntconfig set enable-plugin true', or '/pntconfig preset enable-plugin ENABLED'.");
            return true;
        }
        if (args.length == 0 || !SUBCOMMANDS.contains(args[0])) {
            sender.sendMessage("\u00a7cInvalid command usage! Use '/nametag <copy|get|reset|set|toggle> <name|prefix|suffix>'.");
            return true;
        }
        if (!(args[0].equals("toggle") || args.length != 1 && COMPONENTS.contains(args[1]))) {
            if (args[0].equals("set")) {
                sender.sendMessage("\u00a7cInvalid sub-command usage! Use '/nametag set <name|prefix|suffix> <player> <text>'.");
            } else if (args[0].equals("copy")) {
                sender.sendMessage("\u00a7cInvalid sub-command usage! Use '/nametag copy <name|prefix|suffix> <source_player> <target_player>'.");
            } else {
                sender.sendMessage("\u00a7cInvalid sub-command usage! Use '/nametag " + args[0] + " <name|prefix|suffix> [player]'.");
            }
            return true;
        }
        int arg_count = 2;
        if (args[0].equals("toggle")) {
            arg_count = 1;
        }
        TextType text_type = null;
        if (!args[0].equals("toggle")) {
            text_type = TextType.valueOf(args[1].toUpperCase());
        }
        if (args[0].equals("copy")) {
            String text = NameTagCommand.getText(sender, args[2], text_type);
            if (text.isEmpty()) {
                return true;
            }
            if (args.length < 4) {
                sender.sendMessage("\u00a7cThis sub-command requires at least 3 arguments! Use '/nametag copy " + args[1] + " <source_player> <target_player>'.");
                return true;
            }
            args[0] = "set";
            args[2] = args[3];
            args[3] = text;
        }
        if (args.length == arg_count) {
            if (sender instanceof ConsoleCommandSender) {
                sender.sendMessage("\u00a7cConsole can not be a player target! Use '/nametag " + args[0] + " " + args[1] + "<player>'.");
                return true;
            }
            if (args[0].equals("set")) {
                sender.sendMessage("\u00a7cThis sub-command requires a player argument! Use '/nametag set " + args[1] + " <player> <text>'.");
                return true;
            }
            target = (Player)sender;
        } else {
            target = Bukkit.getPlayerExact((String)args[arg_count]);
        }
        switch (args[0]) {
            case "get": {
                String text = NameTagCommand.getText(sender, target, args.length >= 3 ? args[2] : "", text_type);
                if (text.isEmpty()) {
                    return true;
                }
                sender.sendMessage("\u00a7aPlayer " + (target != null ? target.getName() : args[2]) + "'s " + args[1] + " is " + text + "\u00a7a.");
                break;
            }
            case "reset": {
                if (target != null) {
                    switch (text_type) {
                        case NAME: {
                            NameTagHandler.setName(target.getPlayer(), target.getName());
                            break;
                        }
                        case PREFIX: {
                            NameTagHandler.setPrefix(target.getPlayer(), "");
                            break;
                        }
                        case SUFFIX: {
                            NameTagHandler.setSuffix(target.getPlayer(), "");
                        }
                    }
                } else {
                    switch (text_type) {
                        case NAME: {
                            NameTagHandler.setName(args[2], args[2]);
                            break;
                        }
                        case PREFIX: {
                            NameTagHandler.setPrefix(args[2], "");
                            break;
                        }
                        case SUFFIX: {
                            NameTagHandler.setSuffix(args[2], "");
                        }
                    }
                }
                sender.sendMessage("Reset player " + (target != null ? target.getName() : args[2]) + "'s " + args[1] + ".");
                break;
            }
            case "set": {
                if (args.length == 3) {
                    sender.sendMessage("\u00a7cInvalid text argument! Use '/nametag set " + args[1] + " " + (target != null ? target.getName() : args[2]) + " <text>'.");
                    return true;
                }
                StringBuilder builder = new StringBuilder(args[3]);
                for (int i = 4; i < args.length; ++i) {
                    builder.append(" ").append(args[i]);
                }
                String text = Strings.formatText(builder.toString(), text_type);
                if (text == null) {
                    sender.sendMessage("\u00a7cInvalid or no characters at all! Use only '" + ConfigHandler.getValidChars() + "'.");
                    return true;
                }
                if (target != null) {
                    switch (text_type) {
                        case NAME: {
                            NameTagHandler.setName(target.getPlayer(), text + "\u00a7r");
                            break;
                        }
                        case PREFIX: {
                            NameTagHandler.setPrefix(target.getPlayer(), text + "\u00a7r");
                            break;
                        }
                        case SUFFIX: {
                            NameTagHandler.setSuffix(target.getPlayer(), text + "\u00a7r");
                        }
                    }
                } else {
                    switch (text_type) {
                        case NAME: {
                            NameTagHandler.setName(args[2], text + "\u00a7r");
                            break;
                        }
                        case PREFIX: {
                            NameTagHandler.setPrefix(args[2], text + "\u00a7r");
                            break;
                        }
                        case SUFFIX: {
                            NameTagHandler.setSuffix(args[2], text + "\u00a7r");
                        }
                    }
                }
                sender.sendMessage("Set player " + (target != null ? target.getName() : args[2]) + "'s " + args[1] + " to " + text + "\u00a7r.");
                break;
            }
            default: {
                if (target != null) {
                    NameTagHandler.toggleNameTag(target.getPlayer());
                    sender.sendMessage("\u00a7a" + NameTagHandler.getFullName(target.getPlayer()) + "'s name tag is now " + (NameTagHandler.isNameTagToggled(target.getPlayer()) ? "hidden" : "visible") + ".");
                    break;
                }
                NameTagHandler.setHidden(args[1], !NameTagHandler.isHidden(args[1]));
                sender.sendMessage("\u00a7a" + NameTagHandler.getFullName(args[1]) + "'s name tag will be " + (NameTagHandler.isHidden(args[1]) ? "hidden" : "visible") + " upon login.");
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        if (commandSender == null) {
            NameTagCommand.$$$reportNull$$$0(4);
        }
        if (command == null) {
            NameTagCommand.$$$reportNull$$$0(5);
        }
        if (s == null) {
            NameTagCommand.$$$reportNull$$$0(6);
        }
        if (args == null) {
            NameTagCommand.$$$reportNull$$$0(7);
        }
        return switch (args.length) {
            case 1 -> SUBCOMMANDS.stream().filter(n -> Strings.containsIgnoreCase(n, args[0])).toList();
            case 2 -> {
                if (args[0].equals("toggle")) {
                    yield Strings.matchOnlinePlayersName(args[1]);
                }
                yield COMPONENTS.stream().filter(n -> Strings.containsIgnoreCase(n, args[1])).toList();
            }
            case 3 -> Strings.matchOnlinePlayersName(args[2]);
            case 4 -> {
                if (args[0].equals("copy")) {
                    yield Strings.matchOnlinePlayersName(args[3]);
                }
                if (args[0].equals("set")) {
                    yield List.of("<text>");
                }
                yield List.of();
            }
            default -> List.of();
        };
    }

    private static String getText(CommandSender sender, String player_name, TextType text_type) {
        Player target = Bukkit.getPlayerExact((String)player_name);
        OfflinePlayer player = Bukkit.getOfflinePlayerIfCached((String)player_name);
        if (target == null && player == null) {
            sender.sendMessage("\u00a7cPlayer is offline and not cached!");
            return "";
        }
        return switch (text_type) {
            default -> throw new MatchException(null, null);
            case TextType.NAME -> {
                if (target != null) {
                    yield NameTagHandler.getName(target.getPlayer());
                }
                yield NameTagHandler.getFromFile(player, TextType.NAME);
            }
            case TextType.PREFIX -> {
                if (target != null) {
                    yield NameTagHandler.getPrefix(target.getPlayer());
                }
                yield NameTagHandler.getFromFile(player, TextType.PREFIX);
            }
            case TextType.SUFFIX -> target != null ? NameTagHandler.getSuffix(target.getPlayer()) : NameTagHandler.getFromFile(player, TextType.SUFFIX);
        };
    }

    private static String getText(CommandSender sender, Player target, String player_name, TextType text_type) {
        OfflinePlayer player = Bukkit.getOfflinePlayerIfCached((String)(player_name.isEmpty() ? target.getName() : player_name));
        if (target == null && player == null) {
            sender.sendMessage("\u00a7cPlayer is offline and not cached!");
            return "";
        }
        return switch (text_type) {
            default -> throw new MatchException(null, null);
            case TextType.NAME -> {
                if (target != null) {
                    yield NameTagHandler.getName(target.getPlayer());
                }
                yield NameTagHandler.getFromFile(player, TextType.NAME);
            }
            case TextType.PREFIX -> {
                if (target != null) {
                    yield NameTagHandler.getPrefix(target.getPlayer());
                }
                yield NameTagHandler.getFromFile(player, TextType.PREFIX);
            }
            case TextType.SUFFIX -> target != null ? NameTagHandler.getSuffix(target.getPlayer()) : NameTagHandler.getFromFile(player, TextType.SUFFIX);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandSender";
                break;
            }
        }
        objectArray2[1] = "me/gonkas/playernametags/commands/NameTagCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onCommand";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onTabComplete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

