/*
 * Decompiled with CFR 0.152.
 */
package me.gonkas.playernametags.handlers;

import java.util.List;
import me.gonkas.playernametags.PlayerNameTags;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigHandler {
    private static String VALIDCHARS;
    private static int MAXNAMELENGTH;
    private static int MAXPREFIXLENGTH;
    private static int MAXSUFFIXLENGTH;
    private static boolean ALLOWCOLORS;
    private static boolean ALLOWFORMATTING;
    private static final String VALIDCHARSPATH = "valid-name-characters";
    private static final String MAXNAMELENGTHPATH = "max-name-length";
    private static final String MAXPREFIXLENGTHPATH = "max-prefix-length";
    private static final String MAXSUFFIXLENGTHPATH = "max-suffix-length";
    private static final String ALLOWCOLORSPATH = "enable-colors";
    private static final String ALLOWFORMATTINGPATH = "enable-formatting";
    private static final String DEFAULTCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.,+-/*!?' ";
    private static final int DEFAULTNAMELENGTH = 16;
    private static final int DEFAULTPREFIXLENGTH = 8;
    private static final int DEFAULTSUFFIXLENGTH = 8;
    private static final boolean DEFAULTALLOWCOLORS = true;
    private static final boolean DEFAULTALLOWFORMATTING = true;

    public static void load() {
        ConfigHandler.fixConfigPaths(PlayerNameTags.CONFIG);
        VALIDCHARS = PlayerNameTags.CONFIG.getString(VALIDCHARSPATH);
        MAXNAMELENGTH = PlayerNameTags.CONFIG.getInt(MAXNAMELENGTHPATH);
        MAXPREFIXLENGTH = PlayerNameTags.CONFIG.getInt(MAXPREFIXLENGTHPATH);
        MAXSUFFIXLENGTH = PlayerNameTags.CONFIG.getInt(MAXSUFFIXLENGTHPATH);
        ALLOWCOLORS = PlayerNameTags.CONFIG.getBoolean(ALLOWCOLORSPATH);
        ALLOWFORMATTING = PlayerNameTags.CONFIG.getBoolean(ALLOWFORMATTINGPATH);
    }

    public static void unload() {
        PlayerNameTags.CONFIG.set(VALIDCHARSPATH, (Object)VALIDCHARS);
        PlayerNameTags.CONFIG.set(MAXNAMELENGTHPATH, (Object)MAXNAMELENGTH);
        PlayerNameTags.CONFIG.set(MAXPREFIXLENGTHPATH, (Object)MAXPREFIXLENGTH);
        PlayerNameTags.CONFIG.set(MAXSUFFIXLENGTHPATH, (Object)MAXSUFFIXLENGTH);
        PlayerNameTags.CONFIG.set(ALLOWCOLORSPATH, (Object)ALLOWCOLORS);
        PlayerNameTags.CONFIG.set(ALLOWFORMATTINGPATH, (Object)ALLOWFORMATTING);
    }

    private static void fixConfigPaths(FileConfiguration config) {
        if (!ConfigHandler.pathIsString(config, VALIDCHARSPATH)) {
            config.set(VALIDCHARSPATH, (Object)DEFAULTCHARS);
        }
        if (!ConfigHandler.pathIsInteger(config, MAXNAMELENGTHPATH)) {
            config.set(MAXNAMELENGTHPATH, (Object)16);
        }
        if (!ConfigHandler.pathIsInteger(config, MAXPREFIXLENGTHPATH)) {
            config.set(MAXPREFIXLENGTHPATH, (Object)8);
        }
        if (!ConfigHandler.pathIsInteger(config, MAXSUFFIXLENGTHPATH)) {
            config.set(MAXSUFFIXLENGTHPATH, (Object)8);
        }
        if (!ConfigHandler.pathIsBoolean(config, ALLOWCOLORSPATH)) {
            config.set(ALLOWCOLORSPATH, (Object)true);
        }
        if (!ConfigHandler.pathIsBoolean(config, ALLOWFORMATTINGPATH)) {
            config.set(ALLOWFORMATTINGPATH, (Object)true);
        }
    }

    private static boolean pathIsString(FileConfiguration config, String path) {
        return config.contains(path) && config.get(path) instanceof String;
    }

    private static boolean pathIsInteger(FileConfiguration config, String path) {
        return config.contains(path) && config.get(path) instanceof Integer;
    }

    private static boolean pathIsBoolean(FileConfiguration config, String path) {
        return config.contains(path) && config.get(path) instanceof Boolean;
    }

    private static boolean pathIsStringList(FileConfiguration config, String path) {
        return config.contains(path) && config.get(path) instanceof List && config.get(path).getClass() == String.class;
    }

    public static String getValidChars() {
        return VALIDCHARS;
    }

    public static void setValidChars(String chars) {
        VALIDCHARS = chars;
    }

    public static String resetValidChars() {
        VALIDCHARS = DEFAULTCHARS;
        return VALIDCHARS;
    }

    public static boolean hasInvalidChars(String chars) {
        if (VALIDCHARS.isEmpty()) {
            return false;
        }
        for (char c : chars.toCharArray()) {
            if (ConfigHandler.getValidChars().contains(String.valueOf(c)) || c == '\u00a7') continue;
            return true;
        }
        return false;
    }

    public static int getMaxNameLength() {
        return MAXNAMELENGTH;
    }

    public static void setMaxNameLength(int num) {
        MAXNAMELENGTH = num;
    }

    public static int resetMaxNameLength() {
        MAXNAMELENGTH = 16;
        return MAXNAMELENGTH;
    }

    public static int getMaxPrefixLength() {
        return MAXPREFIXLENGTH;
    }

    public static void setMaxPrefixLength(int num) {
        MAXPREFIXLENGTH = num;
    }

    public static int resetMaxPrefixLength() {
        MAXPREFIXLENGTH = 8;
        return MAXPREFIXLENGTH;
    }

    public static int getMaxSuffixLength() {
        return MAXSUFFIXLENGTH;
    }

    public static void setMaxSuffixLength(int num) {
        MAXSUFFIXLENGTH = num;
    }

    public static int resetMaxSuffixLength() {
        MAXSUFFIXLENGTH = 8;
        return MAXSUFFIXLENGTH;
    }

    public static boolean getAllowColors() {
        return ALLOWCOLORS;
    }

    public static void setAllowColors(boolean value) {
        ALLOWCOLORS = value;
    }

    public static boolean resetAllowColors() {
        ALLOWCOLORS = true;
        return ALLOWCOLORS;
    }

    public static boolean getAllowFormatting() {
        return ALLOWFORMATTING;
    }

    public static void setAllowFormatting(boolean value) {
        ALLOWFORMATTING = value;
    }

    public static boolean resetAllowFormatting() {
        ALLOWFORMATTING = true;
        return ALLOWFORMATTING;
    }

    public static String getFormattingCharacters() {
        StringBuilder builder = new StringBuilder();
        if (ConfigHandler.getAllowColors()) {
            builder.append("0123456789abcdef");
        }
        if (ConfigHandler.getAllowFormatting()) {
            builder.append("klmnor");
        }
        return builder.toString();
    }
}

