/*
 * Decompiled with CFR 0.152.
 */
package me.gonkas.playernametags.util;

import java.util.List;
import java.util.function.Predicate;
import me.gonkas.playernametags.handlers.ConfigHandler;
import me.gonkas.playernametags.util.TextType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Strings {
    public static boolean containsIgnoreCase(String match, String string) {
        return match.toLowerCase().contains(string.toLowerCase());
    }

    public static List<String> matchOnlinePlayersName(String string) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(p -> Strings.containsIgnoreCase(p, string)).toList();
    }

    public static List<String> matchOnlinePlayersName(String string, Predicate<? super Player> filter) {
        return Bukkit.getOnlinePlayers().stream().filter(filter).map(Player::getName).filter(p -> Strings.containsIgnoreCase(p, string)).toList();
    }

    public static boolean containsChar(String string, char c) {
        return string.contains(String.valueOf(c));
    }

    public static String formatText(String text, TextType type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        String format_chars = ConfigHandler.getFormattingCharacters();
        int text_length = text.length();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '&' && text.charAt(i) != '\u00a7' || i == text.length() - 1 || !Strings.containsChar(format_chars, text.charAt(i + 1))) continue;
            if (i == 0) {
                text = new StringBuilder(text).replace(0, 1, "\u00a7").toString();
            } else if (text.charAt(i - 1) != '\\') {
                text = new StringBuilder(text).replace(i, i + 1, "\u00a7").toString();
            }
            text_length -= 2;
        }
        if (ConfigHandler.hasInvalidChars(text)) {
            return null;
        }
        switch (type) {
            case NAME: {
                if (text_length <= ConfigHandler.getMaxNameLength()) break;
                return null;
            }
            case PREFIX: {
                if (text_length <= ConfigHandler.getMaxPrefixLength()) break;
                return null;
            }
            case SUFFIX: {
                if (text_length <= ConfigHandler.getMaxSuffixLength()) break;
                return null;
            }
        }
        return text;
    }

    public static String deformatText(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        String format_characters = ConfigHandler.getFormattingCharacters();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\u00a7' || Strings.containsChar(format_characters, text.charAt(i + 1))) continue;
            text = new StringBuilder(text).replace(i, i + 2, "").toString();
        }
        return text;
    }

    public static int textLength(String text) {
        int length = text.length();
        String format_chars = ConfigHandler.getFormattingCharacters();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\u00a7' || !Strings.containsChar(format_chars, text.charAt(i + 1))) continue;
            length -= 2;
        }
        return length;
    }
}

