/*
 * Decompiled with CFR 0.152.
 */
package org.inferis.manicminer;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import org.inferis.manicminer.ManicMinerConfig;
import org.inferis.manicminer.events.ManicMinerEvents;
import org.inferis.manicminer.networking.HotKeyPressedPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManicMiner
implements ModInitializer {
    public static final String MODID = "manic-miner";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"manic-miner");
    public static final ManicMinerConfig CONFIG = new ManicMinerConfig();
    public static Boolean IS_HOTKEY_PRESSED = false;

    public void onInitialize() {
        CONFIG.initialLoad();
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                return ManicMinerEvents.beforeBlockBreak(world, serverPlayer, pos, state);
            }
            return true;
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> ManicMinerEvents.onEntityLoad(entity, world));
        this.registerPayloadAndReceiver();
    }

    public void registerPayloadAndReceiver() {
        PayloadTypeRegistry.playC2S().register(HotKeyPressedPayload.ID, HotKeyPressedPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(HotKeyPressedPayload.ID, (payload, context) -> context.server().execute(() -> {
            IS_HOTKEY_PRESSED = payload.isPressed();
        }));
    }
}

