/*
 * Decompiled with CFR 0.152.
 */
package org.inferis.manicminer;

import com.google.common.base.Charsets;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import net.fabricmc.loader.api.FabricLoader;
import org.inferis.manicminer.ManicMiner;

public class ManicMinerConfig {
    private static final String CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("manicminer.cfg").toString();
    public boolean mustSneak = true;
    public boolean requiresHotKey = false;
    public boolean allowCommonBlocks = true;
    public boolean removeCommonBlocksAroundOre = true;
    public boolean requireEnchantment = false;
    public int maxVeinSize = 128;
    public int maxCommonSize = 128;
    public int maxWoodSize = 192;
    public boolean summonItems = true;

    public void save() {
        File file = new File(CONFIG_FILE);
        try {
            CharSink writer = Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write((CharSequence)gson.toJson((Object)this));
        }
        catch (IOException e) {
            ManicMiner.LOGGER.error("Could not save config", (Throwable)e);
        }
    }

    public boolean load() {
        File file = new File(CONFIG_FILE);
        if (!file.exists()) {
            return false;
        }
        try {
            String json = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
            Gson gson = new Gson();
            ManicMinerConfig loadedConfig = (ManicMinerConfig)gson.fromJson(json, ManicMinerConfig.class);
            this.mustSneak = loadedConfig.mustSneak;
            this.requiresHotKey = loadedConfig.requiresHotKey;
            this.allowCommonBlocks = loadedConfig.allowCommonBlocks;
            this.removeCommonBlocksAroundOre = loadedConfig.removeCommonBlocksAroundOre;
            this.requireEnchantment = loadedConfig.requireEnchantment;
            this.maxVeinSize = loadedConfig.maxVeinSize;
            this.maxCommonSize = loadedConfig.maxCommonSize;
            this.maxWoodSize = loadedConfig.maxWoodSize;
            return true;
        }
        catch (FileNotFoundException e) {
            ManicMiner.LOGGER.error("Could not open config", (Throwable)e);
        }
        catch (IOException e) {
            ManicMiner.LOGGER.error("Could not read config", (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            ManicMiner.LOGGER.error("Could not read config, syntax error", (Throwable)e);
        }
        return false;
    }

    public void initialLoad() {
        if (!this.load()) {
            this.save();
        }
    }
}

