/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.restartdetector;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    public static final File CONFIG_FILE = new File(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/restart_detector.json");
    public static ModConfig INSTANCE;
    private static final Gson GSON;
    public boolean hijackStopCommand = true;
    public int stopCountdownTicks = 600;

    public static void load() {
        INSTANCE = ModConfig.loadConfigFile(CONFIG_FILE);
    }

    public void save() {
        this.saveConfigFile(CONFIG_FILE);
    }

    private static ModConfig loadConfigFile(File file) {
        ModConfig config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (ModConfig)GSON.fromJson((Reader)fileReader, ModConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new ModConfig();
        }
        config.saveConfigFile(file);
        return config;
    }

    private void saveConfigFile(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
        ModConfig.load();
    }
}

