/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.restartdetector;

import com.mojang.brigadier.CommandDispatcher;
import dev.enjarai.restartdetector.ModConfig;
import dev.enjarai.restartdetector.block.ModBlocks;
import dev.enjarai.restartdetector.command.RestartDetectorCommand;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartDetector
implements ModInitializer {
    public static final String MOD_ID = "restart_detector";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"restart_detector");
    private static int ticksToStop = -1;

    public void onInitialize() {
        ModBlocks.register();
        ServerTickEvents.END_SERVER_TICK.register(RestartDetector::tick);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> RestartDetectorCommand.register((CommandDispatcher<class_2168>)dispatcher));
    }

    public static void tick(MinecraftServer server) {
        if (ticksToStop >= 0) {
            if (ticksToStop == 0) {
                LOGGER.info("Shutdown countdown complete, stopping the server.");
                server.method_3747(false);
            }
            --ticksToStop;
        }
    }

    public static void startStopCountdown() {
        ticksToStop = ModConfig.INSTANCE.stopCountdownTicks;
    }

    public static void cancelStopCountdown() {
        ticksToStop = -1;
    }

    public static boolean isServerStopping() {
        return ticksToStop != -1;
    }

    public static int getTicksToStop() {
        return ticksToStop;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

