package archives.tater.dyedvoid.datagen;

import archives.tater.dyedvoid.DyedVoid;
import archives.tater.dyedvoid.DyedVoidBlocks;
import archives.tater.dyedvoid.DyedVoidItems;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_10410;
import net.minecraft.class_2248;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.client.data.*;

import java.util.Optional;

public class ModelGenerator extends FabricModelProvider {

    public ModelGenerator(FabricDataOutput output) {
        super(output);
    }

    private static final class_4942 VOID_BLOCK_MODEL = new class_4942(Optional.of(DyedVoid.id("block/void_block")), Optional.empty(), class_4945.field_23010);
    private static final class_4946.class_4947 VOID_BLOCK_FACTORY = class_4946.method_25918(class_4944::method_25864, VOID_BLOCK_MODEL);

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        for (class_2248 block : DyedVoidBlocks.VOID_BLOCKS) {
            if (block == DyedVoidBlocks.END_VOID) continue; // Skip
            blockStateModelGenerator.method_25622(block, VOID_BLOCK_FACTORY);
        }
        blockStateModelGenerator.method_25660(DyedVoidBlocks.END_VOID, DyedVoid.id("block/empty"));
    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        itemModelGenerator.field_55245.method_65460(DyedVoidItems.END_VOID, class_10410.method_65481(class_4941.method_25842(DyedVoidBlocks.BLACK_VOID)));

//        Models.GENERATED.upload(ModelIds.getItemModelId(DyedVoidItems.DUMMY_END_PORTAL), TextureMap.layer0(DyedVoidBlocks.BLACK_VOID), itemModelGenerator.writer);
//        Models.CUBE_ALL.upload(ModelIds.getItemModelId(DyedVoidItems.DUMMY_END_GATEWAY), TextureMap.all(DyedVoidBlocks.BLACK_VOID), itemModelGenerator.writer);

        itemModelGenerator.method_65442(DyedVoidItems.VOID_BOTTLE_ITEM, class_4943.field_22938);
    }
}
