/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moffy.addonapi.AddonModuleProvider;
import moffy.addonapi.AddonModuleRegistry;
import moffy.ticex.lib.config.ModifierLevelPreset;
import moffy.ticex.lib.config.ToolSlotPreset;
import moffy.ticex.modules.general.TicEXModuleProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class TicEXConfig {
    public static ForgeConfigSpec.ConfigValue<Integer> RF_FURNACE_RATE_CAPACITY;
    public static ForgeConfigSpec.ConfigValue<Boolean> USE_SHADER;
    public static ForgeConfigSpec.ConfigValue<Boolean> USE_MORE_CONFIG;
    public static ForgeConfigSpec.ConfigValue<Boolean> PROVIDE_PROPERTIES;
    public static List<ForgeConfigSpec.ConfigValue<Integer>> RF_FURNACE_FUEL_TEMP;
    public static List<ForgeConfigSpec.ConfigValue<Integer>> RF_FURNACE_FUEL_RATE;
    public static Map<ResourceLocation, ToolSlotPreset.SlotConfigSpec> SLOTS_CONFIG;
    public static Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Integer>> MODIFIER_CONFIG;
    public static ForgeConfigSpec.ConfigValue<Boolean> SHOULD_CONSUME_SLASHBLADE;
    public static ForgeConfigSpec.ConfigValue<Float> CONDENSING_DROP_PROBABILITY;
    public static ForgeConfigSpec.ConfigValue<Boolean> MEKAPLATE_USE_POWER_SHIELD;
    public static ForgeConfigSpec.ConfigValue<Integer> OVERRIDE_LIMIT;
    public static ForgeConfigSpec.ConfigValue<Integer> GAUNTLET_REMAIN_TICKS;
    public static ForgeConfigSpec.ConfigValue<List<String>> GLOVE_DROP_BLACKLIST;
    public static ForgeConfigSpec.ConfigValue<Boolean> GLOVE_DROP_BLACKLIST_AS_WHITELIST;

    public static void registerConfig() {
        int i;
        ForgeConfigSpec.Builder COMMON = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder CLIENT = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder MORE_CONFIG = new ForgeConfigSpec.Builder();
        COMMON.comment("General").push("general");
        USE_MORE_CONFIG = COMMON.comment("Using ticex-more-config.toml(If true, it will override your datapack!)").define("useMoreConfig", true);
        RF_FURNACE_RATE_CAPACITY = COMMON.comment("MAX Rate Capacity(RF/t)").define("rateCapacity", (Object)100000);
        COMMON.pop();
        COMMON.push("avaritia");
        CONDENSING_DROP_PROBABILITY = COMMON.comment("Probability of a neutron pile is dropped by condensing modifier").define("condensingDropProbability", (Object)Float.valueOf(0.003f));
        COMMON.pop();
        COMMON.push("mekanism");
        MEKAPLATE_USE_POWER_SHIELD = COMMON.comment("Allow Mekaplate can use shield of electricity").define("mekaplateUseShield", true);
        COMMON.pop();
        COMMON.push("apotheosis");
        OVERRIDE_LIMIT = COMMON.comment("Maximum level of enchantments granted by override").define("overrideLevelLimit", (Object)255);
        COMMON.pop();
        COMMON.push("curios");
        GAUNTLET_REMAIN_TICKS = COMMON.comment("Ticks remaining on the gauntlet after a gauntlet shot hits").define("gantletRemainTicks", (Object)40);
        GLOVE_DROP_BLACKLIST = COMMON.comment("Blacklist of entities that do not drop the glove.").define("gloveDropBlacklist", List.of("minecraft:armor_stand", "dummmmmmy:target_dummy"));
        GLOVE_DROP_BLACKLIST_AS_WHITELIST = COMMON.comment("Use gloveDropBlacklist as whitelist").define("gloveDropBlacklistAsWhitelist", false);
        COMMON.pop();
        MORE_CONFIG.push("RF Furnace Fuel Temperature Settings");
        MORE_CONFIG.comment("These values are 32-bit signed integer. (Maximum value is about 2.147G)");
        int[] temps = new int[]{20, 90, 225, 402, 625, 902, 1230, 1603, 2026, 2494, 3036, 3594, 4240, 5095, 5647, 6397, 7242, 8101, 9039, 10000};
        for (i = 0; i < 20; ++i) {
            RF_FURNACE_FUEL_TEMP.add((ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Temperature of RF Furnace Fuel " + i).define("rfFuel" + i + "Temp", (Object)temps[i]));
        }
        MORE_CONFIG.pop();
        MORE_CONFIG.push("RF Furnace Fuel Speed Rate Settings");
        MORE_CONFIG.comment(new String[]{"These values are 32-bit signed integer. (Maximum value is about 2.147G)", "The actual speed multiplier is calculated by dividing this value by 10.", "For example, setting it to 100 results in 10x speed, and 25 results in 2.5x speed."});
        for (i = 0; i < 20; ++i) {
            RF_FURNACE_FUEL_RATE.add((ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Speed Rate of RF Furnace Fuel " + i).define("rfRate" + i + "Temp", (Object)(i * 5 + 5)));
        }
        MORE_CONFIG.pop();
        MORE_CONFIG.push("Tool/Armor Slots Settings");
        MORE_CONFIG.comment("These values are 32-bit signed integer. (Maximum value is about 2.147G)");
        ToolSlotPreset.PRESET.forEach(preset -> {
            Record spec = null;
            if (preset.upgradeSlot() > 0) {
                if (preset.abilitySlot() > 0) {
                    spec = preset.defenseSlot() > 0 ? new ToolSlotPreset.BothSlotConfigSpec((ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Upgrade Slots of " + preset.name()).define(preset.configName() + "UpgradeSlots", (Object)preset.upgradeSlot()), (ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Ability Slots of " + preset.name()).define(preset.configName() + "AbilitySlots", (Object)preset.abilitySlot()), (ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Defense Slots of " + preset.name()).define(preset.configName() + "DefenseSlots", (Object)preset.defenseSlot())) : new ToolSlotPreset.AbilitySlotConfigSpec((ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Upgrade Slots of " + preset.name()).define(preset.configName() + "UpgradeSlots", (Object)preset.upgradeSlot()), (ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Ability Slots of " + preset.name()).define(preset.configName() + "AbilitySlots", (Object)preset.abilitySlot()));
                } else if (preset.defenseSlot() > 0) {
                    spec = new ToolSlotPreset.DefenseSlotConfigSpec((ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Upgrade Slots of " + preset.name()).define(preset.configName() + "UpgradeSlots", (Object)preset.upgradeSlot()), (ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Defense Slots of " + preset.name()).define(preset.configName() + "AbilitySlots", (Object)preset.defenseSlot()));
                }
            } else if (preset.defenseSlot() > 0) {
                spec = preset.abilitySlot() > 0 ? new ToolSlotPreset.NoUpgradeSlotConfigSpec((ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Ability Slots of " + preset.name()).define(preset.configName() + "AbilitySlots", (Object)preset.abilitySlot()), (ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Defense Slots of " + preset.name()).define(preset.configName() + "DefenseSlots", (Object)preset.defenseSlot())) : new ToolSlotPreset.DefenseOnlySlotConfigSpec((ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Defense Slots of " + preset.name()).define(preset.configName() + "DefenseSlots", (Object)preset.defenseSlot()));
            }
            if (spec != null) {
                SLOTS_CONFIG.put(preset.rl(), (ToolSlotPreset.SlotConfigSpec)((Object)spec));
            }
        });
        MORE_CONFIG.pop();
        MORE_CONFIG.push("Modifier Level Settings");
        MORE_CONFIG.comment("These values are 32-bit signed integer. (Maximum value is about 2.147G)");
        ModifierLevelPreset.PRESET.forEach(preset -> MODIFIER_CONFIG.put(preset.rl(), (ForgeConfigSpec.ConfigValue<Integer>)MORE_CONFIG.comment("Max Level of " + preset.name()).define(preset.configName() + "MaxLevel", (Object)preset.max())));
        MORE_CONFIG.pop();
        MORE_CONFIG.push("Catalyst Settings");
        SHOULD_CONSUME_SLASHBLADE = MORE_CONFIG.comment("If set to true, the catalyst will consume the Slashblade upon use.").define("shouldConsumeSlashblade", true);
        MORE_CONFIG.pop();
        CLIENT.comment("Client Settings").push("client");
        USE_SHADER = CLIENT.comment("Rendering with shaders for some tools/armors").define("useShader", true);
        AddonModuleRegistry.INSTANCE.LoadModule((AddonModuleProvider)new TicEXModuleProvider(), COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON.build());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MORE_CONFIG.build(), "ticex-more-config.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT.build());
    }

    static {
        RF_FURNACE_FUEL_TEMP = new ArrayList<ForgeConfigSpec.ConfigValue<Integer>>();
        RF_FURNACE_FUEL_RATE = new ArrayList<ForgeConfigSpec.ConfigValue<Integer>>();
        SLOTS_CONFIG = new HashMap<ResourceLocation, ToolSlotPreset.SlotConfigSpec>();
        MODIFIER_CONFIG = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Integer>>();
    }
}

