/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.block.entity;

import javax.annotation.Nonnull;
import moffy.ticex.TicEXConfig;
import moffy.ticex.block.entity.RFFurnaceEnergyStorage;
import moffy.ticex.block.entity.RFFurnaceFluidTank;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.client.SafeClient;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryComponentBlockEntity;

public class RFFurnaceBlockEntity
extends SmelteryComponentBlockEntity
implements ITankBlockEntity {
    private boolean isCreative;
    private int maxEnergyRate;
    private int lastStrength;
    private RFFurnaceFluidTank tank;
    private RFFurnaceEnergyStorage energyStorage;
    private LazyOptional<IFluidHandler> fluidHolder;
    private LazyOptional<IEnergyStorage> energyHolder;
    private int tankCapacity;

    public RFFurnaceBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, boolean isCreative) {
        super(pType, pPos, pBlockState);
        this.isCreative = isCreative;
        this.maxEnergyRate = (Integer)TicEXConfig.RF_FURNACE_RATE_CAPACITY.get();
        this.energyStorage = new RFFurnaceEnergyStorage(this.maxEnergyRate);
        this.lastStrength = -1;
        this.tankCapacity = 1000;
        this.tank = new RFFurnaceFluidTank(this.tankCapacity, this);
        this.fluidHolder = LazyOptional.of(() -> this.tank);
        this.energyHolder = LazyOptional.of(() -> this.energyStorage);
    }

    public RFFurnaceEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getMaxEnergyRate() {
        return this.maxEnergyRate;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHolder.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHolder.invalidate();
        this.energyHolder.invalidate();
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, RFFurnaceBlockEntity pBlockEntity) {
        int energyRate = pBlockEntity.getEnergyStorage().getEnergyRate();
        int extracted = pBlockEntity.getEnergyStorage().extractEnergy(1000, false);
        float rate = (float)energyRate / (float)pBlockEntity.getMaxEnergyRate();
        int fuelIndex = 20;
        if (!pBlockEntity.isCreative() && (float)Math.abs(energyRate - pBlockEntity.getMaxEnergyRate()) > 0.5f) {
            fuelIndex = Math.round(20.0f * (1.0f - (float)Math.exp(-Math.PI * (double)rate)));
        }
        if (pBlockEntity.isCreative()) {
            pBlockEntity.updateFluidTo(new FluidStack(TicEXRegistry.RF_FURNACE_FUELS.get(19).get(), 1000));
        } else if (extracted >= 1) {
            if (fuelIndex == 0) {
                pBlockEntity.updateFluidTo(FluidStack.EMPTY);
            } else {
                pBlockEntity.updateFluidTo(new FluidStack(TicEXRegistry.RF_FURNACE_FUELS.get(fuelIndex - 1).get(), 1000));
            }
        } else {
            pBlockEntity.getEnergyStorage().setEnergyRate(0);
            pBlockEntity.updateFluidTo(FluidStack.EMPTY);
        }
    }

    public void onTankContentsChanged() {
        super.onTankContentsChanged();
        if (this.f_58857_ != null) {
            this.f_58857_.m_5518_().m_7174_(this.f_58858_);
            this.requestModelDataUpdate();
        }
    }

    public int getLastStrength() {
        return this.lastStrength;
    }

    public FluidTankAnimated getTank() {
        return this.tank;
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ModelProperties.FLUID_STACK, (Object)this.tank.getFluid()).with(ModelProperties.TANK_CAPACITY, (Object)this.tank.getCapacity()).build();
    }

    public void updateTank(CompoundTag nbt) {
        if (nbt.m_128456_()) {
            this.tank.setFluid(FluidStack.EMPTY);
        } else {
            this.tank.readFromNBT(nbt);
            if (this.f_58857_ != null) {
                this.f_58857_.m_5518_().m_7174_(this.f_58858_);
            }
        }
    }

    public void updateFluidTo(FluidStack fluid) {
        this.tank.setFluid(fluid);
        if (this.isFluidInModel()) {
            SafeClient.updateFluidModel((BlockEntity)this.getTE(), (FluidTank)this.tank, (int)this.tankCapacity, (int)this.tankCapacity);
        }
    }

    public void setLastStrength(int arg0) {
        this.lastStrength = arg0;
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void m_142466_(CompoundTag tag) {
        this.tank.setCapacity(this.tankCapacity);
        this.isCreative = tag.m_128471_("isCreative");
        this.updateTank(tag.m_128469_("tank"));
        super.m_142466_(tag);
    }

    public void saveSynced(CompoundTag tag) {
        super.saveSynced(tag);
        if (!this.tank.isEmpty()) {
            tag.m_128379_("isCreative", this.isCreative);
            tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        }
    }
}

