/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.block.entity;

import net.minecraftforge.energy.EnergyStorage;

public class RFFurnaceEnergyStorage
extends EnergyStorage {
    private int energyRate;
    private int maxEnergyRate;

    public RFFurnaceEnergyStorage(int maxEnergyRate) {
        super(maxEnergyRate);
        this.maxEnergyRate = maxEnergyRate;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = Math.min(this.maxEnergyRate, maxReceive);
        if (!simulate) {
            this.energyRate = received;
            this.energy = received;
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= extracted;
        }
        return extracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergyRate;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public int getEnergyRate() {
        return this.energyRate;
    }

    public int getMaxEnergyRate() {
        return this.maxEnergyRate;
    }

    public void setEnergyRate(int energyRate) {
        this.energyRate = energyRate;
    }
}

