/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.caps;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;

public class EmbossmentMaterialCapability {
    public static final Capability<EmbossmentMaterialCapability> EMBOSSMENT_MATERIAL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<EmbossmentMaterialCapability>(){});
    public static final ResourceLocation MATERIAL_MAP = new ResourceLocation("ticex", "embossed_material_map");
    protected final Map<String, MaterialId> embossedMaterials = new HashMap<String, MaterialId>();
    protected final IToolStackView tool;

    public EmbossmentMaterialCapability(IToolStackView tool) {
        this.tool = tool;
        this.deserializeNBT(tool.getPersistentData().getCompound(MATERIAL_MAP));
    }

    public void accept(ItemStack toolStack, ItemStack partStack, ToolPartItem part) {
        MaterialVariantId materialVariantId = part.getMaterial(partStack);
        ToolStack tool = ToolStack.from((ItemStack)toolStack);
        this.remove(toolStack, partStack, part);
        this.embossedMaterials.put(part.getStatType().toString(), part.getMaterial(partStack).getId());
        for (ModifierEntry modifierEntry : MaterialRegistry.getInstance().getTraits(materialVariantId.getId(), part.getStatType())) {
            tool.addModifier(modifierEntry.getId(), modifierEntry.getLevel());
        }
        tool.getPersistentData().put(MATERIAL_MAP, (Tag)this.serializeNBT());
    }

    public void remove(ItemStack toolStack, ItemStack partStack, ToolPartItem part) {
        MaterialStatsId stat = part.getStatType();
        MaterialId materialId = this.embossedMaterials.get(stat.toString());
        ToolStack tool = ToolStack.from((ItemStack)toolStack);
        this.embossedMaterials.remove(stat.toString());
        if (materialId == null) {
            return;
        }
        for (ModifierEntry modifierEntry : MaterialRegistry.getInstance().getTraits(materialId, part.getStatType())) {
            tool.removeModifier(modifierEntry.getId(), modifierEntry.getLevel());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag embossedMaterialList = new ListTag();
        for (Map.Entry<String, MaterialId> entry : this.embossedMaterials.entrySet()) {
            CompoundTag materialTag = new CompoundTag();
            materialTag.m_128359_("stat", entry.getKey());
            materialTag.m_128359_("id", entry.getValue().toString());
            embossedMaterialList.add((Object)materialTag);
        }
        nbt.m_128365_("materials", (Tag)embossedMaterialList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag embossedMaterialList = nbt.m_128437_("materials", 10);
        for (int i = 0; i < embossedMaterialList.size(); ++i) {
            CompoundTag materialTag = embossedMaterialList.m_128728_(i);
            this.embossedMaterials.put(materialTag.m_128461_("stat"), new MaterialId(materialTag.m_128461_("id")));
        }
    }
}

