/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.caps.curios;

import java.util.function.Supplier;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class GauntletItemHandler
extends ToolInventoryCapability
implements ICurio {
    protected IToolStackView tool;
    protected ItemStack stack;
    protected int[] itemCooldowns;

    public GauntletItemHandler(ItemStack stack, Supplier<? extends IToolStackView> tool) {
        super(tool);
        this.tool = tool.get();
        this.stack = stack;
        this.itemCooldowns = new int[this.getSlots()];
    }

    public int getSlots() {
        return 6;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack) {
        super.onEquip(slotContext, prevStack);
    }

    public boolean canEquip(SlotContext slotContext) {
        LivingEntity livingEntity = slotContext.entity();
        if (CuriosApi.getCuriosInventory((LivingEntity)livingEntity).isPresent()) {
            ICuriosItemHandler itemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).orElseThrow(IllegalStateException::new);
            return itemHandler.findFirstCurio((Item)TicEXRegistry.RESONANCE_GAUNTLET.get()).isEmpty();
        }
        return super.canEquip(slotContext);
    }

    public int getItemCooldown(int index) {
        return index >= 0 && index < this.getSlots() ? this.itemCooldowns[index] : 0;
    }

    public void setItemCooldown(int index, int cooldown) {
        if (index >= 0 && index < this.getSlots()) {
            this.itemCooldowns[index] = cooldown;
        }
    }

    public void curioTick(SlotContext slotContext) {
        for (int i = 0; i < this.itemCooldowns.length; ++i) {
            if (this.itemCooldowns[i] <= 0) continue;
            this.itemCooldowns[i] = this.itemCooldowns[i] - 1;
        }
    }
}

