/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.caps.draconicevolution;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import moffy.ticex.modifier.ModifierEvolved;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.nbt.Tag;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class EvolvedModuleHost
extends ModuleHostImpl {
    private IToolStackView toolSupplier;

    public EvolvedModuleHost(IToolStackView toolSupplier) {
        super(TechLevel.byIndex((int)(toolSupplier.getModifierLevel(TicEXRegistry.EVOLVED_MODIFIER.get()) - 1)), ModuleCfg.staffWidth((TechLevel)TechLevel.byIndex((int)(toolSupplier.getModifierLevel(TicEXRegistry.EVOLVED_MODIFIER.get()) - 1))), ModuleCfg.staffHeight((TechLevel)TechLevel.byIndex((int)(toolSupplier.getModifierLevel(TicEXRegistry.EVOLVED_MODIFIER.get()) - 1))), "TiC Tools", false, new ModuleCategory[]{ModuleCategory.ENERGY, ModuleCategory.MELEE_WEAPON, ModuleCategory.MINING_TOOL});
        this.addPropertyBuilder(props -> {
            AOEData aoe = (AOEData)this.getModuleData(ModuleTypes.AOE);
            if (aoe != null) {
                DecimalProperty attackAoEProperty = new DecimalProperty("attack_aoe", (double)aoe.aoe() * 1.5).range(0.0, (double)aoe.aoe() * 1.5).setFormatter(ConfigProperty.DecimalFormatter.AOE_1);
                IntegerProperty miningAoEProperty = new IntegerProperty("mining_aoe", aoe.aoe()).range(0, aoe.aoe()).setFormatter(ConfigProperty.IntegerFormatter.AOE);
                BooleanProperty aoeSafeProperty = new BooleanProperty("aoe_safe", false).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
                props.add(attackAoEProperty);
                props.add(miningAoEProperty);
                props.add(aoeSafeProperty);
            }
        });
        this.toolSupplier = toolSupplier;
    }

    public void addModule(ModuleEntity<?> entity, ModuleContext context) {
        super.addModule(entity, context);
        this.writeToPersistentData();
    }

    public void removeModule(ModuleEntity<?> entity, ModuleContext context) {
        super.removeModule(entity, context);
        this.writeToPersistentData();
    }

    public TechLevel getHostTechLevel() {
        this.readFromPersistentData();
        return super.getHostTechLevel();
    }

    private void writeToPersistentData() {
        this.toolSupplier.getPersistentData().put(ModifierEvolved.MODULE_HOST_LOCATION, (Tag)this.serializeNBT());
    }

    private void readFromPersistentData() {
        this.deserializeNBT(this.toolSupplier.getPersistentData().getCompound(ModifierEvolved.MODULE_HOST_LOCATION));
        this.getProperties().forEach(property -> {
            if (property instanceof BooleanProperty) {
                ((BooleanProperty)property).setChangeListener(this::writeToPersistentData);
            } else if (property instanceof DecimalProperty) {
                ((DecimalProperty)property).setChangeListener(this::writeToPersistentData);
            } else if (property instanceof IntegerProperty) {
                ((IntegerProperty)property).setChangeListener(this::writeToPersistentData);
            }
        });
    }

    public IToolStackView getToolSupplier() {
        return this.toolSupplier;
    }
}

