/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.caps.draconicevolution;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.init.EquipCfg;
import moffy.ticex.caps.draconicevolution.EvolvedModuleHost;
import moffy.ticex.modifier.ModifierEvolved;
import net.minecraft.nbt.Tag;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class EvolvedOPStorage
extends ModularOPStorage {
    private IToolStackView tool;

    public EvolvedOPStorage(EvolvedModuleHost host, IToolStackView tool) {
        super((ModuleHost)host, EquipCfg.getBaseStaffEnergy((TechLevel)host.getHostTechLevel()), EquipCfg.getBaseStaffTransfer((TechLevel)host.getHostTechLevel()));
        this.tool = tool;
        this.setIOMode(true);
        this.readFromPersistentData();
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = super.extractEnergy(maxExtract, simulate);
        this.writeToPersistentData();
        return extracted;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = super.receiveEnergy(maxReceive, simulate);
        this.writeToPersistentData();
        return received;
    }

    public OPStorage setCapacity(long capacity) {
        OPStorage opStorage = super.setCapacity(capacity);
        this.writeToPersistentData();
        return opStorage;
    }

    public long receiveOP(long maxReceive, boolean simulate) {
        long received = super.receiveOP(maxReceive, simulate);
        this.writeToPersistentData();
        return received;
    }

    public long extractOP(long maxExtract, boolean simulate) {
        long extracted = super.extractOP(maxExtract, simulate);
        this.writeToPersistentData();
        return extracted;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    private void writeToPersistentData() {
        this.tool.getPersistentData().put(ModifierEvolved.OP_STORAGE_LOCATION, (Tag)this.serializeNBT());
    }

    private void readFromPersistentData() {
        this.deserializeNBT(this.tool.getPersistentData().getCompound(ModifierEvolved.OP_STORAGE_LOCATION));
    }
}

