/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.caps.psi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import moffy.ticex.modifier.ModifierPsionizingRadiation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;

public class ToolCADData
implements ICADData,
ISpellAcceptor,
ISocketable,
IPsiBarDisplay {
    private final ItemStack cadStack;
    private final IToolStackView cad;
    private int time;
    private int battery;
    private List<Vector3> vectors = Lists.newArrayList();
    private boolean dirty;

    public ToolCADData(ItemStack cadStack, IToolStackView cad) {
        this.cadStack = cadStack;
        this.cad = cad;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        if (this.time != time) {
            this.time = time;
        }
    }

    public int getBattery() {
        return this.battery;
    }

    public void setBattery(int battery) {
        this.battery = battery;
    }

    public Vector3 getSavedVector(int memorySlot) {
        if (this.vectors.size() <= memorySlot) {
            return Vector3.zero.copy();
        }
        Vector3 vec = this.vectors.get(memorySlot);
        return (vec == null ? Vector3.zero : vec).copy();
    }

    public void setSavedVector(int memorySlot, Vector3 value) {
        while (this.vectors.size() <= memorySlot) {
            this.vectors.add(null);
        }
        this.vectors.set(memorySlot, value);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    public void setSpell(Player player, Spell spell) {
        int slot = this.getSelectedSlot();
        ItemStack bullet = this.getBulletInSocket(slot);
        if (!bullet.m_41619_() && ISpellAcceptor.isAcceptor((ItemStack)bullet)) {
            ISpellAcceptor.acceptor((ItemStack)bullet).setSpell(player, spell);
            this.setBulletInSocket(slot, bullet);
            player.m_36335_().m_41524_(this.cad.getItem(), 10);
        }
    }

    public boolean requiresSneakForSpellSet() {
        return false;
    }

    public boolean isSocketSlotAvailable(int slot) {
        int sockets = this.cad.getPersistentData().getInt(ModifierPsionizingRadiation.SOCKETS_LOC);
        if (sockets == -1 || sockets > 12) {
            sockets = 12;
        }
        return slot < sockets && slot >= 0;
    }

    public ItemStack getBulletInSocket(int slot) {
        String name = "bullet" + slot;
        CompoundTag cmp = this.cadStack.m_41784_().m_128469_(name);
        if (cmp.m_128456_()) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)cmp);
    }

    public void setBulletInSocket(int slot, ItemStack bullet) {
        String name = "bullet" + slot;
        CompoundTag cmp = new CompoundTag();
        if (!bullet.m_41619_()) {
            bullet.m_41739_(cmp);
        }
        this.cadStack.m_41784_().m_128365_(name, (Tag)cmp);
        this.cad.getPersistentData().putInt(ModifierPsionizingRadiation.TIMES_CAST_LOC, 0);
    }

    public int getSelectedSlot() {
        return this.cadStack.m_41784_().m_128451_("selectedSlot");
    }

    public void setSelectedSlot(int slot) {
        this.cadStack.m_41784_().m_128405_("selectedSlot", slot);
        this.cad.getPersistentData().putInt(ModifierPsionizingRadiation.TIMES_CAST_LOC, 0);
    }

    public int getLastSlot() {
        int sockets = this.cad.getPersistentData().getInt(ModifierPsionizingRadiation.SOCKETS_LOC);
        if (sockets == -1 || sockets > 12) {
            sockets = 12;
        }
        return sockets - 1;
    }

    public CompoundTag serializeForSynchronization() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("Time", this.time);
        compound.m_128405_("Battery", this.battery);
        return compound;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = this.serializeForSynchronization();
        ListTag memory = new ListTag();
        for (Vector3 vector : this.vectors) {
            if (vector == null) {
                memory.add((Object)new ListTag());
                continue;
            }
            ListTag vec = new ListTag();
            vec.add((Object)DoubleTag.m_128500_((double)vector.x));
            vec.add((Object)DoubleTag.m_128500_((double)vector.y));
            vec.add((Object)DoubleTag.m_128500_((double)vector.z));
            memory.add((Object)vec);
        }
        compound.m_128365_("Memory", (Tag)memory);
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("Time", 99)) {
            this.time = nbt.m_128451_("Time");
        }
        if (nbt.m_128425_("Battery", 99)) {
            this.battery = nbt.m_128451_("Battery");
        }
        if (nbt.m_128425_("Memory", 9)) {
            ListTag memory = nbt.m_128437_("Memory", 9);
            ArrayList newVectors = Lists.newArrayList();
            for (int i = 0; i < memory.size(); ++i) {
                ListTag vec = (ListTag)memory.get(i);
                if (vec.m_7264_() == 6 && vec.size() >= 3) {
                    newVectors.add(new Vector3(vec.m_128772_(0), vec.m_128772_(1), vec.m_128772_(2)));
                    continue;
                }
                newVectors.add(null);
            }
            this.vectors = newVectors;
        }
    }

    public boolean shouldShow(IPlayerData data) {
        return true;
    }
}

