/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.avaritia;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.client.shader.CCShaderInstance;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.event.RegisterShadersEvent;

public final class TicEXCosmicShader {
    private final RenderStateShard.ShaderStateShard stateShard;
    private final RenderType cosmicToolRenderType;
    private final Map<ResourceLocation, RenderType> cosmicArmorRenderTypeCache = new HashMap<ResourceLocation, RenderType>();
    public int internalRenderTime;
    public float internalRenderFrame;
    public CCShaderInstance shaderInstance;
    public Uniform cosmicTime;
    public Uniform cosmicYaw;
    public Uniform cosmicPitch;
    public Uniform cosmicExternalScale;
    public Uniform cosmicOpacity;
    public Uniform cosmicUVs;

    public TicEXCosmicShader() {
        this.stateShard = new RenderStateShard.ShaderStateShard(() -> this.shaderInstance);
        this.cosmicToolRenderType = RenderType.m_173215_((String)"ticex:cosmic", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(this.stateShard).m_110671_(RenderStateShard.f_110152_).m_110685_(RenderStateShard.f_110134_).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.f_110145_).m_110691_(true));
    }

    public void initialize() {
        float[] COSMIC_UVS = new float[40];
        for (int i = 0; i < 10; ++i) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(Const.rl((String)("misc/cosmic_" + i)));
            COSMIC_UVS[i * 4] = sprite.m_118409_();
            COSMIC_UVS[i * 4 + 1] = sprite.m_118411_();
            COSMIC_UVS[i * 4 + 2] = sprite.m_118410_();
            COSMIC_UVS[i * 4 + 3] = sprite.m_118412_();
        }
        if (this.cosmicUVs != null) {
            this.cosmicUVs.m_5941_(COSMIC_UVS);
        }
    }

    public CCShaderInstance getShaderInstance() {
        return this.shaderInstance;
    }

    public RenderType getCosmicToolRenderType() {
        return this.cosmicToolRenderType;
    }

    public RenderType getCosmicRenderTypeArmor(ResourceLocation texture) {
        if (this.cosmicArmorRenderTypeCache.containsKey(texture)) {
            return this.cosmicArmorRenderTypeCache.get(texture);
        }
        RenderType.CompositeRenderType renderType = RenderType.m_173215_((String)"ticex:cosmic_armor", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(this.stateShard).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(RenderType.f_110134_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110154_).m_110669_(RenderType.f_110119_).m_110691_(true));
        this.cosmicArmorRenderTypeCache.put(texture, (RenderType)renderType);
        return renderType;
    }

    public void registerShader(RegisterShadersEvent event) {
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)new ResourceLocation("ticex", "avaritia/materials/infinity"), (VertexFormat)DefaultVertexFormat.f_85811_), e -> {
            this.shaderInstance = (CCShaderInstance)e;
            this.cosmicTime = Objects.requireNonNull(this.shaderInstance.m_173348_("time"));
            this.cosmicYaw = Objects.requireNonNull(this.shaderInstance.m_173348_("yaw"));
            this.cosmicPitch = Objects.requireNonNull(this.shaderInstance.m_173348_("pitch"));
            this.cosmicExternalScale = Objects.requireNonNull(this.shaderInstance.m_173348_("externalScale"));
            this.cosmicOpacity = Objects.requireNonNull(this.shaderInstance.m_173348_("opacity"));
            this.cosmicUVs = Objects.requireNonNull(this.shaderInstance.m_173348_("cosmicuvs"));
            this.cosmicTime.m_5985_((float)this.internalRenderTime + this.internalRenderFrame);
            this.shaderInstance.onApply(() -> this.cosmicTime.m_5985_((float)this.internalRenderTime + this.internalRenderFrame));
            this.initialize();
        });
    }

    public void setupUniform() {
        this.cosmicTime.m_5985_((float)(System.currentTimeMillis() - (long)this.internalRenderTime) / 2000.0f);
    }
}

