/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.curios;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import moffy.ticex.lib.utils.TicEXSBUtils;
import moffy.ticex.lib.utils.TicEXTaczUtils;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

public class LayerResonanceTools<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final float RADIUS = 1.4f;
    protected ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();

    public LayerResonanceTools(RenderLayerParent<T, M> pRenderer) {
        super(pRenderer);
    }

    public void render(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, @NotNull T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        CuriosApi.getCuriosInventory(pLivingEntity).ifPresent(handler -> handler.findFirstCurio((Item)TicEXRegistry.RESONANCE_GAUNTLET.get()).ifPresent(slotResult -> {
            ItemStack stack = slotResult.stack();
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                int i;
                int amount = 0;
                for (i = 0; i < itemHandler.getSlots(); ++i) {
                    if (itemHandler.getStackInSlot(i).m_41619_()) continue;
                    ++amount;
                }
                for (i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack toolStack = itemHandler.getStackInSlot(i);
                    if (toolStack.m_41619_()) continue;
                    boolean isNormalRender = true;
                    pPoseStack.m_85836_();
                    float time = (float)pLivingEntity.f_19797_ + pPartialTick;
                    double baseAngle = Math.PI * 2 / (double)amount * (double)i;
                    double rotationAngle = baseAngle + (double)time * 0.07;
                    double x = (double)1.4f * Math.cos(rotationAngle);
                    double z = (double)1.4f * Math.sin(rotationAngle);
                    pPoseStack.m_85837_(x, 1.25, 0.5 + z);
                    pPoseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
                    pPoseStack.m_85837_(-0.5, -0.5, -0.5);
                    pPoseStack.m_85841_(1.5f, 1.5f, 1.5f);
                    if (ModList.get().isLoaded("slashblade")) {
                        boolean bl = isNormalRender = !TicEXSBUtils.renderBladeTool(toolStack, pPartialTick, pPoseStack, pBuffer, pPackedLight);
                    }
                    if (ModList.get().isLoaded("tacz")) {
                        boolean bl = isNormalRender = isNormalRender && !TicEXTaczUtils.renderGunTool(this.itemRenderer, toolStack, pPoseStack, pBuffer, (Entity)pLivingEntity, pPackedLight);
                    }
                    if (isNormalRender) {
                        this.itemRenderer.m_269128_(toolStack, ItemDisplayContext.GROUND, pPackedLight, OverlayTexture.f_118083_, pPoseStack, pBuffer, pLivingEntity.m_9236_(), pLivingEntity.m_19879_());
                    }
                    pPoseStack.m_85849_();
                }
            });
        }));
    }
}

