/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.draconicevolution;

import codechicken.lib.render.shader.CCUniform;
import codechicken.lib.util.ClientUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.shader.BCShader;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public final class TicEXDEShader
extends BCShader<TicEXDEShader> {
    private static final float[][] baseColours = new float[][]{{0.0f, 0.5f, 0.8f, 1.0f}, {0.55f, 0.0f, 0.65f, 1.0f}, {0.8f, 0.5f, 0.1f, 1.0f}, {0.75f, 0.05f, 0.05f, 0.2f}};
    private final RenderStateShard.ShaderStateShard shaderState = new RenderStateShard.ShaderStateShard(() -> ((TicEXDEShader)this).getShaderInstance());
    private final Supplier<RenderType.CompositeState.CompositeStateBuilder> shaderStateBaseFactory = () -> RenderType.CompositeState.m_110628_().m_173292_(this.shaderState).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.f_110145_).m_110671_(RenderType.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110675_(RenderType.f_110125_);
    private final RenderType modifierRenderType = RenderType.m_173215_((String)"ticex:tool_evolved_modifiers", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)false, (RenderType.CompositeState)((RenderType.CompositeState.CompositeStateBuilder)this.shaderStateBaseFactory.get()).m_110685_(RenderType.f_110136_).m_110691_(true));
    private CCUniform scaleUniform;
    private CCUniform uv1OverrideUniform;
    private CCUniform uv2OverrideUniform;
    private CCUniform baseColorUniform;

    public TicEXDEShader() {
        super(new ResourceLocation("ticex", "draconicevolution/trace"), DefaultVertexFormat.f_85812_);
        this.onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
    }

    public static void init() {
    }

    public static void glUniformBaseColor(TicEXDEShader shader, TechLevel techLevel, float pulse) {
        if (shader.hasBaseColorUniform()) {
            float[] baseColour = baseColours[techLevel.index];
            float r = baseColour[0];
            float g = baseColour[1];
            float b = baseColour[2];
            float a = baseColour[3];
            switch (techLevel) {
                case DRACONIUM: 
                case WYVERN: 
                case DRACONIC: {
                    a *= 1.0f + pulse;
                    break;
                }
                case CHAOTIC: {
                    r += pulse * 0.2f;
                    g += pulse * 0.2f;
                    b += pulse * 0.2f;
                }
            }
            shader.getBaseColorUniform().glUniform4f(r, g, b, a);
        }
    }

    public void setupUniforms(TechLevel techLevel) {
        TicEXDEShader.glUniformBaseColor(this, techLevel, 1.0f);
    }

    public CCUniform getUv1OverrideUniform() {
        return Objects.requireNonNull(this.uv1OverrideUniform, this.missingUniformMessage("UV1Override"));
    }

    public boolean hasScaleUniform() {
        return this.scaleUniform != null;
    }

    public CCUniform getScaleUniform() {
        return Objects.requireNonNull(this.scaleUniform, this.missingUniformMessage("Scale"));
    }

    public boolean hasUv1OverrideUniform() {
        return this.uv1OverrideUniform != null;
    }

    public CCUniform getUv2OverrideUniform() {
        return Objects.requireNonNull(this.uv2OverrideUniform, this.missingUniformMessage("UV2Override"));
    }

    public boolean hasUv2OverrideUniform() {
        return this.uv2OverrideUniform != null;
    }

    public CCUniform getBaseColorUniform() {
        return Objects.requireNonNull(this.baseColorUniform, this.missingUniformMessage("BaseColor"));
    }

    public boolean hasBaseColorUniform() {
        return this.baseColorUniform != null;
    }

    protected void onShaderLoaded() {
        super.onShaderLoaded();
        this.scaleUniform = this.shaderInstance.getUniform("Scale");
        this.uv1OverrideUniform = this.shaderInstance.getUniform("UV1Override");
        this.uv2OverrideUniform = this.shaderInstance.getUniform("UV2Override");
        this.baseColorUniform = this.shaderInstance.getUniform("BaseColor");
    }

    public RenderType getModifierRenderType() {
        return this.modifierRenderType;
    }

    public RenderType createMaterialsRenderType(TechLevel techLevel) {
        return RenderType.m_173215_((String)("ticex:tool_evolved_materials_" + techLevel.name().toLowerCase()), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)false, (RenderType.CompositeState)((RenderType.CompositeState.CompositeStateBuilder)this.shaderStateBaseFactory.get()).m_110685_(RenderType.f_110134_).m_110691_(true));
    }
}

