/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.mekanism;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.client.model.BaseModelCache;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.armor.MekaSuitArmor;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.QuickHash;
import mekanism.client.render.lib.effect.BoltRenderer;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.shared.ModuleColorModulationUnit;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.lib.Color;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import moffy.ticex.client.modules.mekanism.MekaPlateModelCache;
import moffy.ticex.item.modifiable.ModifiableMekaSuitArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.client.armor.ArmorModelManager;
import slimeknights.tconstruct.library.client.armor.MultilayerArmorModel;

public final class MekaPlateMultilayerModel
extends MultilayerArmorModel {
    private static final String LED_TAG = "led";
    private static final String INACTIVE_TAG = "inactive_";
    private static final String OVERRIDDEN_TAG = "override_";
    private static final String EXCLUSIVE_TAG = "excl_";
    private static final String SHARED_TAG = "shared_";
    private static final String GLASS_TAG = "glass";
    private static final Table<EquipmentSlot, ModuleData<?>, ModuleModelSpec> moduleModelSpec = HashBasedTable.create();
    private static final Map<UUID, BoltRenderer> boltRenderMap = new Object2ObjectOpenHashMap();
    public static MekaPlateMultilayerModel HEAD = new MekaPlateMultilayerModel(EquipmentSlot.HEAD, EquipmentSlot.CHEST);
    public static MekaPlateMultilayerModel CHESTPLATE = new MekaPlateMultilayerModel(EquipmentSlot.CHEST, EquipmentSlot.HEAD);
    public static MekaPlateMultilayerModel LEGGINGS = new MekaPlateMultilayerModel(EquipmentSlot.LEGS, EquipmentSlot.FEET);
    public static MekaPlateMultilayerModel BOOTS = new MekaPlateMultilayerModel(EquipmentSlot.FEET, EquipmentSlot.LEGS);
    private final EquipmentSlot type;
    private final EquipmentSlot adjacentType;
    private final LoadingCache<QuickHash, ArmorQuads> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<QuickHash, ArmorQuads>(){

        @NotNull
        public ArmorQuads load(@NotNull QuickHash key) {
            return MekaPlateMultilayerModel.this.createQuads((Object2BooleanMap<ModuleModelSpec>)((Object2BooleanMap)key.objs()[0]), (Set)key.objs()[1], (Boolean)key.objs()[2], (Boolean)key.objs()[3]);
        }
    });
    private LivingEntity living;
    private ItemStack stack;

    public MekaPlateMultilayerModel(EquipmentSlot type, EquipmentSlot adjacentType) {
        this.type = type;
        this.adjacentType = adjacentType;
        MekaPlateModelCache.INSTANCE.reloadCallback(() -> this.cache.invalidateAll());
    }

    private static Color getColor(ItemStack stack) {
        IModule colorModulation;
        if (!stack.m_41619_() && (colorModulation = IModuleHelper.INSTANCE.load(stack, (IModuleDataProvider)MekanismModules.COLOR_MODULATION_UNIT)) != null) {
            return ((ModuleColorModulationUnit)colorModulation.getCustomInstance()).getColor();
        }
        return Color.WHITE;
    }

    public static void registerModule(String name, IModuleDataProvider<?> moduleDataProvider, EquipmentSlot slotType, Predicate<LivingEntity> isActive) {
        ModuleData module = moduleDataProvider.getModuleData();
        moduleModelSpec.put((Object)slotType, (Object)module, (Object)new ModuleModelSpec(module, slotType, name, isActive));
    }

    private static void processMekaTool(BaseModelCache.OBJModelData mekaToolModel, Set<String> ignored) {
        for (String name : mekaToolModel.getModel().getRootComponentNames()) {
            if (!name.contains(OVERRIDDEN_TAG)) continue;
            ignored.add(MekaPlateMultilayerModel.processOverrideName(name, "mekatool"));
        }
    }

    private static boolean checkEquipment(EquipmentSlot type, String text) {
        return switch (type) {
            case EquipmentSlot.HEAD -> text.contains("helmet");
            case EquipmentSlot.CHEST -> text.contains("chest");
            case EquipmentSlot.LEGS -> text.contains("leggings");
            case EquipmentSlot.FEET -> text.contains("boots");
            default -> false;
        };
    }

    private static void addQuadsToRender(MekaSuitArmor.ModelPos pos, String name, Map<String, OverrideData> overrides, Map<MekaSuitArmor.ModelPos, Set<String>> quadsToRender, Map<MekaSuitArmor.ModelPos, Set<String>> ledQuadsToRender, Map<BaseModelCache.MekanismModelData, Map<MekaSuitArmor.ModelPos, Set<String>>> specialQuadsToRender, Map<BaseModelCache.MekanismModelData, Map<MekaSuitArmor.ModelPos, Set<String>>> specialLEDQuadsToRender) {
        OverrideData override = overrides.get(name);
        if (override != null) {
            name = override.name();
            BaseModelCache.MekanismModelData overrideData = override.modelData();
            quadsToRender = specialQuadsToRender.computeIfAbsent(overrideData, d -> new EnumMap(MekaSuitArmor.ModelPos.class));
            ledQuadsToRender = specialLEDQuadsToRender.computeIfAbsent(overrideData, d -> new EnumMap(MekaSuitArmor.ModelPos.class));
        }
        if (name.contains(LED_TAG)) {
            ledQuadsToRender.computeIfAbsent((MekaSuitArmor.ModelPos)pos, p -> new HashSet()).add(name);
        } else {
            quadsToRender.computeIfAbsent((MekaSuitArmor.ModelPos)pos, p -> new HashSet()).add(name);
        }
    }

    private static void parseTransparency(BaseModelCache.MekanismModelData modelData, MekaSuitArmor.ModelPos pos, Map<MekaSuitArmor.ModelPos, List<BakedQuad>> opaqueMap, Map<MekaSuitArmor.ModelPos, List<BakedQuad>> transparentMap, Map<MekaSuitArmor.ModelPos, Set<String>> regularQuads, Map<MekaSuitArmor.ModelPos, Set<String>> ledQuads) {
        HashSet<String> opaqueRegularQuads = new HashSet<String>();
        HashSet<String> opaqueLEDQuads = new HashSet<String>();
        HashSet<String> transparentRegularQuads = new HashSet<String>();
        HashSet<String> transparentLEDQuads = new HashSet<String>();
        MekaPlateMultilayerModel.parseTransparency(pos, opaqueRegularQuads, transparentRegularQuads, regularQuads);
        MekaPlateMultilayerModel.parseTransparency(pos, opaqueLEDQuads, transparentLEDQuads, ledQuads);
        MekaPlateMultilayerModel.addParsedQuads(modelData, pos, opaqueMap, opaqueRegularQuads, opaqueLEDQuads);
        MekaPlateMultilayerModel.addParsedQuads(modelData, pos, transparentMap, transparentRegularQuads, transparentLEDQuads);
    }

    private static void addParsedQuads(BaseModelCache.MekanismModelData modelData, MekaSuitArmor.ModelPos pos, Map<MekaSuitArmor.ModelPos, List<BakedQuad>> map, Set<String> quads, Set<String> ledQuads) {
        List<BakedQuad> bakedQuads = MekaPlateMultilayerModel.getQuads(modelData, quads, ledQuads, pos.getTransform());
        if (!bakedQuads.isEmpty()) {
            map.computeIfAbsent(pos, p -> new ArrayList()).addAll(bakedQuads);
        }
    }

    private static void parseTransparency(MekaSuitArmor.ModelPos pos, Set<String> opaqueQuads, Set<String> transparentQuads, Map<MekaSuitArmor.ModelPos, Set<String>> quads) {
        for (String quad : quads.getOrDefault(pos, Collections.emptySet())) {
            if (quad.contains(GLASS_TAG)) {
                transparentQuads.add(quad);
                continue;
            }
            opaqueQuads.add(quad);
        }
    }

    private static List<BakedQuad> getQuads(BaseModelCache.MekanismModelData data, Set<String> parts, Set<String> ledParts, @Nullable QuadTransformation transform) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Object random = level != null ? level.m_213780_() : new LegacyRandomSource(42L);
        List<Object> quads = new ArrayList<BakedQuad>();
        if (!parts.isEmpty()) {
            quads.addAll(data.bake((IGeometryBakingContext)new MekaSuitModelConfiguration(parts)).getQuads(null, null, random, ModelData.EMPTY, null));
        }
        if (!ledParts.isEmpty()) {
            List ledQuads = data.bake((IGeometryBakingContext)new MekaSuitModelConfiguration(ledParts)).getQuads(null, null, random, ModelData.EMPTY, null);
            quads.addAll(QuadUtils.transformBakedQuads((List)ledQuads, (QuadTransformation)QuadTransformation.fullbright));
        }
        if (transform != null) {
            quads = QuadUtils.transformBakedQuads(quads, (QuadTransformation)transform);
        }
        return quads;
    }

    private static String processOverrideName(String part, String name) {
        return part.replaceFirst(OVERRIDDEN_TAG, "").replaceFirst(name + "_", "");
    }

    @NotNull
    public Model setup(@NotNull LivingEntity living, @NotNull ItemStack stack, @NotNull EquipmentSlot slot, @NotNull HumanoidModel<?> base, @NotNull ArmorModelManager.ArmorModel model) {
        this.living = living;
        this.stack = stack;
        return super.setup(living, stack, slot, base, model);
    }

    public void m_7695_(@NotNull PoseStack matrices, @NotNull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.m_7695_(matrices, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (this.base != null) {
            this.renderMekaSuit((HumanoidModel<? extends LivingEntity>)this.base, matrices, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), packedLightIn, packedOverlayIn, MekaPlateMultilayerModel.getColor(this.stack), 0.05f + 0.5f * Mth.m_14031_((float)((float)this.living.f_19797_ * (float)Math.PI)), this.stack.m_41790_(), this.living);
        }
    }

    private void renderMekaSuit(HumanoidModel<? extends LivingEntity> baseModel, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, Color color, float partialTicks, boolean hasEffect, LivingEntity entity) {
        ArmorQuads armorQuads = (ArmorQuads)this.cache.getUnchecked((Object)this.key(entity));
        this.render(baseModel, renderer, matrix, light, overlayLight, color, hasEffect, entity, armorQuads.opaqueQuads(), false);
        if (this.type == EquipmentSlot.CHEST) {
            BoltRenderer boltRenderer = boltRenderMap.computeIfAbsent(entity.m_20148_(), id -> new BoltRenderer());
            if (IModuleHelper.INSTANCE.isEnabled(entity.m_6844_(EquipmentSlot.CHEST), (IModuleDataProvider)MekanismModules.GRAVITATIONAL_MODULATING_UNIT)) {
                BoltEffect leftBolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, new Vec3(-0.01, 0.35, 0.37), new Vec3(-0.01, 0.15, 0.37), 10).size(0.012f).lifespan(6).spawn(BoltEffect.SpawnFunction.noise((float)3.0f, (float)1.0f));
                BoltEffect rightBolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, new Vec3(0.025, 0.35, 0.37), new Vec3(0.025, 0.15, 0.37), 10).size(0.012f).lifespan(6).spawn(BoltEffect.SpawnFunction.noise((float)3.0f, (float)1.0f));
                boltRenderer.update((Object)0, leftBolt, partialTicks);
                boltRenderer.update((Object)1, rightBolt, partialTicks);
            }
            matrix.m_85836_();
            MekaSuitArmor.ModelPos.BODY.translate(baseModel, matrix, entity);
            boltRenderer.render(partialTicks, matrix, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_());
            matrix.m_85849_();
        }
        this.render(baseModel, renderer, matrix, light, overlayLight, Color.WHITE, hasEffect, entity, armorQuads.transparentQuads(), true);
    }

    private void render(HumanoidModel<? extends LivingEntity> baseModel, MultiBufferSource renderer, PoseStack matrix, int light, int overlayLight, Color color, boolean hasEffect, LivingEntity entity, Map<MekaSuitArmor.ModelPos, List<BakedQuad>> quadMap, boolean transparent) {
        if (!quadMap.isEmpty()) {
            RenderType renderType = transparent ? RenderType.m_110473_((ResourceLocation)InventoryMenu.f_39692_) : MekanismRenderType.MEKASUIT;
            VertexConsumer builder = ItemRenderer.m_115222_((MultiBufferSource)renderer, (RenderType)renderType, (boolean)false, (boolean)hasEffect);
            for (Map.Entry<MekaSuitArmor.ModelPos, List<BakedQuad>> entry : quadMap.entrySet()) {
                matrix.m_85836_();
                entry.getKey().translate(baseModel, matrix, entity);
                this.putQuads(entry.getValue(), builder, matrix.m_85850_(), light, overlayLight, color);
                matrix.m_85849_();
            }
        }
    }

    private void putQuads(List<BakedQuad> quads, VertexConsumer builder, PoseStack.Pose pose, int light, int overlayLight, Color color) {
        for (BakedQuad quad : quads) {
            builder.putBulkData(pose, quad, color.rf(), color.gf(), color.bf(), color.af(), light, overlayLight, false);
        }
    }

    public QuickHash key(LivingEntity player) {
        Object2BooleanOpenHashMap modules = new Object2BooleanOpenHashMap();
        EnumSet<EquipmentSlot> wornParts = EnumSet.noneOf(EquipmentSlot.class);
        IModuleHelper moduleHelper = IModuleHelper.INSTANCE;
        for (EquipmentSlot slotType : EnumUtils.ARMOR_SLOTS) {
            ItemStack wornItem = player.m_6844_(slotType);
            if (wornItem.m_41619_() || !(wornItem.m_41720_() instanceof ModifiableMekaSuitArmor)) continue;
            wornParts.add(slotType);
            for (Map.Entry entry : moduleModelSpec.row((Object)slotType).entrySet()) {
                if (!moduleHelper.isEnabled(wornItem, (IModuleDataProvider)entry.getKey())) continue;
                ModuleModelSpec spec = (ModuleModelSpec)entry.getValue();
                modules.put((Object)spec, spec.isActive(player));
            }
        }
        return new QuickHash(new Object[]{modules.isEmpty() ? Object2BooleanMaps.emptyMap() : modules, wornParts.isEmpty() ? Collections.emptySet() : wornParts, MekanismUtils.getItemInHand((LivingEntity)player, (HumanoidArm)HumanoidArm.LEFT).m_41720_() instanceof ItemMekaTool, MekanismUtils.getItemInHand((LivingEntity)player, (HumanoidArm)HumanoidArm.RIGHT).m_41720_() instanceof ItemMekaTool});
    }

    private ArmorQuads createQuads(Object2BooleanMap<ModuleModelSpec> modules, Set<EquipmentSlot> wornParts, boolean hasMekaToolLeft, boolean hasMekaToolRight) {
        Object2ObjectOpenHashMap specialQuadsToRender = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap specialLEDQuadsToRender = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap overrides = new Object2ObjectOpenHashMap();
        HashSet<String> ignored = new HashSet<String>();
        if (!modules.isEmpty()) {
            Set matchedParts;
            Object2ObjectOpenHashMap allMatchedParts = new Object2ObjectOpenHashMap();
            for (ModuleOBJModelData moduleOBJModelData : MekaPlateModelCache.INSTANCE.MEKASUIT_MODULES) {
                matchedParts = allMatchedParts.computeIfAbsent(moduleOBJModelData, d -> new HashSet());
                for (Object2BooleanMap.Entry entry : modules.object2BooleanEntrySet()) {
                    ModuleModelSpec spec = (ModuleModelSpec)entry.getKey();
                    for (String name : moduleOBJModelData.getPartsForSpec(spec, entry.getBooleanValue())) {
                        if (name.contains(OVERRIDDEN_TAG)) {
                            overrides.put(spec.processOverrideName(name), new OverrideData((BaseModelCache.MekanismModelData)moduleOBJModelData, name));
                        }
                        if (this.type != spec.slotType) continue;
                        matchedParts.add(name);
                    }
                }
            }
            for (Map.Entry entry : allMatchedParts.entrySet()) {
                matchedParts = (Set)entry.getValue();
                if (matchedParts.isEmpty()) continue;
                BaseModelCache.MekanismModelData modelData = (BaseModelCache.MekanismModelData)entry.getKey();
                Map quadsToRender = specialQuadsToRender.computeIfAbsent(modelData, d -> new EnumMap(MekaSuitArmor.ModelPos.class));
                Map ledQuadsToRender = specialLEDQuadsToRender.computeIfAbsent(modelData, d -> new EnumMap(MekaSuitArmor.ModelPos.class));
                for (String name : matchedParts) {
                    MekaSuitArmor.ModelPos modelPos = MekaSuitArmor.ModelPos.get((String)name);
                    if (modelPos == null) {
                        Mekanism.logger.warn("MekaSuit part '{}' is invalid from modules model. Ignoring.", (Object)name);
                        continue;
                    }
                    MekaPlateMultilayerModel.addQuadsToRender(modelPos, name, (Map<String, OverrideData>)overrides, quadsToRender, ledQuadsToRender, (Map<BaseModelCache.MekanismModelData, Map<MekaSuitArmor.ModelPos, Set<String>>>)specialQuadsToRender, (Map<BaseModelCache.MekanismModelData, Map<MekaSuitArmor.ModelPos, Set<String>>>)specialLEDQuadsToRender);
                }
            }
        }
        if (this.type == EquipmentSlot.CHEST) {
            if (hasMekaToolLeft) {
                MekaPlateMultilayerModel.processMekaTool(MekanismModelCache.INSTANCE.MEKATOOL_LEFT_HAND, ignored);
            }
            if (hasMekaToolRight) {
                MekaPlateMultilayerModel.processMekaTool(MekanismModelCache.INSTANCE.MEKATOOL_RIGHT_HAND, ignored);
            }
        }
        EnumMap<MekaSuitArmor.ModelPos, Set<String>> armorQuadsToRender = new EnumMap<MekaSuitArmor.ModelPos, Set<String>>(MekaSuitArmor.ModelPos.class);
        EnumMap<MekaSuitArmor.ModelPos, Set<String>> armorLEDQuadsToRender = new EnumMap<MekaSuitArmor.ModelPos, Set<String>>(MekaSuitArmor.ModelPos.class);
        for (String name : MekaPlateModelCache.INSTANCE.MEKASUIT_EXO.getModel().getRootComponentNames()) {
            if (!MekaPlateMultilayerModel.checkEquipment(this.type, name) || (!name.startsWith(EXCLUSIVE_TAG) ? name.startsWith(SHARED_TAG) && wornParts.contains(this.adjacentType) && this.adjacentType.ordinal() > this.type.ordinal() : wornParts.contains(this.adjacentType))) continue;
            MekaSuitArmor.ModelPos pos = MekaSuitArmor.ModelPos.get((String)name);
            if (pos == null) {
                Mekanism.logger.warn("MekaSuit part '{}' is invalid. Ignoring.", (Object)name);
                continue;
            }
            if (ignored.contains(name)) continue;
            MekaPlateMultilayerModel.addQuadsToRender(pos, name, (Map<String, OverrideData>)overrides, armorQuadsToRender, armorLEDQuadsToRender, (Map<BaseModelCache.MekanismModelData, Map<MekaSuitArmor.ModelPos, Set<String>>>)specialQuadsToRender, (Map<BaseModelCache.MekanismModelData, Map<MekaSuitArmor.ModelPos, Set<String>>>)specialLEDQuadsToRender);
        }
        EnumMap<MekaSuitArmor.ModelPos, List<BakedQuad>> enumMap = new EnumMap<MekaSuitArmor.ModelPos, List<BakedQuad>>(MekaSuitArmor.ModelPos.class);
        EnumMap<MekaSuitArmor.ModelPos, List<BakedQuad>> transparentMap = new EnumMap<MekaSuitArmor.ModelPos, List<BakedQuad>>(MekaSuitArmor.ModelPos.class);
        for (MekaSuitArmor.ModelPos pos : MekaSuitArmor.ModelPos.VALUES) {
            for (BaseModelCache.MekanismModelData mekanismModelData : MekaPlateModelCache.INSTANCE.MEKASUIT_MODULES) {
                MekaPlateMultilayerModel.parseTransparency(mekanismModelData, pos, enumMap, transparentMap, specialQuadsToRender.getOrDefault(mekanismModelData, Collections.emptyMap()), specialLEDQuadsToRender.getOrDefault(mekanismModelData, Collections.emptyMap()));
            }
            MekaPlateMultilayerModel.parseTransparency((BaseModelCache.MekanismModelData)MekaPlateModelCache.INSTANCE.MEKASUIT_EXO, pos, enumMap, transparentMap, armorQuadsToRender, armorLEDQuadsToRender);
        }
        return new ArmorQuads(enumMap, transparentMap);
    }

    private record ModuleModelSpec(ModuleData<?> module, EquipmentSlot slotType, String name, Predicate<LivingEntity> isActive) {
        public int score(String name) {
            return name.indexOf(this.name + "_");
        }

        public boolean isActive(LivingEntity entity) {
            return this.isActive.test(entity);
        }

        public String processOverrideName(String part) {
            return MekaPlateMultilayerModel.processOverrideName(part, this.name);
        }
    }

    private record OverrideData(BaseModelCache.MekanismModelData modelData, String name) {
    }

    private record MekaSuitModelConfiguration(Set<String> parts) implements IGeometryBakingContext
    {
        private static final Material NO_MATERIAL = new Material(TextureAtlas.f_118259_, MissingTextureAtlasSprite.m_118071_());

        private MekaSuitModelConfiguration {
            parts = parts.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(parts);
        }

        @NotNull
        public String getModelName() {
            return "mekanism:mekasuit";
        }

        public boolean hasMaterial(@NotNull String name) {
            return false;
        }

        @NotNull
        public Material getMaterial(@NotNull String name) {
            return NO_MATERIAL;
        }

        public boolean isGui3d() {
            return false;
        }

        public boolean useBlockLight() {
            return false;
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        @Deprecated
        @NotNull
        public ItemTransforms getTransforms() {
            return ItemTransforms.f_111786_;
        }

        @NotNull
        public Transformation getRootTransform() {
            return Transformation.m_121093_();
        }

        @Nullable
        public ResourceLocation getRenderTypeHint() {
            return null;
        }

        public boolean isComponentVisible(String component, boolean fallback) {
            return this.parts.contains(component);
        }
    }

    private record ArmorQuads(Map<MekaSuitArmor.ModelPos, List<BakedQuad>> opaqueQuads, Map<MekaSuitArmor.ModelPos, List<BakedQuad>> transparentQuads) {
        public ArmorQuads {
            if (opaqueQuads.isEmpty()) {
                opaqueQuads = Collections.emptyMap();
            }
            if (transparentQuads.isEmpty()) {
                transparentQuads = Collections.emptyMap();
            }
        }
    }

    public static class ModuleOBJModelData
    extends BaseModelCache.OBJModelData {
        private final Map<ModuleModelSpec, SpecData> specParts = new Object2ObjectOpenHashMap();

        public ModuleOBJModelData(ResourceLocation rl) {
            super(rl);
        }

        public Set<String> getPartsForSpec(ModuleModelSpec spec, boolean active) {
            SpecData specData = this.specParts.get(spec);
            if (specData == null) {
                return Collections.emptySet();
            }
            return active ? specData.active() : specData.inactive();
        }

        protected void reload(ModelEvent.BakingCompleted evt) {
            super.reload(evt);
            Collection modules = moduleModelSpec.values();
            for (String string : this.getModel().getRootComponentNames()) {
                ModuleModelSpec matchingSpec = null;
                int bestScore = -1;
                for (ModuleModelSpec spec2 : modules) {
                    int score = spec2.score(string);
                    if (score == -1 || bestScore != -1 && score >= bestScore) continue;
                    bestScore = score;
                    matchingSpec = spec2;
                }
                if (matchingSpec == null) continue;
                SpecData specData = this.specParts.computeIfAbsent(matchingSpec, spec -> new SpecData(new HashSet<String>(), new HashSet<String>()));
                if (string.contains(MekaPlateMultilayerModel.INACTIVE_TAG + matchingSpec.name + "_")) {
                    specData.inactive().add(string);
                    continue;
                }
                specData.active().add(string);
            }
            for (Map.Entry entry : this.specParts.entrySet()) {
                SpecData specData = (SpecData)entry.getValue();
                if (specData.active().isEmpty()) {
                    entry.setValue(new SpecData(Collections.emptySet(), specData.inactive()));
                    continue;
                }
                if (!specData.inactive().isEmpty()) continue;
                entry.setValue(new SpecData(specData.active(), Collections.emptySet()));
            }
        }

        private record SpecData(Set<String> active, Set<String> inactive) {
        }
    }
}

