/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.slashblade;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.IOException;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdMotionPlayerGL2;
import jp.nyatla.nymmd.MmdPmdModelMc;
import jp.nyatla.nymmd.MmdPmdModel_BasicClass;
import jp.nyatla.nymmd.MmdVmdMotionMc;
import jp.nyatla.nymmd.MmdVmdMotion_BasicClass;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.client.renderer.layers.LayerMainBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.BladeMotionManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import moffy.ticex.client.modules.slashblade.SBToolRenderState;
import moffy.ticex.client.rendering.ItemRenderContext;
import moffy.ticex.item.modifiable.ModifiableSlashBladeItem;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class LayerSBToolMainBlade<T extends LivingEntity, M extends EntityModel<T>>
extends LayerMainBlade<T, M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LayerSBToolMainBlade.class);
    final LazyOptional<MmdPmdModelMc> bladeholder = LazyOptional.of(() -> {
        try {
            return new MmdPmdModelMc(new ResourceLocation("slashblade", "model/bladeholder.pmd"));
        }
        catch (IOException | MmdException e) {
            LOGGER.error("Error occurred", e);
            throw new RuntimeException(e);
        }
    });
    final LazyOptional<MmdMotionPlayerGL2> motionPlayer = LazyOptional.of(() -> {
        MmdMotionPlayerGL2 mmp = new MmdMotionPlayerGL2();
        this.bladeholder.ifPresent(pmd -> {
            try {
                mmp.setPmd((MmdPmdModel_BasicClass)pmd);
            }
            catch (MmdException e) {
                LOGGER.error("Error occurred", (Throwable)e);
            }
        });
        return mmp;
    });

    public LayerSBToolMainBlade(RenderLayerParent<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void renderStandbyBlade(PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, ItemStack blade, T entity) {
        ItemRenderContext itemRenderContext = new ItemRenderContext(blade, ItemDisplayContext.FIXED, false, matrixStack, bufferIn, lightIn, OverlayTexture.f_118083_);
        LazyOptional state = blade.getCapability(CapabilitySlashBlade.BLADESTATE);
        state.ifPresent(s -> {
            double modelScaleBase = 0.0078125;
            double motionScale = 0.125;
            try (MSAutoCloser msacA = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
                matrixStack.m_252880_(0.0f, 1.5f, 0.0f);
                CarryType carrytype = s.getCarryType();
                Minecraft mcinstance = Minecraft.m_91087_();
                switch (carrytype) {
                    case PSO2: {
                        matrixStack.m_252880_(1.0f, -1.125f, 0.2f);
                        matrixStack.m_252781_(new Quaternionf().rotateZYX(-0.122173f, 0.0f, 0.0f));
                        if (mcinstance.f_91066_.m_92176_() != CameraType.FIRST_PERSON || entity != mcinstance.f_91074_) break;
                        return;
                    }
                    case KATANA: {
                        matrixStack.m_252880_(0.25f, -0.875f, -0.55f);
                        matrixStack.m_252781_(new Quaternionf().rotateZYX((float)Math.PI, 1.570796f, 0.261799f));
                        break;
                    }
                    case DEFAULT: {
                        matrixStack.m_252880_(0.25f, -0.875f, -0.55f);
                        matrixStack.m_252781_(new Quaternionf().rotateZYX(0.0f, 1.570796f, 0.261799f));
                        break;
                    }
                    case NINJA: {
                        matrixStack.m_252880_(-0.5f, -2.0f, 0.2f);
                        matrixStack.m_252781_(new Quaternionf().rotateZYX(-2.094395f, 0.0f, (float)Math.PI));
                        if (mcinstance.f_91066_.m_92176_() != CameraType.FIRST_PERSON || entity != mcinstance.f_91074_) break;
                        return;
                    }
                    case RNINJA: {
                        matrixStack.m_252880_(0.5f, -2.0f, 0.2f);
                        matrixStack.m_252781_(new Quaternionf().rotateZYX(-1.047198f, 0.0f, 0.0f));
                        if (mcinstance.f_91066_.m_92176_() != CameraType.FIRST_PERSON || entity != mcinstance.f_91074_) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                matrixStack.m_85841_((float)motionScale, (float)motionScale, (float)motionScale);
                matrixStack.m_85841_(modelScale, modelScale, modelScale);
                try (MSAutoCloser msac = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
                    String part = s.isBroken() ? "blade_damaged" : "blade";
                    this.renderToolSlashBlade(blade, itemRenderContext, (ISlashBladeState)s, part, matrixStack, bufferIn, lightIn);
                    this.renderToolSlashBlade(blade, itemRenderContext, (ISlashBladeState)s, "sheath", matrixStack, bufferIn, lightIn);
                }
            }
        });
    }

    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderOffhandItem(matrixStack, bufferIn, lightIn, (LivingEntity)entity);
        float motionYOffset = 1.5f;
        double motionScale = 0.125;
        double modelScaleBase = 0.0078125;
        ItemStack stack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41619_()) {
            return;
        }
        ItemRenderContext itemRenderContext = new ItemRenderContext(stack, ItemDisplayContext.FIXED, false, matrixStack, bufferIn, lightIn, OverlayTexture.f_118083_);
        LazyOptional state = stack.getCapability(CapabilitySlashBlade.BLADESTATE);
        state.ifPresent(s -> this.motionPlayer.ifPresent(mmp -> {
            double time;
            ComboState combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(s.getComboSeq()) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(s.getComboSeq()) : (ComboState)ComboStateRegistry.NONE.get();
            for (time = TimeValueHelper.getMSecFromTicks((double)((float)Math.max(0L, entity.m_9236_().m_46467_() - s.getLastActionTime()) + partialTicks)); combo != ComboStateRegistry.NONE.get() && (double)combo.getTimeoutMS() < time; time -= (double)combo.getTimeoutMS()) {
                combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(combo.getNextOfTimeout(entity)) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(combo.getNextOfTimeout(entity)) : (ComboState)ComboStateRegistry.NONE.get();
            }
            if (combo == ComboStateRegistry.NONE.get()) {
                combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(s.getComboRoot()) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(s.getComboRoot()) : (ComboState)ComboStateRegistry.STANDBY.get();
            }
            MmdVmdMotionMc motion = BladeMotionManager.getInstance().getMotion(combo.getMotionLoc());
            double maxSeconds = 0.0;
            try {
                mmp.setVmd((MmdVmdMotion_BasicClass)motion);
                maxSeconds = TimeValueHelper.getMSecFromFrames((double)motion.getMaxFrame());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            double start = TimeValueHelper.getMSecFromFrames((double)combo.getStartFrame());
            double end = TimeValueHelper.getMSecFromFrames((double)combo.getEndFrame());
            double span = Math.abs(end - start);
            span = Math.min(maxSeconds, span);
            if (combo.getLoop()) {
                time %= span;
            }
            time = Math.min(span, time);
            time = start + time;
            try {
                mmp.updateMotion((float)time);
            }
            catch (MmdException e) {
                e.printStackTrace();
            }
            try (MSAutoCloser msacA = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
                PoseStack.Pose entry;
                Matrix4f mat;
                int idx;
                this.setUserPose(matrixStack, (LivingEntity)entity, partialTicks);
                matrixStack.m_252880_(0.0f, motionYOffset, 0.0f);
                matrixStack.m_85841_((float)motionScale, (float)motionScale, (float)motionScale);
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                WavefrontObject obj = BladeModelManager.getInstance().getModel(s.getModel().orElse(DefaultResources.resourceDefaultModel));
                try (MSAutoCloser msac = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
                    idx = mmp.getBoneIndexByName("hardpointA");
                    if (0 <= idx) {
                        float[] buf = new float[16];
                        mmp._skinning_mat[idx].getValue(buf);
                        mat = VectorHelper.matrix4fFromArray((float[])buf);
                        matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                        entry = matrixStack.m_85850_();
                        entry.m_252922_().mul((Matrix4fc)mat);
                        matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                    }
                    float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                    matrixStack.m_85841_(modelScale, modelScale, modelScale);
                    String part = s.isBroken() ? "blade_damaged" : "blade";
                    this.renderToolSlashBlade(stack, itemRenderContext, (ISlashBladeState)s, part, matrixStack, bufferIn, lightIn);
                }
                msac = MSAutoCloser.pushMatrix((PoseStack)matrixStack);
                try {
                    idx = mmp.getBoneIndexByName("hardpointB");
                    if (0 <= idx) {
                        float[] buf = new float[16];
                        mmp._skinning_mat[idx].getValue(buf);
                        mat = VectorHelper.matrix4fFromArray((float[])buf);
                        matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                        entry = matrixStack.m_85850_();
                        entry.m_252922_().mul((Matrix4fc)mat);
                        matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                    }
                    float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                    matrixStack.m_85841_(modelScale, modelScale, modelScale);
                    this.renderToolSlashBlade(stack, itemRenderContext, (ISlashBladeState)s, "sheath", matrixStack, bufferIn, lightIn);
                    if (s.isCharged(entity)) {
                        float f = (float)entity.f_19797_ + partialTicks;
                        BladeRenderState.renderChargeEffect((ItemStack)stack, (float)f, (WavefrontObject)obj, (String)"effect", (ResourceLocation)new ResourceLocation("textures/entity/creeper/creeper_armor.png"), (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                    }
                }
                finally {
                    if (msac != null) {
                        msac.close();
                    }
                }
            }
        }));
    }

    public void renderItemEntity(PoseStack matrixStack, MultiBufferSource bufferIn, ItemRenderContext itemRenderContext, int lightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41619_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ModifiableSlashBladeItem)) {
            return;
        }
        this.renderOffhandItem(matrixStack, bufferIn, lightIn, (LivingEntity)entity);
        float motionYOffset = 1.5f;
        double motionScale = 0.125;
        double modelScaleBase = 0.0078125;
        if (stack.m_41619_()) {
            return;
        }
        LazyOptional state = stack.getCapability(CapabilitySlashBlade.BLADESTATE);
        state.ifPresent(bladeState -> {
            WavefrontObject model = BladeModelManager.getInstance().getModel(bladeState.getModel().orElse(DefaultResources.resourceDefaultModel));
            this.motionPlayer.ifPresent(mmp -> {
                double time;
                ComboState combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(bladeState.getComboSeq()) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(bladeState.getComboSeq()) : (ComboState)ComboStateRegistry.NONE.get();
                for (time = TimeValueHelper.getMSecFromTicks((double)((float)Math.max(0L, entity.m_9236_().m_46467_() - bladeState.getLastActionTime()) + partialTicks)); combo != ComboStateRegistry.NONE.get() && combo != null && (double)combo.getTimeoutMS() < time; time -= (double)combo.getTimeoutMS()) {
                    combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(combo.getNextOfTimeout(entity)) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(combo.getNextOfTimeout(entity)) : (ComboState)ComboStateRegistry.NONE.get();
                }
                if (combo == ComboStateRegistry.NONE.get()) {
                    combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(bladeState.getComboRoot()) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(bladeState.getComboRoot()) : (ComboState)ComboStateRegistry.STANDBY.get();
                }
                MmdVmdMotionMc motion = BladeMotionManager.getInstance().getMotion(combo.getMotionLoc());
                double maxSeconds = 0.0;
                try {
                    mmp.setVmd((MmdVmdMotion_BasicClass)motion);
                    maxSeconds = TimeValueHelper.getMSecFromFrames((double)motion.getMaxFrame());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                double start = TimeValueHelper.getMSecFromFrames((double)combo.getStartFrame());
                double end = TimeValueHelper.getMSecFromFrames((double)combo.getEndFrame());
                double span = Math.abs(end - start);
                span = Math.min(maxSeconds, span);
                if (combo.getLoop()) {
                    time %= span;
                }
                time = Math.min(span, time);
                time = start + time;
                try {
                    mmp.updateMotion((float)time);
                }
                catch (MmdException e) {
                    e.printStackTrace();
                }
                try (MSAutoCloser msacA = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
                    PoseStack.Pose entry;
                    Matrix4f mat;
                    int idx;
                    this.setUserPose(matrixStack, (LivingEntity)entity, partialTicks);
                    matrixStack.m_252880_(0.0f, motionYOffset, 0.0f);
                    matrixStack.m_85841_((float)motionScale, (float)motionScale, (float)motionScale);
                    matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    try (MSAutoCloser msac = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
                        idx = mmp.getBoneIndexByName("hardpointA");
                        if (0 <= idx) {
                            float[] buf = new float[16];
                            mmp._skinning_mat[idx].getValue(buf);
                            mat = VectorHelper.matrix4fFromArray((float[])buf);
                            matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                            entry = matrixStack.m_85850_();
                            entry.m_252922_().mul((Matrix4fc)mat);
                            matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                        }
                        float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                        matrixStack.m_85841_(modelScale, modelScale, modelScale);
                        String part = bladeState.isBroken() ? "blade_damaged" : "blade";
                        this.renderToolSlashBlade(stack, itemRenderContext, (ISlashBladeState)bladeState, part, matrixStack, bufferIn, lightIn);
                    }
                    msac = MSAutoCloser.pushMatrix((PoseStack)matrixStack);
                    try {
                        idx = mmp.getBoneIndexByName("hardpointB");
                        if (0 <= idx) {
                            float[] buf = new float[16];
                            mmp._skinning_mat[idx].getValue(buf);
                            mat = VectorHelper.matrix4fFromArray((float[])buf);
                            matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                            entry = matrixStack.m_85850_();
                            entry.m_252922_().mul((Matrix4fc)mat);
                            matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                        }
                        float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                        matrixStack.m_85841_(modelScale, modelScale, modelScale);
                        this.renderToolSlashBlade(stack, itemRenderContext, (ISlashBladeState)bladeState, "sheath", matrixStack, bufferIn, lightIn);
                        if (bladeState.isCharged(entity)) {
                            float f = (float)entity.f_19797_ + partialTicks;
                            BladeRenderState.renderChargeEffect((ItemStack)stack, (float)f, (WavefrontObject)model, (String)"effect", (ResourceLocation)new ResourceLocation("textures/entity/creeper/creeper_armor.png"), (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                        }
                    }
                    finally {
                        if (msac != null) {
                            msac.close();
                        }
                    }
                }
            });
        });
    }

    public void renderToolSlashBlade(ItemStack stack, ItemRenderContext itemRenderContext, ISlashBladeState state, String target, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.getModifierLevel(TicEXRegistry.KOSHIRAE_MODIFIER.get()) > 0) {
            ResourceLocation textureLocation;
            WavefrontObject model;
            CompoundTag persistentTag = stack.m_41784_().m_128469_("bladeState");
            if (persistentTag.m_128441_("ModelName")) {
                model = BladeModelManager.getInstance().getModel(ResourceLocation.m_135820_((String)persistentTag.m_128461_("ModelName")));
                textureLocation = ResourceLocation.m_135820_((String)persistentTag.m_128461_("TextureName"));
            } else {
                model = BladeModelManager.getInstance().getModel(state.getModel().orElse(DefaultResources.resourceDefaultModel));
                textureLocation = state.getTexture().orElse(DefaultResources.resourceDefaultTexture);
            }
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)model, (String)target, (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)model, (String)(target + "_luminous"), (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
        } else if (tool.getMaterials().size() > 0) {
            WavefrontObject model = BladeModelManager.getInstance().getModel(state.getModel().orElse(DefaultResources.resourceDefaultModel));
            SBToolRenderState.renderOverride(stack, itemRenderContext, tool, model, target, matrixStackIn, bufferIn, packedLightIn);
            SBToolRenderState.renderOverrideLuminous(stack, itemRenderContext, tool, model, target, matrixStackIn, bufferIn, packedLightIn);
        } else {
            WavefrontObject model = BladeModelManager.getInstance().getModel(state.getModel().orElse(DefaultResources.resourceDefaultModel));
            ResourceLocation textureLocation = state.getTexture().orElse(DefaultResources.resourceDefaultTexture);
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)model, (String)target, (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)model, (String)(target + "_luminous"), (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
        }
    }
}

