/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.slashblade;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import mods.flammpfeil.slashblade.client.renderer.entity.BladeItemEntityRenderer;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import moffy.ticex.client.modules.slashblade.SBToolRenderState;
import moffy.ticex.client.rendering.ItemRenderContext;
import moffy.ticex.entity.slashblade.SBToolItemEntity;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class SBToolBladeItemRenderer
extends BladeItemEntityRenderer {
    public SBToolBladeItemRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void m_7392_(ItemEntity itemIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ItemRenderContext itemRenderContext = new ItemRenderContext(itemIn.m_32055_(), ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.f_118083_);
        this.f_114477_ = 0.0f;
        if (!itemIn.m_32055_().m_41619_()) {
            this.renderBlade(itemIn, itemRenderContext, entityYaw, partialTicks);
        } else {
            partialTicks = (float)((double)itemIn.f_31983_ * 20.0 - (double)itemIn.m_32059_());
            super.m_7392_(itemIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private void renderBlade(ItemEntity itemIn, ItemRenderContext itemRenderContext, float entityYaw, float partialTicks) {
        block29: {
            PoseStack matrixStackIn = itemRenderContext.poseStack();
            MultiBufferSource bufferIn = itemRenderContext.bufferSource();
            int packedLightIn = itemRenderContext.combinedLight();
            if (itemIn instanceof SBToolItemEntity) {
                SBToolItemEntity bladeItem = (SBToolItemEntity)itemIn;
                try (MSAutoCloser msac = MSAutoCloser.pushMatrix((PoseStack)matrixStackIn);){
                    matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(entityYaw));
                    ItemStack current = itemIn.m_32055_();
                    EnumSet types = SwordType.from((ItemStack)current);
                    itemIn.getPersistentData();
                    Optional modelLoc = current.getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
                        Optional rl = state.getModel();
                        Objects.requireNonNull(bladeItem);
                        return rl.orElseGet(() -> ((SBToolItemEntity)bladeItem).getModel());
                    });
                    Objects.requireNonNull(bladeItem);
                    ResourceLocation modelLocation = modelLoc.orElseGet(() -> ((SBToolItemEntity)bladeItem).getModel());
                    Optional textureLoc = current.getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
                        Optional rl = state.getTexture();
                        Objects.requireNonNull(bladeItem);
                        return rl.orElseGet(() -> ((SBToolItemEntity)bladeItem).getTexture());
                    });
                    Objects.requireNonNull(bladeItem);
                    ResourceLocation textureLocation = textureLoc.orElseGet(() -> ((SBToolItemEntity)bladeItem).getTexture());
                    WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
                    float scale = 0.00625f;
                    try (MSAutoCloser msac2 = MSAutoCloser.pushMatrix((PoseStack)matrixStackIn);){
                        String renderTarget;
                        float heightOffset;
                        float xOffset = 0.0f;
                        if (types.contains(SwordType.EDGEFRAGMENT)) {
                            heightOffset = 225.0f;
                            xOffset = 200.0f;
                            renderTarget = "blade_fragment";
                        } else if (types.contains(SwordType.BROKEN)) {
                            heightOffset = 100.0f;
                            xOffset = 30.0f;
                            renderTarget = "blade_damaged";
                        } else {
                            heightOffset = 225.0f;
                            xOffset = 120.0f;
                            renderTarget = "blade";
                        }
                        if (itemIn.m_20069_()) {
                            matrixStackIn.m_252880_(0.0f, 0.025f, 0.0f);
                            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(itemIn.f_31983_));
                            matrixStackIn.m_85841_(scale, scale, scale);
                            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                        } else if (!itemIn.m_20096_()) {
                            matrixStackIn.m_85841_(scale, scale, scale);
                            float speed = -81.0f;
                            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(speed * ((float)itemIn.f_19797_ + partialTicks)));
                            matrixStackIn.m_252880_(xOffset, 0.0f, 0.0f);
                        } else {
                            matrixStackIn.m_85841_(scale, scale, scale);
                            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(60.0f + (float)Math.toDegrees((double)itemIn.f_31983_ / 6.0)));
                            matrixStackIn.m_252880_(heightOffset, 0.0f, 0.0f);
                        }
                        SBToolBladeItemRenderer.renderToolSlashBlade(current, itemRenderContext, model, textureLocation, renderTarget, matrixStackIn, bufferIn, packedLightIn);
                    }
                    if (!itemIn.m_20069_() && (!itemIn.m_20096_() || types.contains(SwordType.NOSCABBARD))) break block29;
                    msac2 = MSAutoCloser.pushMatrix((PoseStack)matrixStackIn);
                    try {
                        matrixStackIn.m_252880_(0.0f, 0.025f, 0.0f);
                        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(itemIn.f_31983_));
                        if (!itemIn.m_20069_()) {
                            matrixStackIn.m_85837_(0.75, 0.0, -0.4);
                        }
                        matrixStackIn.m_85841_(scale, scale, scale);
                        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                        String renderTarget = "sheath";
                        SBToolBladeItemRenderer.renderToolSlashBlade(current, itemRenderContext, model, textureLocation, renderTarget, matrixStackIn, bufferIn, packedLightIn);
                    }
                    finally {
                        if (msac2 != null) {
                            msac2.close();
                        }
                    }
                }
            }
        }
    }

    public static void renderToolSlashBlade(ItemStack stack, ItemRenderContext itemRenderContext, WavefrontObject model, ResourceLocation textureLocation, String target, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.getModifierLevel(TicEXRegistry.KOSHIRAE_MODIFIER.get()) > 0) {
            CompoundTag persistentTag = stack.m_41784_().m_128469_("bladeState");
            if (persistentTag.m_128441_("ModelName")) {
                model = BladeModelManager.getInstance().getModel(ResourceLocation.m_135820_((String)persistentTag.m_128461_("ModelName")));
                textureLocation = ResourceLocation.m_135820_((String)persistentTag.m_128461_("TextureName"));
            }
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)model, (String)target, (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)model, (String)(target + "_luminous"), (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
        } else if (tool.getMaterials().size() > 0) {
            SBToolRenderState.renderOverride(stack, itemRenderContext, tool, model, target, matrixStackIn, bufferIn, packedLightIn);
            SBToolRenderState.renderOverrideLuminous(stack, itemRenderContext, tool, model, target, matrixStackIn, bufferIn, packedLightIn);
        } else {
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)model, (String)target, (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)model, (String)(target + "_luminous"), (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
        }
    }
}

