/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.slashblade;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModel;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBladeDetune;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import moffy.ticex.client.modules.slashblade.SBToolFirstPersonRender;
import moffy.ticex.client.modules.slashblade.SBToolRenderState;
import moffy.ticex.client.rendering.ItemRenderContext;
import moffy.ticex.item.modifiable.ModifiableSlashBladeItem;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class SBToolISTER
extends BlockEntityWithoutLevelRenderer {
    public SBToolISTER(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public void m_108829_(ItemStack itemStackIn, @NotNull ItemDisplayContext type, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!(itemStackIn.m_41720_() instanceof ModifiableSlashBladeItem)) {
            return;
        }
        this.renderBlade(itemStackIn, type, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    boolean checkRenderNaked() {
        ItemStack mainHand = BladeModel.user.m_21205_();
        return !(mainHand.m_41720_() instanceof ModifiableSlashBladeItem);
    }

    private void renderBlade(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemRenderContext itemRenderContext = new ItemRenderContext(stack, transformType, transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.NONE) {
            boolean handle;
            if (BladeModel.user == null) {
                Minecraft minecraftInstance = Minecraft.m_91087_();
                BladeModel.user = minecraftInstance.f_91074_;
            }
            if (BladeModel.user == null) {
                return;
            }
            boolean bl = BladeModel.user.m_5737_() == HumanoidArm.RIGHT ? transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : (handle = transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
            if (handle) {
                SBToolFirstPersonRender.getInstance().render(matrixStack, itemRenderContext, bufferIn, combinedLightIn);
            }
            return;
        }
        try (MSAutoCloser ignored = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
            matrixStack.m_252880_(0.5f, 0.5f, 0.5f);
            if (transformType == ItemDisplayContext.GROUND) {
                matrixStack.m_252880_(0.0f, 0.15f, 0.0f);
                this.renderIcon(stack, itemRenderContext, matrixStack, bufferIn, combinedLightIn, 0.005f);
            } else if (transformType == ItemDisplayContext.GUI) {
                this.renderIcon(stack, itemRenderContext, matrixStack, bufferIn, combinedLightIn, 0.008f, true);
            } else if (transformType == ItemDisplayContext.FIXED) {
                if (stack.m_41794_() && stack.m_41795_() instanceof BladeStandEntity) {
                    this.renderModel(stack, itemRenderContext, matrixStack, bufferIn, combinedLightIn);
                } else {
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    this.renderIcon(stack, itemRenderContext, matrixStack, bufferIn, combinedLightIn, 0.0095f);
                }
            } else {
                this.renderIcon(stack, itemRenderContext, matrixStack, bufferIn, combinedLightIn, 0.0095f);
            }
        }
    }

    private void renderIcon(ItemStack stack, ItemRenderContext itemRenderContext, PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, float scale) {
        this.renderIcon(stack, itemRenderContext, matrixStack, bufferIn, lightIn, scale, false);
    }

    private void renderIcon(ItemStack stack, ItemRenderContext itemRenderContext, PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, float scale, boolean renderDurability) {
        matrixStack.m_85841_(scale, scale, scale);
        EnumSet types = SwordType.from((ItemStack)stack);
        String renderTarget = types.contains(SwordType.BROKEN) ? "item_damaged" : "item_blade";
        this.renderToolSlashBlade(stack, itemRenderContext, renderTarget, matrixStack, bufferIn, lightIn);
        if (renderDurability) {
            WavefrontObject durabilityModel = BladeModelManager.getInstance().getModel(DefaultResources.resourceDurabilityModel);
            float durability = (float)stack.m_41773_() / (float)stack.m_41776_();
            matrixStack.m_252880_(0.0f, 0.0f, 0.1f);
            Color aCol = new Color(0.25f, 0.25f, 0.25f, 1.0f);
            Color bCol = new Color(10824803);
            int r = 0xFF & (int)Mth.m_14179_((float)aCol.getRed(), (float)bCol.getRed(), (float)durability);
            int g = 0xFF & (int)Mth.m_14179_((float)aCol.getGreen(), (float)bCol.getGreen(), (float)durability);
            int b = 0xFF & (int)Mth.m_14179_((float)aCol.getBlue(), (float)bCol.getBlue(), (float)durability);
            BladeRenderState.setCol((Color)new Color(r, g, b));
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)durabilityModel, (String)"base", (ResourceLocation)DefaultResources.resourceDurabilityTexture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
            boolean isBroken = types.contains(SwordType.BROKEN);
            matrixStack.m_252880_(0.0f, 0.0f, -2.0f * durability);
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)durabilityModel, (String)(isBroken ? "color_r" : "color"), (ResourceLocation)DefaultResources.resourceDurabilityTexture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
        }
    }

    private ResourceLocation stackDefaultModel(ItemStack stack) {
        String key;
        CompoundTag stateTag = stack.m_41698_("bladeState");
        String name = stateTag.m_128461_("ModelName");
        if (!(stack.m_41720_() instanceof ItemSlashBladeDetune) && !(key = stateTag.m_128461_("translationKey")).isBlank()) {
            ResourceLocation bladeName = ResourceLocation.m_135820_((String)key.substring(5).replaceFirst(Pattern.quote("."), Matcher.quoteReplacement(":")));
            SlashBladeDefinition slashBladeDefinition = (SlashBladeDefinition)BladeModelManager.getClientSlashBladeRegistry().m_7745_(bladeName);
            if (slashBladeDefinition != null) {
                name = slashBladeDefinition.getRenderDefinition().getModelName().toString();
            }
        }
        return !name.isBlank() ? ResourceLocation.m_135820_((String)name) : DefaultResources.resourceDefaultModel;
    }

    private ResourceLocation stackDefaultTexture(ItemStack stack) {
        String key;
        CompoundTag stateTag = stack.m_41698_("bladeState");
        String name = stateTag.m_128461_("TextureName");
        if (!(stack.m_41720_() instanceof ItemSlashBladeDetune) && !(key = stateTag.m_128461_("translationKey")).isBlank()) {
            ResourceLocation bladeName = ResourceLocation.m_135820_((String)key.substring(5).replaceFirst(Pattern.quote("."), Matcher.quoteReplacement(":")));
            SlashBladeDefinition slashBladeDefinition = (SlashBladeDefinition)BladeModelManager.getClientSlashBladeRegistry().m_7745_(bladeName);
            if (slashBladeDefinition != null) {
                name = slashBladeDefinition.getRenderDefinition().getTextureName().toString();
            }
        }
        return !name.isBlank() ? ResourceLocation.m_135820_((String)name) : DefaultResources.resourceDefaultTexture;
    }

    private void renderModel(ItemStack stack, ItemRenderContext itemRenderContext, PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn) {
        String renderTarget;
        ItemFrame itemFrame;
        float scale = 0.003125f;
        matrixStack.m_85841_(scale, scale, scale);
        float defaultOffset = 130.0f;
        matrixStack.m_252880_(defaultOffset, 0.0f, 0.0f);
        EnumSet types = SwordType.from((ItemStack)stack);
        Vec3 bladeOffset = Vec3.f_82478_;
        float bladeOffsetRot = 0.0f;
        float bladeOffsetBaseRot = -3.0f;
        Vec3 sheathOffset = Vec3.f_82478_;
        float sheathOffsetRot = 0.0f;
        float sheathOffsetBaseRot = -3.0f;
        boolean vFlip = false;
        boolean hFlip = false;
        boolean hasScabbard = true;
        if (stack.m_41794_() && (itemFrame = stack.m_41795_()) instanceof BladeStandEntity) {
            BladeStandEntity stand = (BladeStandEntity)itemFrame;
            Item type = stand.currentType;
            Pose pose = stand.m_20089_();
            switch (pose.ordinal()) {
                case 0: {
                    vFlip = false;
                    hFlip = false;
                    break;
                }
                case 1: {
                    vFlip = true;
                    hFlip = false;
                    break;
                }
                case 2: {
                    vFlip = true;
                    hFlip = true;
                    break;
                }
                case 3: {
                    vFlip = false;
                    hFlip = true;
                    break;
                }
                case 4: {
                    vFlip = false;
                    hFlip = false;
                    hasScabbard = false;
                    break;
                }
                case 5: {
                    vFlip = false;
                    hFlip = true;
                    hasScabbard = false;
                }
            }
            if (type == SBItems.bladestand_1) {
                bladeOffset = Vec3.f_82478_;
                sheathOffset = Vec3.f_82478_;
            } else if (type == SBItems.bladestand_2) {
                bladeOffset = new Vec3(0.0, 21.5, 0.0);
                sheathOffset = hFlip ? new Vec3(-40.0, -27.0, 0.0) : new Vec3(40.0, -27.0, 0.0);
                sheathOffsetBaseRot = -4.0f;
            } else if (type == SBItems.bladestand_v) {
                bladeOffset = new Vec3(-100.0, 230.0, 0.0);
                sheathOffset = new Vec3(-100.0, 230.0, 0.0);
                bladeOffsetRot = 80.0f;
                sheathOffsetRot = 80.0f;
            } else if (type == SBItems.bladestand_s) {
                if (hFlip) {
                    bladeOffset = new Vec3(60.0, -25.0, 0.0);
                    sheathOffset = new Vec3(60.0, -25.0, 0.0);
                } else {
                    bladeOffset = new Vec3(-60.0, -25.0, 0.0);
                    sheathOffset = new Vec3(-60.0, -25.0, 0.0);
                }
            } else if (type == SBItems.bladestand_1w) {
                bladeOffset = Vec3.f_82478_;
                sheathOffset = Vec3.f_82478_;
            } else if (type == SBItems.bladestand_2w) {
                bladeOffset = new Vec3(0.0, 21.5, 0.0);
                sheathOffset = hFlip ? new Vec3(-40.0, -27.0, 0.0) : new Vec3(40.0, -27.0, 0.0);
                sheathOffsetBaseRot = -4.0f;
            }
        }
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
            renderTarget = types.contains(SwordType.BROKEN) ? "blade_damaged" : "blade";
            matrixStack.m_85837_(bladeOffset.f_82479_, bladeOffset.f_82480_, bladeOffset.f_82481_);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(bladeOffsetRot));
            if (vFlip) {
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                matrixStack.m_252880_(0.0f, -15.0f, 0.0f);
                matrixStack.m_252880_(0.0f, 5.0f, 0.0f);
            }
            if (hFlip) {
                double offset = defaultOffset;
                matrixStack.m_85837_(-offset, 0.0, 0.0);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                matrixStack.m_85837_(offset, 0.0, 0.0);
            }
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(bladeOffsetBaseRot));
            this.renderToolSlashBlade(stack, itemRenderContext, renderTarget, matrixStack, bufferIn, lightIn);
        }
        if (hasScabbard) {
            msac = MSAutoCloser.pushMatrix((PoseStack)matrixStack);
            try {
                renderTarget = "sheath";
                matrixStack.m_85837_(sheathOffset.f_82479_, sheathOffset.f_82480_, sheathOffset.f_82481_);
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(sheathOffsetRot));
                if (vFlip) {
                    matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                    matrixStack.m_252880_(0.0f, -15.0f, 0.0f);
                    matrixStack.m_252880_(0.0f, 5.0f, 0.0f);
                }
                if (hFlip) {
                    double offset = defaultOffset;
                    matrixStack.m_85837_(-offset, 0.0, 0.0);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    matrixStack.m_85837_(offset, 0.0, 0.0);
                }
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(sheathOffsetBaseRot));
                this.renderToolSlashBlade(stack, itemRenderContext, renderTarget, matrixStack, bufferIn, lightIn);
            }
            finally {
                if (msac != null) {
                    msac.close();
                }
            }
        }
    }

    public void renderToolSlashBlade(ItemStack stack, ItemRenderContext itemRenderContext, String target, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ResourceLocation modelLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getModel().isPresent()).map(s -> (ResourceLocation)s.getModel().get()).orElseGet(() -> this.stackDefaultModel(stack));
        if (tool.getModifierLevel(TicEXRegistry.KOSHIRAE_MODIFIER.get()) > 0) {
            ResourceLocation textureLocation;
            WavefrontObject model;
            CompoundTag persistentTag = stack.m_41784_().m_128469_("bladeState");
            if (persistentTag.m_128441_("ModelName")) {
                model = BladeModelManager.getInstance().getModel(ResourceLocation.m_135820_((String)persistentTag.m_128461_("ModelName")));
                textureLocation = ResourceLocation.m_135820_((String)persistentTag.m_128461_("TextureName"));
            } else {
                model = BladeModelManager.getInstance().getModel(modelLocation);
                textureLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getTexture().isPresent()).map(s -> (ResourceLocation)s.getTexture().get()).orElseGet(() -> this.stackDefaultTexture(stack));
            }
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)model, (String)target, (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)model, (String)(target + "_luminous"), (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
        } else if (tool.getMaterials().size() > 0) {
            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
            SBToolRenderState.renderOverride(stack, itemRenderContext, tool, model, target, matrixStackIn, bufferIn, packedLightIn);
            SBToolRenderState.renderOverrideLuminous(stack, itemRenderContext, tool, model, target + "_luminous", matrixStackIn, bufferIn, packedLightIn);
        } else {
            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
            ResourceLocation textureLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getTexture().isPresent()).map(s -> (ResourceLocation)s.getTexture().get()).orElseGet(() -> this.stackDefaultTexture(stack));
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)model, (String)target, (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)model, (String)(target + "_luminous"), (ResourceLocation)textureLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
        }
    }
}

