/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.slashblade;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Optional;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.event.client.RenderOverrideEvent;
import moffy.ticex.client.modules.slashblade.SBToolRenderType;
import moffy.ticex.client.rendering.ItemRenderContext;
import moffy.ticex.client.rendering.shader.ShaderProvider;
import moffy.ticex.client.rendering.ticex.TicEXRenders;
import moffy.ticex.lib.utils.TicEXSBUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class SBToolRenderState {
    private static final Color defaultColor;
    private static Color col;

    public static void renderOverride(ItemStack stack, ItemRenderContext itemRenderContext, ToolStack tool, WavefrontObject model, String target, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        SBToolRenderState.renderOverride(stack, itemRenderContext, tool, model, target, matrixStackIn, bufferIn, packedLightIn, SBToolRenderType.instance::getSlashBladeBlend, true);
    }

    public static void renderOverrideLuminous(ItemStack stack, ItemRenderContext itemRenderContext, ToolStack tool, WavefrontObject model, String target, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        SBToolRenderState.renderOverride(stack, itemRenderContext, tool, model, target, matrixStackIn, bufferIn, packedLightIn, SBToolRenderType.instance::getSlashBladeLuminousBlend, false);
    }

    public static void renderOverride(ItemStack stack, ItemRenderContext itemRenderContext, ToolStack tool, WavefrontObject model, String target, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, RenderGetter<MaterialVariantId, Runnable, RenderType> getRenderType, boolean enableEffect) {
        MaterialNBT materials = tool.getMaterials();
        for (int i = 0; i < materials.size(); ++i) {
            MaterialVariantId material = materials.get(i).getVariant();
            SBToolRenderType.PartType partType = SBToolRenderType.PartType.byIndex(i);
            ShaderProvider.Tool shaderProvider = (ShaderProvider.Tool)TicEXRenders.TOOL_SHADERS.getShaderProvider((MaterialVariantId)material.getId());
            if (partType == null) continue;
            RenderType rt = getRenderType.getRenderType(material, partType, () -> {
                Optional optional = MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material);
                optional.ifPresent(materialRenderInfo -> {
                    col = new Color(materialRenderInfo.vertexColor());
                });
            });
            RenderOverrideEvent event = RenderOverrideEvent.onRenderOverride((ItemStack)stack, (WavefrontObject)model, (String)target, null, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, resourceLocation -> rt, (boolean)enableEffect);
            SBToolRenderState.renderVC(stack, itemRenderContext, shaderProvider, bufferIn, rt, matrixStackIn, event, packedLightIn, enableEffect, target, material, partType);
        }
    }

    public static void renderVC(ItemStack stack, ItemRenderContext itemRenderContext, ShaderProvider.Tool shaderProvider, MultiBufferSource bufferIn, RenderType rt, PoseStack matrixStackIn, RenderOverrideEvent event, int packedLightIn, boolean enableEffect, String target, MaterialVariantId material, SBToolRenderType.PartType partType) {
        VertexConsumer vb = bufferIn.m_6299_(rt);
        Face.setCol((Color)col);
        Face.setLightMap((int)packedLightIn);
        Face.setMatrix((PoseStack)matrixStackIn);
        TicEXSBUtils.tessellateWithShader(stack, itemRenderContext, shaderProvider, material, event.getModel(), vb, bufferIn, partType, event.getTarget());
        if (stack.m_41790_() && enableEffect) {
            vb = bufferIn.m_6299_(target.startsWith("item_") ? BladeRenderState.SLASHBLADE_ITEM_GLINT : BladeRenderState.SLASHBLADE_GLINT);
            event.getModel().tessellateOnly(vb, new String[]{event.getTarget()});
        }
        Face.resetMatrix();
        Face.resetLightMap();
        Face.resetCol();
        Face.resetAlphaOverride();
        Face.resetUvOperator();
        col = defaultColor;
    }

    static {
        col = defaultColor = Color.white;
    }

    @FunctionalInterface
    public static interface RenderGetter<P extends MaterialVariantId, Q extends Runnable, R extends RenderType> {
        public R getRenderType(P var1, SBToolRenderType.PartType var2, Q var3);
    }
}

