/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.slashblade;

import java.util.Optional;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class SBToolRenderType {
    public static SBToolRenderType instance = null;

    public static void init() {
        instance = new SBToolRenderType();
    }

    public RenderType getSlashBladeBlend(MaterialVariantId material, PartType partType, Runnable whenIsDefault) {
        return BladeRenderState.getSlashBladeBlend((ResourceLocation)partType.tryTexture(material, whenIsDefault));
    }

    public RenderType getSlashBladeLuminousBlend(MaterialVariantId material, PartType partType, Runnable whenIsDefault) {
        return BladeRenderState.getSlashBladeBlendLuminous((ResourceLocation)partType.tryTexture(material, whenIsDefault));
    }

    public static enum PartType {
        BLADE(0, "blade"),
        HANDLE(2, "handle"),
        SAYA(1, "saya");

        private static final ResourceLocation BLADE_TEXTURE_LOC;
        private static final ResourceLocation DEFAULT_BLADE_TEXTURE_LOC;
        private final int index;
        private final String name;

        private PartType(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public static PartType byIndex(int layerIndex) {
            switch (layerIndex) {
                case 0: {
                    return BLADE;
                }
                case 2: {
                    return HANDLE;
                }
                case 1: {
                    return SAYA;
                }
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public boolean textureExsists(ResourceLocation location) {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            Optional resource = resourceManager.m_213713_(location);
            return resource.isPresent();
        }

        public ResourceLocation tryTexture(MaterialVariantId material, Runnable whenIsDefault) {
            String suffix = "_" + material.getId().m_135827_() + "_" + material.getId().m_135815_();
            if (material.hasVariant()) {
                suffix = suffix + "_" + material.getVariant();
            }
            if (this.textureExsists(BLADE_TEXTURE_LOC.m_266382_(this.name + suffix + ".png"))) {
                return BLADE_TEXTURE_LOC.m_266382_(this.name + suffix + ".png");
            }
            if (whenIsDefault != null) {
                whenIsDefault.run();
            }
            return DEFAULT_BLADE_TEXTURE_LOC.m_266382_(this.name + ".png");
        }

        static {
            BLADE_TEXTURE_LOC = new ResourceLocation("ticex", "textures/item/shader/slashblade_tool/");
            DEFAULT_BLADE_TEXTURE_LOC = new ResourceLocation("ticex", "textures/obj_tool/slashblade_tool/");
        }
    }
}

