/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.ticex;

import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;

public class UnsyncedToolContainerMenu
extends ToolContainerMenu {
    public UnsyncedToolContainerMenu(int id, Inventory playerInventory, ItemStack stack, IItemHandler handler, int slotIndex) {
        super((MenuType)TicEXRegistry.UNSYNCED_TOOL_CONTAINER.get(), id, playerInventory, stack, handler, slotIndex);
    }

    public static ToolContainerMenu forClient(int id, Inventory inventory, FriendlyByteBuf buffer) {
        int slotIndex = buffer.m_130242_();
        ItemStack itemStack = inventory.m_8020_(slotIndex);
        inventory.m_6836_(slotIndex, itemStack);
        IItemHandler handler = (IItemHandler)itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(cap -> cap instanceof IItemHandlerModifiable).orElse(EmptyItemHandler.INSTANCE);
        return new UnsyncedToolContainerMenu(id, inventory, itemStack, handler, slotIndex);
    }

    public static InteractionResult tryOpenContainer(ItemStack stack, IToolStackView tool, Player player, EquipmentSlot slotType) {
        return UnsyncedToolContainerMenu.tryOpenContainer(stack, tool, tool.getDefinition(), player, slotType);
    }

    public static InteractionResult tryOpenContainer(ItemStack stack, @Nullable IToolStackView tool, ToolDefinition definition, Player player, EquipmentSlot slotType) {
        return UnsyncedToolContainerMenu.tryOpenContainer(stack, tool, definition, player, switch (slotType) {
            case EquipmentSlot.MAINHAND -> player.m_150109_().f_35977_;
            case EquipmentSlot.OFFHAND -> 40;
            default -> 36 + slotType.m_20749_();
        });
    }

    public static InteractionResult tryOpenContainer(ItemStack stack, @Nullable IToolStackView tool, ToolDefinition definition, Player player, int slotIndex) {
        IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(cap -> cap instanceof IItemHandlerModifiable).orElse(EmptyItemHandler.INSTANCE);
        if (handler.getSlots() <= 0 && !ModifierUtil.checkVolatileFlag((ItemStack)stack, (ResourceLocation)ToolInventoryCapability.CRAFTING_TABLE) && !ModifierUtil.checkVolatileFlag((ItemStack)stack, (ResourceLocation)ToolInventoryCapability.INVENTORY_CRAFTING)) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new UnsyncedToolContainerMenu(id, inventory, stack, handler, slotIndex), TooltipUtil.getDisplayName((ItemStack)stack, (IToolStackView)tool, (ToolDefinition)definition)), buf -> buf.m_130130_(slotIndex));
        }
        return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
    }
}

