/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.modules.ticex.models;

import com.mojang.math.Transformation;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.client.model.obj.ObjMaterialLibrary;
import net.minecraftforge.client.model.obj.ObjModel;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector4f;

public abstract class AbstractObjOverrideModel<MODEL extends AbstractObjOverrideModel<MODEL>>
implements IUnbakedGeometry<MODEL> {
    protected final ObjModel objModel;

    public AbstractObjOverrideModel(ObjModel objModel) {
        this.objModel = objModel;
    }

    public BakedModel bakeModifiedObjModel(ObjModel objModel, IGeometryBakingContext context, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ObjQuadWrapper quadWrapper) {
        TextureAtlasSprite particle = spriteGetter.apply(context.getMaterial("particle"));
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
        IModelBuilder builder = IModelBuilder.of((boolean)context.useAmbientOcclusion(), (boolean)context.useBlockLight(), (boolean)context.isGui3d(), (ItemTransforms)context.getTransforms(), (ItemOverrides)overrides, (TextureAtlasSprite)particle, (RenderTypeGroup)renderTypes);
        this.addQuads(objModel, context, builder, spriteGetter, modelState, quadWrapper);
        return builder.build();
    }

    protected void addQuads(ObjModel objModel, IGeometryBakingContext owner, IModelBuilder<?> modelBuilder, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ObjQuadWrapper quadWrapper) {
        objModel.parts.values().stream().filter(part -> owner.isComponentVisible(part.name(), true)).forEach(part -> this.addGroupQuads((ObjModel.ModelGroup)part, owner, modelBuilder, spriteGetter, modelState, quadWrapper));
    }

    protected void addGroupQuads(ObjModel.ModelGroup modelGroup, IGeometryBakingContext owner, IModelBuilder<?> modelBuilder, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ObjQuadWrapper quadWrapper) {
        Map parts = modelGroup.parts;
        this.addPartQuads((ObjModel.ModelObject)modelGroup, modelGroup, owner, modelBuilder, spriteGetter, modelState, quadWrapper);
        parts.forEach((key, partObject) -> this.addPartQuads((ObjModel.ModelObject)partObject, modelGroup, owner, modelBuilder, spriteGetter, modelState, quadWrapper));
    }

    public void addPartQuads(ObjModel.ModelObject partObject, ObjModel.ModelGroup modelGroup, IGeometryBakingContext owner, IModelBuilder<?> modelBuilder, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ObjQuadWrapper quadWrapper) {
        for (ObjModel.ModelMesh mesh : partObject.meshes) {
            ObjMaterialLibrary.Material mat = mesh.mat;
            if (mat == null) continue;
            TextureAtlasSprite texture = spriteGetter.apply(UnbakedGeometryHelper.resolveDirtyMaterial((String)mat.diffuseColorMap, (IGeometryBakingContext)owner));
            int tintIndex = mat.diffuseTintIndex;
            Vector4f colorTint = mat.diffuseColor;
            Transformation rootTransform = owner.getRootTransform();
            Transformation transform = rootTransform.isIdentity() ? modelTransform.m_6189_() : modelTransform.m_6189_().m_121096_(rootTransform);
            for (int[][] face : mesh.faces) {
                Pair quad = this.objModel.makeQuad(face, tintIndex, colorTint, mat.ambientColor, texture, transform);
                if (quad.getRight() == null) {
                    modelBuilder.addUnculledFace(quadWrapper.apply((BakedQuad)quad.getLeft(), modelGroup, partObject));
                    continue;
                }
                modelBuilder.addCulledFace((Direction)quad.getRight(), quadWrapper.apply((BakedQuad)quad.getLeft(), modelGroup, partObject));
            }
        }
    }

    public static interface ObjQuadWrapper {
        public BakedQuad apply(BakedQuad var1, ObjModel.ModelGroup var2, ObjModel.ModelObject var3);
    }
}

