/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.rendering;

import java.util.function.Predicate;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public abstract class PartPredicate<T> {
    protected final Predicate<T> predicate;

    public PartPredicate(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public abstract boolean testPredicate(T var1);

    public static class Modifier
    extends PartPredicate<ModifierId> {
        public Modifier(Predicate<ModifierId> predicate) {
            super(predicate);
        }

        public Modifier(ModifierId modifierId) {
            super((T modId) -> modId.equals((Object)modifierId));
        }

        @Override
        public boolean testPredicate(ModifierId value) {
            return this.predicate.test(value);
        }
    }

    public static class Material
    extends PartPredicate<MaterialVariantId> {
        public Material(Predicate<MaterialVariantId> predicate) {
            super(predicate);
        }

        public Material(MaterialVariantId variantId) {
            super(arg_0 -> ((MaterialVariantId)variantId).sameVariant(arg_0));
        }

        @Override
        public boolean testPredicate(MaterialVariantId value) {
            return this.predicate.test(value);
        }
    }
}

