/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.rendering.shader;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import moffy.ticex.client.rendering.PartPredicate;
import moffy.ticex.client.rendering.QuadRenderContext;
import moffy.ticex.client.rendering.shader.ShaderProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public abstract class ToolShaderMap<WRAPPER, PROVIDER extends ShaderProvider<WRAPPER>> {
    private final Map<MaterialVariantId, PROVIDER> cacheByMaterial = new HashMap<MaterialVariantId, PROVIDER>();
    private final Map<ModifierId, PROVIDER> cacheByModifier = new HashMap<ModifierId, PROVIDER>();
    protected Map<PROVIDER, PartPredicate<?>> shaderMap = new HashMap();

    @Nullable
    public PROVIDER getShaderProvider(ModifierId modifierId) {
        if (this.cacheByModifier.containsKey(modifierId)) {
            return (PROVIDER)((ShaderProvider)this.cacheByModifier.get(modifierId));
        }
        for (ShaderProvider provider : this.shaderMap.keySet()) {
            PartPredicate.Modifier modifierPredicate;
            PartPredicate<?> predicate = this.shaderMap.get(provider);
            if (!(predicate instanceof PartPredicate.Modifier) || !(modifierPredicate = (PartPredicate.Modifier)predicate).testPredicate(modifierId)) continue;
            this.cacheByModifier.put(modifierId, provider);
            return (PROVIDER)provider;
        }
        return null;
    }

    @Nullable
    public PROVIDER getShaderProvider(MaterialVariantId materialVariantId) {
        if (this.cacheByMaterial.containsKey(materialVariantId)) {
            return (PROVIDER)((ShaderProvider)this.cacheByMaterial.get(materialVariantId));
        }
        for (ShaderProvider provider : this.shaderMap.keySet()) {
            PartPredicate.Material materialPredicate;
            PartPredicate<?> predicate = this.shaderMap.get(provider);
            if (!(predicate instanceof PartPredicate.Material) || !(materialPredicate = (PartPredicate.Material)predicate).testPredicate(materialVariantId)) continue;
            this.cacheByMaterial.put(materialVariantId, provider);
            return (PROVIDER)provider;
        }
        return null;
    }

    public int size() {
        return this.shaderMap.size();
    }

    public void clearCache() {
        this.cacheByMaterial.clear();
        this.cacheByModifier.clear();
    }

    public void addShader(PartPredicate<?> predicate, PROVIDER provider) {
        this.shaderMap.put(provider, predicate);
        this.clearCache();
    }

    public void addShader(MaterialVariantId materialVariantId, PROVIDER provider) {
        this.addShader(new PartPredicate.Material(materialVariantId), provider);
    }

    public void addShader(ModifierId modifierId, PROVIDER provider) {
        this.addShader(new PartPredicate.Modifier(modifierId), provider);
    }

    public static class Armor
    extends ToolShaderMap<QuadRenderContext.ArmorPartRenderContext, ShaderProvider.Armor> {
    }

    public static class Tool
    extends ToolShaderMap<QuadRenderContext.ToolQuadRenderContext, ShaderProvider.Tool> {
        public boolean isToolTarget(IToolStackView tool) {
            ShaderProvider.Tool shaderProvider;
            for (MaterialVariant variant : tool.getMaterials().getList()) {
                shaderProvider = (ShaderProvider.Tool)this.getShaderProvider((MaterialVariantId)variant.getId());
                if (shaderProvider == null) continue;
                return true;
            }
            for (ModifierEntry modifierEntry : tool.getModifierList()) {
                shaderProvider = (ShaderProvider.Tool)this.getShaderProvider(modifierEntry.getId());
                if (shaderProvider == null) continue;
                return true;
            }
            return false;
        }
    }
}

