/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.rendering.ticex;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import moffy.ticex.TicEXConfig;
import moffy.ticex.client.rendering.shader.ShaderProvider;
import moffy.ticex.client.rendering.shader.TicEXRenderTasks;
import moffy.ticex.client.rendering.shader.ToolShaderMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public class TicEXRenders {
    public static final Map<Item, Function<BakedModel, BakedModel>> CUSTOM_MODELS = new HashMap<Item, Function<BakedModel, BakedModel>>();
    public static final ToolShaderMap.Tool TOOL_SHADERS = new ToolShaderMap.Tool();
    public static final ToolShaderMap.Armor ARMOR_SHADERS = new ToolShaderMap.Armor();

    public static boolean shouldRenderWithShader(ItemStack stack) {
        return !stack.m_41619_() && (Boolean)TicEXConfig.USE_SHADER.get() != false && !CUSTOM_MODELS.containsKey(stack.m_41720_());
    }

    public static Map<MaterialVariantId, ShaderProvider.Tool> collectMaterialShaderProviders(ItemStack itemStack) {
        HashMap<MaterialVariantId, ShaderProvider.Tool> shaderProviders = new HashMap<MaterialVariantId, ShaderProvider.Tool>();
        Item item = itemStack.m_41720_();
        if (item instanceof IModifiable) {
            ToolStack tool = ToolStack.from((ItemStack)itemStack);
            if (!TOOL_SHADERS.isToolTarget((IToolStackView)tool)) {
                return Collections.emptyMap();
            }
            for (MaterialVariant material : tool.getMaterials()) {
                ShaderProvider.Tool provider = (ShaderProvider.Tool)TOOL_SHADERS.getShaderProvider((MaterialVariantId)material.getId());
                if (provider == null) continue;
                shaderProviders.put((MaterialVariantId)material.getId(), provider);
            }
        } else if (item instanceof IToolPart) {
            IToolPart toolPart = (IToolPart)item;
            MaterialVariantId material = toolPart.getMaterial(itemStack);
            ShaderProvider.Tool provider = (ShaderProvider.Tool)TOOL_SHADERS.getShaderProvider(material);
            if (provider == null) {
                return Collections.emptyMap();
            }
            shaderProviders.put(material, provider);
        } else {
            return Collections.emptyMap();
        }
        return shaderProviders;
    }

    public static Map<ModifierId, ShaderProvider.Tool> collectModifierShaderProviders(ItemStack itemStack) {
        HashMap<ModifierId, ShaderProvider.Tool> shaderProviders = new HashMap<ModifierId, ShaderProvider.Tool>();
        Item item = itemStack.m_41720_();
        if (item instanceof IModifiable) {
            ToolStack tool = ToolStack.from((ItemStack)itemStack);
            for (ModifierEntry modifierEntry : tool.getModifierList()) {
                ModifierId modifierId = modifierEntry.getId();
                ShaderProvider.Tool shaderProvider = (ShaderProvider.Tool)TOOL_SHADERS.getShaderProvider(modifierId);
                if (shaderProvider == null) continue;
                shaderProviders.put(modifierId, shaderProvider);
            }
        }
        return shaderProviders;
    }

    public static void renderQuadsTasks(ItemStack pItemStack, PoseStack pPoseStack, BakedModel pModel, ItemDisplayContext pDisplayContext, boolean pLeftHand, RenderTaskFunction renderTaskFunction) {
        ArrayList<TicEXRenderTasks.RenderTask> renderQueue = new ArrayList<TicEXRenderTasks.RenderTask>();
        pPoseStack.m_85836_();
        pModel = ForgeHooksClient.handleCameraTransforms((PoseStack)pPoseStack, (BakedModel)pModel, (ItemDisplayContext)pDisplayContext, (boolean)pLeftHand);
        pPoseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        for (BakedModel model : pModel.getRenderPasses(pItemStack, true)) {
            for (RenderType renderType : model.getRenderTypes(pItemStack, true)) {
                RandomSource randomSource = RandomSource.m_216327_();
                for (Direction direction : Direction.values()) {
                    randomSource.m_188584_(42L);
                    renderQueue.addAll(renderTaskFunction.getRenderTasks(renderType, model.m_213637_(null, direction, randomSource)));
                }
                randomSource.m_188584_(42L);
                renderQueue.addAll(renderTaskFunction.getRenderTasks(renderType, model.m_213637_(null, null, randomSource)));
            }
        }
        renderQueue.sort(Comparator.comparingInt(task -> task.getPhase().getIndex()));
        for (TicEXRenderTasks.RenderTask task2 : renderQueue) {
            task2.applyRenderTask();
        }
        pPoseStack.m_85849_();
    }

    @FunctionalInterface
    public static interface RenderTaskFunction {
        public List<TicEXRenderTasks.RenderTask> getRenderTasks(RenderType var1, List<BakedQuad> var2);
    }
}

