/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.client.rendering.ticex;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import moffy.ticex.client.rendering.ItemRenderContext;
import moffy.ticex.client.rendering.QuadRenderContext;
import moffy.ticex.client.rendering.shader.ShaderProvider;
import moffy.ticex.client.rendering.shader.ShaderToolQuad;
import moffy.ticex.client.rendering.shader.TicEXRenderTasks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TicEXToolRenders {
    public static List<TicEXRenderTasks.RenderTask> prepareRenderTasks(RenderType renderType, List<BakedQuad> pQuads, ItemRenderContext itemRenderContext, @Nullable ToolStack tool, List<ShaderProvider.Tool> seenList) {
        ArrayList<TicEXRenderTasks.RenderTask> renderTasks = new ArrayList<TicEXRenderTasks.RenderTask>();
        ItemColors itemColors = Minecraft.m_91087_().getItemColors();
        ItemStack pItemStack = itemRenderContext.itemStack();
        ArrayList<QuadRenderContext.ToolQuadRenderContext> renderContexts = new ArrayList<QuadRenderContext.ToolQuadRenderContext>();
        for (BakedQuad bakedQuad : pQuads) {
            int overridedColor = -1;
            if (!pItemStack.m_41619_() && bakedQuad.m_111304_()) {
                overridedColor = itemColors.m_92676_(pItemStack, bakedQuad.m_111305_());
            }
            float r = overridedColor != -1 ? (float)(overridedColor >> 16 & 0xFF) / 255.0f : 1.0f;
            float g = overridedColor != -1 ? (float)(overridedColor >> 8 & 0xFF) / 255.0f : 1.0f;
            float b = overridedColor != -1 ? (float)(overridedColor & 0xFF) / 255.0f : 1.0f;
            QuadRenderContext.ToolQuadRenderContext context = new QuadRenderContext.ToolQuadRenderContext(renderType, bakedQuad, r, g, b, 1.0f, pItemStack, itemRenderContext.displayContext(), itemRenderContext.leftHand(), itemRenderContext.poseStack(), itemRenderContext.bufferSource(), itemRenderContext.combinedLight(), itemRenderContext.combinedOverlay());
            renderContexts.add(context);
        }
        List<ToolRenderBatch> renderBatches = TicEXToolRenders.processRenderBatches(renderContexts, tool, seenList);
        for (ToolRenderBatch renderBatch : renderBatches) {
            if (renderBatch.shaderProvider == null) {
                renderTasks.add(new TicEXRenderTasks.NakedBatchTask(renderBatch, itemRenderContext, renderType));
                continue;
            }
            renderTasks.add(new TicEXRenderTasks.RenderBatchTask(renderBatch, itemRenderContext));
        }
        return renderTasks;
    }

    public static List<ToolRenderBatch> processRenderBatches(List<QuadRenderContext.ToolQuadRenderContext> contexts, @Nullable ToolStack toolStack, List<ShaderProvider.Tool> seenList) {
        EnumMap<RenderPhase, ShaderRenderTasksMap> phaseTasksMap = new EnumMap<RenderPhase, ShaderRenderTasksMap>(RenderPhase.class);
        for (QuadRenderContext.ToolQuadRenderContext context : contexts) {
            ShaderProvider.Tool shaderProvider2;
            BakedQuad quad = context.quad();
            if (quad instanceof ShaderToolQuad) {
                ShaderToolQuad shaderToolQuad = (ShaderToolQuad)quad;
                shaderProvider2 = shaderToolQuad.getShaderProvider();
            } else {
                shaderProvider2 = null;
            }
            ArrayList<TicEXRenderTasks.RenderTask> renderTasks2 = new ArrayList<TicEXRenderTasks.RenderTask>(TicEXToolRenders.getMaterialQuadRenderTasks(context, seenList));
            if (toolStack != null && context.itemStack().m_41720_() instanceof IModifiable) {
                renderTasks2.addAll(TicEXToolRenders.getModifierQuadRenderTasks(context, toolStack, seenList));
            }
            for (TicEXRenderTasks.RenderTask renderTask : renderTasks2) {
                RenderPhase phase = renderTask.getPhase();
                phaseTasksMap.computeIfAbsent(phase, renderPhase -> new ShaderRenderTasksMap()).computeIfAbsent(shaderProvider2, sp -> new ArrayList()).add(renderTask);
            }
        }
        ArrayList<ToolRenderBatch> batches = new ArrayList<ToolRenderBatch>();
        for (RenderPhase renderPhase2 : phaseTasksMap.keySet()) {
            ShaderRenderTasksMap shaderRenderTasksMap = (ShaderRenderTasksMap)phaseTasksMap.get((Object)renderPhase2);
            shaderRenderTasksMap.forEach((shaderProvider, renderTasks) -> {
                ToolRenderBatch renderBatch = new ToolRenderBatch((ShaderProvider.Tool)shaderProvider, renderPhase2, (List<TicEXRenderTasks.RenderTask>)renderTasks);
                batches.add(renderBatch);
            });
        }
        return batches;
    }

    public static List<TicEXRenderTasks.RenderTask> getMaterialQuadRenderTasks(QuadRenderContext.ToolQuadRenderContext context, List<ShaderProvider.Tool> seenList) {
        ArrayList<TicEXRenderTasks.RenderTask> renderTasks = new ArrayList<TicEXRenderTasks.RenderTask>();
        BakedQuad bakedQuad = context.quad();
        if (!(bakedQuad instanceof ShaderToolQuad.Material)) {
            return List.of(new TicEXRenderTasks.NakedRenderTask(RenderPhase.NORMAL_MATERIAL, context));
        }
        ShaderToolQuad.Material shaderToolQuad = (ShaderToolQuad.Material)bakedQuad;
        ShaderProvider.Tool provider = shaderToolQuad.getShaderProvider();
        if (provider == null) {
            return List.of(new TicEXRenderTasks.NakedRenderTask(RenderPhase.NORMAL_MATERIAL, context));
        }
        if (!seenList.contains(provider)) {
            renderTasks.add(new TicEXRenderTasks.InstantRenderTask(RenderPhase.UNDERLAY, () -> {
                provider.preRenderMaterial(context.itemStack(), shaderToolQuad.getMaterialId());
                provider.renderQuadUnderlay(context);
            }));
            seenList.add(provider);
        }
        renderTasks.add(new TicEXRenderTasks.InstantRenderTask(RenderPhase.OVERLAY_MATERIAL, () -> {
            provider.preRenderMaterial(context.itemStack(), shaderToolQuad.getMaterialId());
            provider.renderQuadOverlay(context);
        }));
        return renderTasks;
    }

    public static List<TicEXRenderTasks.RenderTask> getModifierQuadRenderTasks(QuadRenderContext.ToolQuadRenderContext context, ToolStack tool, List<ShaderProvider.Tool> seenList) {
        ArrayList<TicEXRenderTasks.RenderTask> renderTasks = new ArrayList<TicEXRenderTasks.RenderTask>();
        BakedQuad bakedQuad = context.quad();
        if (!(bakedQuad instanceof ShaderToolQuad.Modifier)) {
            return List.of();
        }
        ShaderToolQuad.Modifier shaderToolQuad = (ShaderToolQuad.Modifier)bakedQuad;
        ShaderProvider.Tool provider = shaderToolQuad.getShaderProvider();
        if (provider == null) {
            return List.of(new TicEXRenderTasks.NakedRenderTask(RenderPhase.NORMAL_MODIFIER, context));
        }
        if (!seenList.contains(provider)) {
            renderTasks.add(new TicEXRenderTasks.InstantRenderTask(RenderPhase.UNDERLAY, () -> {
                provider.preRenderModifier(tool, shaderToolQuad.getModifierId());
                provider.renderQuadUnderlay(context);
            }));
            seenList.add(provider);
        }
        renderTasks.add(new TicEXRenderTasks.InstantRenderTask(RenderPhase.OVERLAY_MODIFIER, () -> {
            provider.preRenderModifier(tool, shaderToolQuad.getModifierId());
            provider.renderQuadOverlay(context);
        }));
        return renderTasks;
    }

    public record ToolRenderBatch(@Nullable ShaderProvider.Tool shaderProvider, RenderPhase renderPhase, List<TicEXRenderTasks.RenderTask> renderTasks) {
    }

    public static enum RenderPhase {
        UNDERLAY(0),
        OVERLAY_MATERIAL(1),
        NORMAL_MATERIAL(2),
        NORMAL_MODIFIER(3),
        OVERLAY_MODIFIER(4);

        private final int index;

        private RenderPhase(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static final class ShaderRenderTasksMap
    extends HashMap<ShaderProvider.Tool, List<TicEXRenderTasks.RenderTask>> {
    }
}

