/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.datagen.curios;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import moffy.ticex.lib.utils.TicEXCuriosUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosDataProvider;

public class TicEXCuriosDataProvider
extends CuriosDataProvider {
    public TicEXCuriosDataProvider(PackOutput output, ExistingFileHelper fileHelper, CompletableFuture<HolderLookup.Provider> registries) {
        super("ticex", output, fileHelper, registries);
    }

    public void generate(HolderLookup.Provider provider, ExistingFileHelper existingFileHelper) {
        if (ModList.get().isLoaded("curios")) {
            this.generateCuriosSlots();
        }
    }

    public void generateCuriosSlots() {
        ArrayList<String> incomparableSlots = new ArrayList<String>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            String id = TicEXCuriosUtils.resolveEquipmentSlot(slot);
            this.createSlot(id).size(1).icon(new ResourceLocation("ticex", "slot/" + slot.m_20751_())).addValidator(new ResourceLocation("ticex", "incomparable"));
            incomparableSlots.add(id);
        }
        this.createEntities("entities").addPlayer().addEntities(new EntityType[]{EntityType.f_20529_}).addSlots((String[])incomparableSlots.toArray(String[]::new));
    }
}

