/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.datagen.fluid;

import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.fluid.UnplaceableFluid;
import slimeknights.mantle.fluid.texture.AbstractFluidTextureProvider;
import slimeknights.mantle.fluid.texture.FluidTexture;
import slimeknights.mantle.registration.object.FluidObject;

public class FluidTextureProvider
extends AbstractFluidTextureProvider {
    private static final int MOLTEN_LENGTH = "molten_".length();

    public FluidTextureProvider(PackOutput packOutput) {
        super(packOutput, "ticex");
    }

    public String m_6055_() {
        return "TiCEX fluid textures";
    }

    public void addTextures() {
        this.molten((FluidObject<?>)TicEXRegistry.MOLTEN_INFINITY);
        this.molten((FluidObject<?>)TicEXRegistry.MOLTEN_NEUTRON);
        this.molten((FluidObject<?>)TicEXRegistry.MOLTEN_CRYSTAL_MATRIX);
        this.molten((FluidObject<?>)TicEXRegistry.MOLTEN_ETHERIC);
        this.molten(TicEXRegistry.MOLTEN_RECONSTRUCTION_CORE);
        int i = 0;
        for (FluidObject<UnplaceableFluid> fuel : TicEXRegistry.RF_FURNACE_FUELS) {
            this.fuels(fuel).color(i++ * 789516);
        }
    }

    private FluidTexture.Builder fuels(FluidObject<?> fluid) {
        return this.texture(fluid.getType()).textures(new ResourceLocation("ticex", "fluid/rf_furnace_fuels/"), false, false);
    }

    private FluidTexture.Builder named(FluidObject<?> fluid, String name) {
        return this.texture(fluid).textures(new ResourceLocation("ticex", "fluid/" + name + "/"), false, false);
    }

    private FluidTexture.Builder molten(FluidObject<?> fluid) {
        return this.named(fluid, "molten/" + FluidTextureProvider.withoutMolten(fluid));
    }

    public static String withoutMolten(FluidObject<?> fluid) {
        return fluid.getId().m_135815_().substring(MOLTEN_LENGTH);
    }
}

