/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.datagen.general.recipes;

import java.util.function.Consumer;
import moffy.ticex.datagen.general.recipes.ITicEXRecipeHelper;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.recipe.condition.TagFilledCondition;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.data.recipe.SmelteryRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public interface ITicEXSmelteryRecipeHelper
extends ITicEXRecipeHelper {
    default public SmelteryRecipeBuilder metal(Consumer<FinishedRecipe> consumer, TagKey<Fluid> fluid, ResourceLocation name) {
        return SmelteryRecipeBuilder.fluid(consumer, (ResourceLocation)name, fluid).castingFolder("smeltery/casting/metal").meltingFolder("smeltery/melting/metal");
    }

    default public void metalIngotOptional(Consumer<FinishedRecipe> consumer, TagKey<Fluid> fluidTag, TagKey<Item> storageTag, int temperature, ResourceLocation name) {
        SmelteryRecipeBuilder metal = this.metal(consumer, fluidTag, new ResourceLocation(name.m_135827_(), name.m_135815_().replace("molten_", "")));
        metal.optional().oreRate(IMeltingContainer.OreRateType.METAL).temperature(temperature).baseUnit(90).damageUnit(10).melting(9.0f, "block", "storage_blocks", 3.0f, false, false).meltingCasting(1.0f, TinkerSmeltery.ingotCast, 1.0f, false);
        Consumer wrapped = this.withCondition(consumer, new ICondition[]{new TagFilledCondition(storageTag)});
        ItemCastingRecipeBuilder.basinRecipe((ItemOutput)ItemOutput.fromTag(storageTag)).setFluid(fluidTag, 810).setCoolingTime(temperature, 810).save(wrapped, this.location("smeltery/casting/metal/" + name.m_135815_() + "/block"));
    }
}

