/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.datagen.general.recipes.apotheosis;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingRecipe;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;

public class ApotheosisEnchantingRecipeBuilder
extends AbstractRecipeBuilder<ApotheosisEnchantingRecipeBuilder> {
    private Ingredient input = Ingredient.f_43901_;
    private EnchantStats requirements = new EnchantStats();
    private EnchantStats maxRequirements = new EnchantStats();
    private final ItemStack itemOutput;

    public ApotheosisEnchantingRecipeBuilder setInput(Item item) {
        return this.setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ApotheosisEnchantingRecipeBuilder setInput(ItemStack itemStack) {
        return this.setInput(Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}));
    }

    public ApotheosisEnchantingRecipeBuilder setInput(ItemLike itemLike) {
        return this.setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
    }

    public ApotheosisEnchantingRecipeBuilder setInput(Ingredient ingredient) {
        this.input = ingredient;
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setMaxEterna(float maxEterna) {
        this.requirements.maxEterna = Float.valueOf(maxEterna);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setEterna(float eterna) {
        this.requirements.eterna = Float.valueOf(eterna);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setQuanta(float quanta) {
        this.requirements.quanta = Float.valueOf(quanta);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setArcana(float arcana) {
        this.requirements.arcana = Float.valueOf(arcana);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setRectification(float rectification) {
        this.requirements.rectification = Float.valueOf(rectification);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setClues(int clues) {
        this.requirements.clues = clues;
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setMaxEternaMax(float maxEterna) {
        this.maxRequirements.maxEterna = Float.valueOf(maxEterna);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setEternaMax(float eterna) {
        this.maxRequirements.eterna = Float.valueOf(eterna);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setQuantaMax(float quanta) {
        this.maxRequirements.quanta = Float.valueOf(quanta);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setArcanaMax(float arcana) {
        this.maxRequirements.arcana = Float.valueOf(arcana);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setRectificationMax(float rectification) {
        this.maxRequirements.rectification = Float.valueOf(rectification);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setCluesMax(int clues) {
        this.maxRequirements.clues = clues;
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setRequirement(float maxEterna, float eterna, float quanta, float arcana, float rectification, int clues) {
        this.requirements = new EnchantStats(Float.valueOf(maxEterna), Float.valueOf(eterna), Float.valueOf(quanta), Float.valueOf(arcana), Float.valueOf(rectification), clues);
        return this;
    }

    public ApotheosisEnchantingRecipeBuilder setMaxRequirement(float maxEterna, float eterna, float quanta, float arcana, float rectification, int clues) {
        this.maxRequirements = new EnchantStats(Float.valueOf(maxEterna), Float.valueOf(eterna), Float.valueOf(quanta), Float.valueOf(arcana), Float.valueOf(rectification), clues);
        return this;
    }

    public void save(@NotNull Consumer<FinishedRecipe> consumer) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)this.itemOutput.m_41720_());
        if (resourceLocation == null) {
            throw new RuntimeException("Could not find item " + this.itemOutput.m_41720_() + " in item registry");
        }
        this.save(consumer, resourceLocation);
    }

    public void save(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        consumer.accept((FinishedRecipe)new EnchantingResult(id, this.buildOptionalAdvancement(id, "enchanting")));
    }

    private ApotheosisEnchantingRecipeBuilder(ItemStack itemOutput) {
        this.itemOutput = itemOutput;
    }

    public static ApotheosisEnchantingRecipeBuilder builder(ItemLike item) {
        return ApotheosisEnchantingRecipeBuilder.builder(item, 1);
    }

    public static ApotheosisEnchantingRecipeBuilder builder(ItemLike item, int count) {
        return ApotheosisEnchantingRecipeBuilder.builder(new ItemStack(item, count));
    }

    public static ApotheosisEnchantingRecipeBuilder builder(ItemStack item) {
        return new ApotheosisEnchantingRecipeBuilder(item);
    }

    private static final class EnchantStats {
        Float maxEterna;
        Float eterna;
        Float quanta;
        Float arcana;
        Float rectification;
        Integer clues;

        public EnchantStats(Float maxEterna, Float eterna, Float quanta, Float arcana, Float rectification, Integer clues) {
            this.maxEterna = maxEterna;
            this.eterna = eterna;
            this.quanta = quanta;
            this.arcana = arcana;
            this.rectification = rectification;
            this.clues = clues;
        }

        public EnchantStats() {
            this.maxEterna = null;
            this.eterna = null;
            this.quanta = null;
            this.arcana = null;
            this.rectification = null;
            this.clues = null;
        }

        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            if (this.maxEterna != null) {
                json.addProperty("maxEterna", (Number)this.maxEterna);
            }
            if (this.eterna != null) {
                json.addProperty("eterna", (Number)this.eterna);
            }
            if (this.quanta != null) {
                json.addProperty("quanta", (Number)this.quanta);
            }
            if (this.arcana != null) {
                json.addProperty("arcana", (Number)this.arcana);
            }
            if (this.rectification != null) {
                json.addProperty("rectification", (Number)this.rectification);
            }
            if (this.clues != null) {
                json.addProperty("clues", (Number)this.clues);
            }
            return json;
        }
    }

    private class EnchantingResult<R extends Recipe<?>>
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public EnchantingResult(ResourceLocation resourceLocation, ResourceLocation advancement) {
            super((AbstractRecipeBuilder)ApotheosisEnchantingRecipeBuilder.this, resourceLocation, advancement);
        }

        public static JsonObject writeItemStack(ItemStack stack) {
            JsonObject json = new JsonObject();
            ResourceLocation resource = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            if (resource == null) {
                throw new RuntimeException(String.format("Item %s not found", stack.m_41720_().m_5524_()));
            }
            json.addProperty("item", resource.toString());
            if (stack.m_41613_() != 1) {
                json.addProperty("count", (Number)stack.m_41613_());
            }
            if (stack.m_41782_()) {
                Objects.requireNonNull(stack.m_41783_());
                json.addProperty("nbt", stack.m_41783_().toString());
            }
            return json;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", ApotheosisEnchantingRecipeBuilder.this.input.m_43942_());
            json.add("requirements", ApotheosisEnchantingRecipeBuilder.this.requirements.toJson());
            json.add("max_requirements", ApotheosisEnchantingRecipeBuilder.this.maxRequirements.toJson());
            json.add("result", (JsonElement)EnchantingResult.writeItemStack(ApotheosisEnchantingRecipeBuilder.this.itemOutput));
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return EnchantingRecipe.SERIALIZER;
        }
    }
}

