/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.datagen.general.recipes.draconicevolution;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.datagen.FusionRecipeBuilder;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import moffy.ticex.datagen.general.recipes.ITicEXSmelteryRecipeHelper;
import moffy.ticex.lib.TicEXMaterials;
import moffy.ticex.lib.TicEXTags;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.library.tools.SlotType;

public class DERecipeProvider
implements ITicEXSmelteryRecipeHelper,
ISmelteryRecipeHelper {
    public void buildRecipes(Consumer<FinishedRecipe> pWriter) {
        Consumer topConsumer = this.withCondition(pWriter, new ICondition[]{this.modsAvailable(new ResourceLocation("ticex", "draconicevolution_compat"))});
        if (TicEXRegistry.INJECT_MODIFIER != null) {
            ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)TicEXRegistry.INJECT_MODIFIER.getId()).allowCrystal()).checkTraitLevel()).addInput((ItemLike)TicEXRegistry.INJECT_CORE.get()).setMaxLevel(1)).setTools(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(TinkerTags.Items.MELEE), new Ingredient.TagValue(TinkerTags.Items.MODIFIABLE))))).save(topConsumer, this.prefix((IdAwareObject)TicEXRegistry.INJECT_MODIFIER, "tools/modifiers/slotless/"));
        }
        if (TicEXRegistry.EVOLVED_MODIFIER != null) {
            this.evolvedModifier(topConsumer, "draconium_", (Item)TicEXRegistry.DRACONIUM_EVOLVED_CORE.get(), 1);
            this.evolvedModifier(topConsumer, "wyvern_", (Item)TicEXRegistry.WYVERN_EVOLVED_CORE.get(), 2);
            this.evolvedModifier(topConsumer, "draconic_", (Item)TicEXRegistry.DRACONIC_EVOLVED_CORE.get(), 3);
            this.evolvedModifier(topConsumer, "chaotic_", (Item)TicEXRegistry.CHAOTIC_EVOLVED_CORE.get(), 4);
        }
        this.buildCoresFusionRecipes(topConsumer);
        this.buildMaterialRecipes(topConsumer);
        this.buildSmelteryRecipes(topConsumer);
    }

    public void buildCoresFusionRecipes(Consumer<FinishedRecipe> topConsumer) {
        if (TicEXRegistry.DRACONIUM_EVOLVED_CORE != null) {
            FusionRecipeBuilder.builder((ItemLike)((ItemLike)TicEXRegistry.DRACONIUM_EVOLVED_CORE.get()), (int)1, (ResourceLocation)this.prefix(TicEXRegistry.DRACONIUM_EVOLVED_CORE, "items/cores/")).techLevel(TechLevel.DRACONIUM).energy(16000000L).catalyst(new ItemLike[]{(ItemLike)TicEXRegistry.RECONSTRUCTION_CORE.get()}).ingredient((Supplier)DEContent.CORE_DRACONIUM).ingredient(new ItemLike[]{Items.f_42735_}).ingredient(new ItemLike[]{Items.f_42436_}).ingredient(new ItemLike[]{Items.f_42436_}).ingredient(new ItemLike[]{Items.f_42545_}).ingredient(new ItemLike[]{Items.f_42545_}).ingredient(Tags.Items.INGOTS_NETHERITE).ingredient(Tags.Items.INGOTS_NETHERITE).ingredient(new ItemLike[]{Items.f_42748_}).ingredient(new ItemLike[]{Items.f_42748_}).ingredient((Supplier)DEContent.MODULE_CORE).build(topConsumer);
        }
        if (TicEXRegistry.WYVERN_EVOLVED_CORE != null) {
            FusionRecipeBuilder.builder((ItemLike)((ItemLike)TicEXRegistry.WYVERN_EVOLVED_CORE.get()), (int)1, (ResourceLocation)this.prefix(TicEXRegistry.WYVERN_EVOLVED_CORE, "items/cores/")).techLevel(TechLevel.WYVERN).energy(64000000L).catalyst(new ItemLike[]{(ItemLike)TicEXRegistry.RECONSTRUCTION_CORE.get()}).ingredient((Supplier)DEContent.CORE_WYVERN).ingredient((Supplier)DEContent.CORE_DRACONIUM).ingredient((Supplier)DEContent.CORE_DRACONIUM).ingredient(new ItemLike[]{Items.f_42686_}).ingredient(new ItemLike[]{Items.f_42686_}).ingredient((Supplier)DEContent.SWORD_WYVERN).ingredient((Supplier)DEContent.SHOVEL_WYVERN).ingredient((Supplier)DEContent.PICKAXE_WYVERN).ingredient((Supplier)DEContent.MODULE_CORE).build(topConsumer);
        }
        if (TicEXRegistry.DRACONIC_EVOLVED_CORE != null) {
            FusionRecipeBuilder.builder((ItemLike)((ItemLike)TicEXRegistry.DRACONIC_EVOLVED_CORE.get()), (int)1, (ResourceLocation)this.prefix(TicEXRegistry.DRACONIC_EVOLVED_CORE, "items/cores/")).techLevel(TechLevel.DRACONIC).energy(256000000L).catalyst(new ItemLike[]{(ItemLike)TicEXRegistry.RECONSTRUCTION_CORE.get()}).ingredient((Supplier)DEContent.CORE_WYVERN).ingredient((Supplier)DEContent.CORE_AWAKENED).ingredient(new ItemLike[]{Items.f_42686_}).ingredient(new ItemLike[]{Items.f_42686_}).ingredient(Tags.Items.STORAGE_BLOCKS_NETHERITE).ingredient(Tags.Items.STORAGE_BLOCKS_NETHERITE).ingredient((Supplier)DEContent.CORE_AWAKENED).ingredient((Supplier)DEContent.SWORD_DRACONIC).ingredient((Supplier)DEContent.SHOVEL_DRACONIC).ingredient((Supplier)DEContent.PICKAXE_DRACONIC).ingredient((Supplier)DEContent.MODULE_CORE).build(topConsumer);
        }
        if (TicEXRegistry.CHAOTIC_EVOLVED_CORE != null) {
            FusionRecipeBuilder.builder((ItemLike)((ItemLike)TicEXRegistry.CHAOTIC_EVOLVED_CORE.get()), (int)1, (ResourceLocation)this.prefix(TicEXRegistry.CHAOTIC_EVOLVED_CORE, "items/cores/")).techLevel(TechLevel.CHAOTIC).energy(1024000000L).catalyst(new ItemLike[]{(ItemLike)TicEXRegistry.RECONSTRUCTION_CORE.get()}).ingredient((Supplier)DEContent.CORE_WYVERN).ingredient((Supplier)DEContent.CORE_WYVERN).ingredient((Supplier)DEContent.CORE_AWAKENED).ingredient((Supplier)DEContent.CORE_AWAKENED).ingredient((Supplier)DEContent.CORE_CHAOTIC).ingredient(new ItemLike[]{Items.f_42104_}).ingredient(new ItemLike[]{Items.f_42104_}).ingredient((Supplier)DEContent.SWORD_CHAOTIC).ingredient((Supplier)DEContent.SHOVEL_CHAOTIC).ingredient((Supplier)DEContent.PICKAXE_CHAOTIC).ingredient((Supplier)DEContent.MODULE_CORE).build(topConsumer);
        }
        if (TicEXRegistry.INJECT_CORE != null) {
            FusionRecipeBuilder.builder((ItemLike)((ItemLike)TicEXRegistry.INJECT_CORE.get()), (int)1, (ResourceLocation)this.prefix(TicEXRegistry.INJECT_CORE, "items/cores/")).techLevel(TechLevel.CHAOTIC).energy(256000000L).catalyst(new ItemLike[]{(ItemLike)TicEXRegistry.RECONSTRUCTION_CORE.get()}).ingredient((Supplier)DEContent.CORE_DRACONIUM).ingredient((Supplier)DEContent.CORE_WYVERN).ingredient((Supplier)DEContent.CORE_AWAKENED).ingredient((Supplier)DEContent.CORE_CHAOTIC).build(topConsumer);
        }
    }

    public void buildMaterialRecipes(Consumer<FinishedRecipe> topConsumer) {
        MaterialRecipeBuilder.materialRecipe((MaterialVariantId)TicEXMaterials.DRACONIUM).setNeeded(1).setValue(1).setIngredient((ItemLike)TicEXRegistry.DRACONIUM_CRYSTAL.get()).save(topConsumer, this.prefix((ResourceLocation)TicEXMaterials.DRACONIUM, "tools/materials/chaotic/"));
        MaterialRecipeBuilder.materialRecipe((MaterialVariantId)TicEXMaterials.WYVERN).setNeeded(1).setValue(1).setIngredient((ItemLike)TicEXRegistry.WYVERN_CRYSTAL.get()).save(topConsumer, this.prefix((ResourceLocation)TicEXMaterials.WYVERN, "tools/materials/wyvern/"));
        MaterialRecipeBuilder.materialRecipe((MaterialVariantId)TicEXMaterials.DRACONIC).setNeeded(1).setValue(1).setIngredient((ItemLike)TicEXRegistry.DRACONIC_CRYSTAL.get()).save(topConsumer, this.prefix((ResourceLocation)TicEXMaterials.DRACONIC, "tools/materials/draconic/"));
        MaterialRecipeBuilder.materialRecipe((MaterialVariantId)TicEXMaterials.CHAOTIC).setNeeded(1).setValue(1).setIngredient((ItemLike)TicEXRegistry.CHAOTIC_CRYSTAL.get()).save(topConsumer, this.prefix((ResourceLocation)TicEXMaterials.CHAOTIC, "tools/materials/chaotic/"));
    }

    public void buildSmelteryRecipes(Consumer<FinishedRecipe> topConsumer) {
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)TicEXRegistry.DRACONIUM_CRYSTAL.get())).setFluid(TicEXTags.Fluids.RECONSTRUCTION_CORE, 500).setCoolingTime(83).setCast((ItemLike)DEContent.CORE_DRACONIUM.get(), true).save(topConsumer, this.prefix(TicEXRegistry.DRACONIUM_CRYSTAL, "smeltery/casting/"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)TicEXRegistry.WYVERN_CRYSTAL.get())).setFluid(TicEXTags.Fluids.RECONSTRUCTION_CORE, 500).setCoolingTime(83).setCast((ItemLike)DEContent.CORE_WYVERN.get(), true).save(topConsumer, this.prefix(TicEXRegistry.WYVERN_CRYSTAL, "smeltery/casting/"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)TicEXRegistry.DRACONIC_CRYSTAL.get())).setFluid(TicEXTags.Fluids.RECONSTRUCTION_CORE, 500).setCoolingTime(83).setCast((ItemLike)DEContent.CORE_AWAKENED.get(), true).save(topConsumer, this.prefix(TicEXRegistry.DRACONIC_CRYSTAL, "smeltery/casting/"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)TicEXRegistry.CHAOTIC_CRYSTAL.get())).setFluid(TicEXTags.Fluids.RECONSTRUCTION_CORE, 500).setCoolingTime(83).setCast((ItemLike)DEContent.CORE_CHAOTIC.get(), true).save(topConsumer, this.prefix(TicEXRegistry.CHAOTIC_CRYSTAL, "smeltery/casting/"));
    }

    public void evolvedModifier(Consumer<FinishedRecipe> consumer, String prefix, Item core, int level) {
        ResourceLocation rl = TicEXRegistry.EVOLVED_MODIFIER.getId().m_246208_(prefix);
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(TicEXRegistry.EVOLVED_MODIFIER).setTools(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(TinkerTags.Items.MELEE_WEAPON), new Ingredient.TagValue(TinkerTags.Items.HARVEST), new Ingredient.TagValue(TinkerTags.Items.RANGED))))).addInput((ItemLike)core).setSlots(SlotType.ABILITY, 1)).exactLevel(level)).checkTraitLevel()).allowCrystal()).save(consumer, this.prefix(rl, "tools/modifiers/ability/"));
    }
}

