/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.datagen.general.recipes.ticex;

import java.util.function.Consumer;
import moffy.ticex.datagen.general.recipes.ITicEXSmelteryRecipeHelper;
import moffy.ticex.datagen.general.recipes.TicEXRecipeProvider;
import moffy.ticex.datagen.general.recipes.ticex.embossment.EmbossmentModifierRecipeBuilder;
import moffy.ticex.lib.TicEXMaterials;
import moffy.ticex.lib.TicEXTags;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.fluid.UnplaceableFluid;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipeBuilder;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelBuilder;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerWorld;

public class CommonRecipeProvider
implements ITicEXSmelteryRecipeHelper,
IMaterialRecipeHelper {
    public void buildRecipes(Consumer<FinishedRecipe> pWriter) {
        this.metalMaterialRecipe(pWriter, (MaterialVariantId)TicEXMaterials.ETHERIC, "tools/materials/", "etheric", false);
        this.buildShapedRecipes(pWriter);
        this.buildMaterialRecipes(pWriter);
        this.buildSmelteryRecipes(pWriter);
        AlloyRecipeBuilder.alloy((FluidOutput)FluidOutput.fromTag(TicEXTags.Fluids.ETHERIC, (int)270), (int)2500).addInput(TinkerFluids.moltenSlimesteel.get(), 90).addInput(TicEXTags.Fluids.HEPATIZON, 90).addInput(TicEXTags.Fluids.GOLD, 90).addInput(TicEXRegistry.MOLTEN_RECONSTRUCTION_CORE.get(), 250).save(pWriter, this.prefix(TicEXTags.Fluids.ETHERIC.f_203868_(), "smeltery/alloys/"));
        this.metalIngotOptional(pWriter, TicEXTags.Fluids.ETHERIC, TicEXTags.Items.ETHERIC_BLOCK, 5000, TicEXRegistry.MOLTEN_ETHERIC.getId());
    }

    public void buildShapedRecipes(Consumer<FinishedRecipe> pWriter) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TicEXRegistry.RECONSTRUCTION_CORE.get())).m_126127_(Character.valueOf('c'), (ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.SKY)).m_126127_(Character.valueOf('a'), (ItemLike)Items.f_151049_).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42748_).m_126127_(Character.valueOf('p'), (ItemLike)Items.f_42593_).m_126130_("asa").m_126130_("pcp").m_126130_("asa").m_126132_("has_item", (CriterionTriggerInstance)TicEXRecipeProvider.m_125977_((ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.SKY))).m_126140_(pWriter, this.prefix(TicEXRegistry.RECONSTRUCTION_CORE, "items/cores/"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TicEXRegistry.FLICKERING_RECONSTRUCTION_CORE.get())).m_126127_(Character.valueOf('c'), (ItemLike)TicEXRegistry.RECONSTRUCTION_CORE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42686_).m_126130_("ccc").m_126130_("csc").m_126130_("ccc").m_126132_("has_item", (CriterionTriggerInstance)TicEXRecipeProvider.m_125977_((ItemLike)TicEXRegistry.RECONSTRUCTION_CORE.get())).m_126140_(pWriter, this.prefix(TicEXRegistry.FLICKERING_RECONSTRUCTION_CORE, "items/cores/"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TicEXRegistry.ETHERIC_BLOCK.get())).m_271710_(true).m_206416_(Character.valueOf('#'), TicEXTags.Items.ETHERIC_INGOT).m_126127_(Character.valueOf('*'), (ItemLike)TicEXRegistry.ETHERIC_INGOT.get()).m_126130_("###").m_126130_("#*#").m_126130_("###").m_126132_("has_item", (CriterionTriggerInstance)TicEXRecipeProvider.m_125977_((ItemLike)TicEXRegistry.ETHERIC_INGOT.get())).m_176500_(pWriter, this.prefix("items/etheric_block_from_ingot"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TicEXRegistry.ETHERIC_INGOT.get()), (int)9).m_126209_((ItemLike)TicEXRegistry.ETHERIC_BLOCK.get()).m_126132_("has_item", (CriterionTriggerInstance)TicEXRecipeProvider.m_125977_((ItemLike)TicEXRegistry.ETHERIC_BLOCK.get())).m_176500_(pWriter, this.prefix("items/etheric_ingot_from_block"));
    }

    public void buildMaterialRecipes(Consumer<FinishedRecipe> pWriter) {
        MaterialFluidRecipeBuilder.material((MaterialVariantId)TicEXMaterials.ETHERIC).setTemperature(2500).setFluid(TicEXTags.Fluids.ETHERIC, 90).save(pWriter, this.prefix((ResourceLocation)TicEXMaterials.ETHERIC, "tools/materials/casting/"));
        MaterialMeltingRecipeBuilder.material((MaterialVariantId)TicEXMaterials.ETHERIC, (int)2500, (FluidStack)new FluidStack(((ForgeFlowingFluid)TicEXRegistry.MOLTEN_ETHERIC.get()).m_5613_(), 90)).save(pWriter, this.prefix((ResourceLocation)TicEXMaterials.ETHERIC, "tools/materials/melting/"));
    }

    public void buildSmelteryRecipes(Consumer<FinishedRecipe> pWriter) {
        ItemCastingRecipeBuilder.retexturedBasinRecipe((ItemOutput)ItemOutput.fromItem((ItemLike)((ItemLike)TicEXRegistry.SCORCHED_RF_FURNACE.get()))).setFluidAndTime(TicEXRegistry.MOLTEN_RECONSTRUCTION_CORE, 2000).setCast(TinkerTags.Items.FOUNDRY_BRICKS, true).save(pWriter, this.prefix(TicEXRegistry.SCORCHED_RF_FURNACE, "smeltery/casting/scorched/"));
        ItemCastingRecipeBuilder.retexturedBasinRecipe((ItemOutput)ItemOutput.fromItem((ItemLike)((ItemLike)TicEXRegistry.SEARED_RF_FURNACE.get()))).setFluidAndTime(TicEXRegistry.MOLTEN_RECONSTRUCTION_CORE, 2000).setCast(TinkerTags.Items.SMELTERY_BRICKS, true).save(pWriter, this.prefix(TicEXRegistry.SEARED_RF_FURNACE, "smeltery/casting/seared/"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)TicEXRegistry.FLICKERING_RECONSTRUCTION_CORE.get())).setFluid(TicEXTags.Fluids.RECONSTRUCTION_CORE, 2000).setCoolingTime(60).save(pWriter, this.prefix(TicEXRegistry.FLICKERING_RECONSTRUCTION_CORE, "smeltery/casting/slime/"));
        MaterialFluidRecipeBuilder.material((MaterialVariantId)TicEXMaterials.RECONSTRUCTION).setTemperature(1000).setFluid(TicEXTags.Fluids.RECONSTRUCTION_CORE, 2000).save(pWriter, this.prefix((ResourceLocation)TicEXMaterials.RECONSTRUCTION, "tools/materials/casting/"));
        ((EmbossmentModifierRecipeBuilder)EmbossmentModifierRecipeBuilder.modifier(TicEXRegistry.EMBOSSMENT_MODIFIER.getId()).addInput(SizedIngredient.fromItems((ItemLike[])new ItemLike[]{TinkerWorld.earthGeode.get()})).addInput(SizedIngredient.fromItems((ItemLike[])new ItemLike[]{TinkerWorld.skyGeode.get()})).addInput(SizedIngredient.fromItems((ItemLike[])new ItemLike[]{TinkerWorld.ichorGeode.get()})).addInput(SizedIngredient.fromItems((ItemLike[])new ItemLike[]{TinkerWorld.enderGeode.get()})).addEmbossItem(SizedIngredient.fromTag((TagKey)TinkerTags.Items.TOOL_PARTS)).setTools(TinkerTags.Items.DURABILITY)).save(pWriter, this.prefix((IdAwareObject)TicEXRegistry.EMBOSSMENT_MODIFIER, "tools/modifiers/slotless/"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TicEXRegistry.FLICKERING_RECONSTRUCTION_CORE.get()}), (FluidOutput)FluidOutput.fromFluid((Fluid)TicEXRegistry.MOLTEN_RECONSTRUCTION_CORE.get(), (int)2000), (int)1000, (int)32).save(pWriter, this.prefix(TicEXRegistry.FLICKERING_RECONSTRUCTION_CORE, "smeltery/melting/"));
        for (int i = 0; i < TicEXRegistry.RF_FURNACE_FUELS.size(); ++i) {
            FluidObject<UnplaceableFluid> fuel = TicEXRegistry.RF_FURNACE_FUELS.get(i);
            MeltingFuelBuilder.fuel((FluidIngredient)fuel.ingredient(50), (int)150, (int)this.calculateRfFuelTemperature(i)).rate(5 * i + 5).save(pWriter, this.prefix((IdAwareObject)fuel, "smeltery/melting/fuel/"));
        }
    }

    public int calculateRfFuelTemperature(int n) {
        return 25 * n * n + 5 * n / 19 + 20;
    }

    @Override
    @NotNull
    public String getModId() {
        return "ticex";
    }
}

