/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.datagen.general.recipes.ticex.embossment;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import moffy.ticex.lib.recipe.EmbossmentCastingRecipe;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.recipe.casting.material.AbstractMaterialCastingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class EmbossmentCastingRecipeBuilder
extends AbstractRecipeBuilder<EmbossmentCastingRecipeBuilder> {
    @Nullable
    private final IMaterialItem result;
    private final TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe> recipeSerializer;
    private Ingredient cast = Ingredient.f_43901_;
    private int itemCost = 0;
    private boolean consumed = false;
    private boolean switchSlots = false;

    public EmbossmentCastingRecipeBuilder setCast(TagKey<Item> tag, boolean consumed) {
        return this.setCast(Ingredient.m_204132_(tag), consumed);
    }

    public EmbossmentCastingRecipeBuilder setCast(ItemLike item, boolean consumed) {
        return this.setCast(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), consumed);
    }

    public EmbossmentCastingRecipeBuilder setCast(Ingredient cast, boolean consumed) {
        this.cast = cast;
        this.consumed = consumed;
        return this;
    }

    public EmbossmentCastingRecipeBuilder setSwitchSlots() {
        this.switchSlots = true;
        return this;
    }

    public void save(@NotNull Consumer<FinishedRecipe> consumer) {
        if (this.result != null) {
            this.save(consumer, BuiltInRegistries.f_257033_.m_7981_((Object)this.result.m_5456_()));
        }
    }

    public void save(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        if (this.itemCost <= 0) {
            throw new IllegalStateException("Material casting recipes require a positive amount of fluid");
        }
        if (this.result == null) {
            throw new IllegalStateException("Result must not be null");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new EmbossmentCastingRecipe(this.recipeSerializer, id, this.group, this.cast, this.itemCost, this.result, this.consumed, this.switchSlots), EmbossmentCastingRecipe.LOADER, advancementId));
    }

    private EmbossmentCastingRecipeBuilder(@Nullable IMaterialItem result, TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe> recipeSerializer) {
        this.result = result;
        this.recipeSerializer = recipeSerializer;
    }

    public static EmbossmentCastingRecipeBuilder castingRecipe(@Nullable IMaterialItem result) {
        return new EmbossmentCastingRecipeBuilder(result, (TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe>)((TypeAwareRecipeSerializer)TicEXRegistry.CASTING_EMBOSSMENT_RECIPE_SERIALIZER.get()));
    }

    public static EmbossmentCastingRecipeBuilder builder(@Nullable IMaterialItem result, TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe> recipeSerializer) {
        return new EmbossmentCastingRecipeBuilder(result, recipeSerializer);
    }

    public EmbossmentCastingRecipeBuilder setItemCost(int itemCost) {
        this.itemCost = itemCost;
        return this;
    }
}

