/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.datagen.general.recipes.ticex.embossment;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moffy.ticex.lib.recipe.EmbossmentModifierRecipe;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipeBuilder;

public class EmbossmentModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<EmbossmentModifierRecipeBuilder> {
    private List<SizedIngredient> embossItem;
    private List<SizedIngredient> inputs;

    protected EmbossmentModifierRecipeBuilder(ModifierId result, List<SizedIngredient> embossItem, List<SizedIngredient> inputs) {
        super(result);
        this.embossItem = embossItem;
        this.inputs = inputs;
    }

    public static EmbossmentModifierRecipeBuilder modifier(ModifierId result) {
        return new EmbossmentModifierRecipeBuilder(result, new ArrayList<SizedIngredient>(), new ArrayList<SizedIngredient>());
    }

    public EmbossmentModifierRecipeBuilder addInput(SizedIngredient input) {
        this.inputs.add(input);
        return this;
    }

    public EmbossmentModifierRecipeBuilder addInputs(SizedIngredient ... inputs) {
        this.inputs.addAll(List.of(inputs));
        return this;
    }

    public EmbossmentModifierRecipeBuilder setInputs(SizedIngredient ... inputs) {
        this.inputs = List.of(inputs);
        return this;
    }

    public EmbossmentModifierRecipeBuilder setInputs(List<SizedIngredient> inputs) {
        this.inputs = inputs;
        return this;
    }

    public EmbossmentModifierRecipeBuilder addEmbossItem(SizedIngredient input) {
        this.embossItem.add(input);
        return this;
    }

    public EmbossmentModifierRecipeBuilder addEmbossItems(SizedIngredient ... inputs) {
        this.embossItem.addAll(List.of(inputs));
        return this;
    }

    public EmbossmentModifierRecipeBuilder setEmbossItems(SizedIngredient ... inputs) {
        this.embossItem = List.of(inputs);
        return this;
    }

    public EmbossmentModifierRecipeBuilder setEmbossItems(List<SizedIngredient> inputs) {
        this.embossItem = inputs;
        return this;
    }

    public void save(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        if (this.inputs.isEmpty() || this.embossItem.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new EmbossmentModifierRecipe(id, this.inputs, this.embossItem, this.tools, this.maxToolSize, this.result, ModifierEntry.VALID_LEVEL.range(this.minLevel, this.maxLevel), this.slots), EmbossmentModifierRecipe.LOADER, advancementId));
    }
}

