/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.datagen.general.tag;

import java.util.concurrent.CompletableFuture;
import moffy.ticex.lib.TicEXTags;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.data.recipe.CostTagAppender;

public class ItemTagProvider
extends ItemTagsProvider {
    public ItemTagProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> pBlockTags, @Nullable ExistingFileHelper existingFileHelper) {
        super(pOutput, pLookupProvider, pBlockTags, "ticex", existingFileHelper);
    }

    protected void m_6577_(@NotNull HolderLookup.Provider pProvider) {
        this.addCommon();
        this.addSmeltery();
        this.addTools();
    }

    private void addCommon() {
        this.addCores(new ResourceLocation("ticex", "reconstruction_core"), new ResourceLocation("ticex", "flickering_reconstruction_core"), new ResourceLocation("ticex", "celestial_core"), new ResourceLocation("ticex", "radiation_shelding_core"), new ResourceLocation("ticex", "draconium_evolved_core"), new ResourceLocation("ticex", "wyvern_evolved_core"), new ResourceLocation("ticex", "draconic_evolved_core"), new ResourceLocation("ticex", "chaotic_evolved_core"), new ResourceLocation("ticex", "inject_core"), new ResourceLocation("ticex", "konpaku_core"), new ResourceLocation("ticex", "koshirae_core"), new ResourceLocation("ticex", "lamellar_core"), new ResourceLocation("ticex", "overload_core"), new ResourceLocation("ticex", "override_core"), new ResourceLocation("ticex", "incomparable_core"), new ResourceLocation("ticex", "cardboard_core"));
        this.addOptional(TicEXTags.Items.INFINITY_INGOT, new ResourceLocation("avaritia", "infinity_ingot"));
        this.addOptional(TicEXTags.Items.NEUTRON_INGOT, new ResourceLocation("avaritia", "neutron_ingot"));
        this.addOptional(TicEXTags.Items.CRYSTAL_MATRIX_INGOT, new ResourceLocation("avaritia", "crystal_matrix_ingot"));
        this.addOptional(TicEXTags.Items.ETHERIC_INGOT, new ResourceLocation("ticex", "etheric_ingot"));
        this.addOptional(TicEXTags.Items.INFINITY_BLOCK, new ResourceLocation("avaritia", "infinity"));
        this.addOptional(TicEXTags.Items.NEUTRON_BLOCK, new ResourceLocation("avaritia", "neutron"));
        this.addOptional(TicEXTags.Items.CRYSTAL_MATRIX_BLOCK, new ResourceLocation("avaritia", "crystal_matrix"));
        this.addOptional(TicEXTags.Items.ETHERIC_BLOCK, new ResourceLocation("ticex", "etheric_block"));
        this.addCatalysts(new ResourceLocation("ticex", "catalyst_slashblade"), new ResourceLocation("ticex", "catalyst_kinetic_gun"), new ResourceLocation("ticex", "catalyst_irons_spellbook"), new ResourceLocation("ticex", "catalyst_meka_tool"));
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            this.addCatalysts(new ResourceLocation("ticex", "catalyst_mekasuit").m_266382_("_" + type.m_266355_()), new ResourceLocation("ticex", "catalyst_gem").m_266382_("_" + type.m_266355_()));
        }
        this.addOptional((TagKey<Item>)TinkerTags.Items.TOOL_PARTS, new ResourceLocation("ticex", "slashblade_blade"));
        this.addOptional((TagKey<Item>)TinkerTags.Items.TOOL_PARTS, new ResourceLocation("ticex", "slashblade_saya"));
    }

    private void addSmeltery() {
        this.m_206424_(TinkerTags.Items.SEARED_TANKS).m_255179_((Object[])new Item[]{((Block)TicEXRegistry.SEARED_RF_FURNACE.get()).m_5456_(), ((Block)TicEXRegistry.CREATIVE_SEARED_RF_FURNACE.get()).m_5456_()});
        this.m_206424_(TinkerTags.Items.SCORCHED_TANKS).m_255179_((Object[])new Item[]{((Block)TicEXRegistry.SCORCHED_RF_FURNACE.get()).m_5456_(), ((Block)TicEXRegistry.CREATIVE_SCORCHED_RF_FURNACE.get()).m_5456_()});
        this.addCast(TicEXRegistry.SLASHBLADE_SAYA_CAST);
        this.addCast(TicEXRegistry.SLASHBLADE_BLADE_CAST);
        this.m_206424_(TinkerTags.Items.CASTS).addOptionalTags(new TagKey[]{TinkerTags.Items.GOLD_CASTS, TinkerTags.Items.SAND_CASTS, TinkerTags.Items.RED_SAND_CASTS, TinkerTags.Items.TABLE_EMPTY_CASTS, TinkerTags.Items.BASIN_EMPTY_CASTS});
    }

    public void addCast(CastItemObject cast) {
        this.m_206424_(TinkerTags.Items.GOLD_CASTS).m_176839_(cast.getName().m_266382_("_cast"));
        this.m_206424_(TinkerTags.Items.SAND_CASTS).m_176839_(cast.getName().m_266382_("_sand_cast"));
        this.m_206424_(TinkerTags.Items.RED_SAND_CASTS).m_176839_(cast.getName().m_266382_("_red_sand_cast"));
        this.m_206424_(TinkerTags.Items.SINGLE_USE_CASTS).m_206428_(cast.getSingleUseTag());
        this.m_206424_(cast.getSingleUseTag()).m_176839_(cast.getName().m_266382_("_sand_cast")).m_176839_(cast.getName().m_266382_("_red_sand_cast"));
        this.m_206424_(TinkerTags.Items.MULTI_USE_CASTS).m_206428_(cast.getMultiUseTag());
        this.m_206424_(cast.getMultiUseTag()).m_176839_(cast.getName().m_266382_("_cast"));
    }

    private void addTools() {
        this.addToolTags(new ResourceLocation("ticex", "reforged_slashblade"), TicEXTags.Items.SLASHBLADE_TOOL, TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST, TinkerTags.Items.MELEE_PRIMARY, TinkerTags.Items.INTERACTABLE_RIGHT, TinkerTags.Items.PARRY, TinkerTags.Items.SMALL_TOOLS, TinkerTags.Items.BONUS_SLOTS, TinkerTags.Items.LONGBOWS, ItemTags.f_271388_, TinkerTags.Items.UNSALVAGABLE);
        this.addToolTags(new ResourceLocation("ticex", "blitz_gun"), TicEXTags.Items.KINETIC_GUN_TOOL, TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST, TinkerTags.Items.MELEE_PRIMARY, TinkerTags.Items.INTERACTABLE_RIGHT, TinkerTags.Items.PARRY, TinkerTags.Items.SMALL_TOOLS, TinkerTags.Items.BONUS_SLOTS, TinkerTags.Items.UNSALVAGABLE);
        this.addToolTags(new ResourceLocation("ticex", "revival_spellbook_irons"), TicEXTags.Items.IRONS_SPELLBOOK_TOOL, TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST, TinkerTags.Items.MELEE_PRIMARY, TinkerTags.Items.INTERACTABLE_RIGHT, TinkerTags.Items.PARRY, TinkerTags.Items.SMALL_TOOLS, TinkerTags.Items.BONUS_SLOTS, TinkerTags.Items.UNSALVAGABLE);
        this.addToolTags(new ResourceLocation("ticex", "meka_tool"), TicEXTags.Items.MEKA_TOOL, TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.MELEE_WEAPON, TinkerTags.Items.HARVEST, TinkerTags.Items.BONUS_SLOTS, TinkerTags.Items.DURABILITY);
        this.addArmorTags(new ResourceLocation("tconstruct", "plate"), TicEXTags.Items.PLATE);
        this.addArmorTags(new ResourceLocation("ticex", "mekaplate"), TicEXTags.Items.MEKASUIT_ARMOR, TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.BONUS_SLOTS, TinkerTags.Items.TRIM);
        this.addArmorTags(new ResourceLocation("ticex", "singular_gem"), TicEXTags.Items.GEM_ARMOR, TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.BONUS_SLOTS, TinkerTags.Items.TRIM);
        this.m_206424_(TicEXTags.Items.SERAM).addTags(new TagKey[]{TicEXTags.Items.SLASHBLADE_TOOL, TicEXTags.Items.KINETIC_GUN_TOOL, TicEXTags.Items.IRONS_SPELLBOOK_TOOL, TicEXTags.Items.MEKASUIT_ARMOR, TicEXTags.Items.GEM_ARMOR, TicEXTags.Items.MEKA_TOOL});
    }

    private void addTag(TagKey<Item> tagKey, ResourceLocation coreItem) {
        this.m_206424_(tagKey).m_176839_(coreItem);
    }

    private void addCores(ResourceLocation ... coreItems) {
        for (ResourceLocation coreItem : coreItems) {
            if (coreItem == null) continue;
            this.addTag(TicEXTags.Items.CORES, coreItem);
        }
    }

    private void addCatalysts(ResourceLocation ... catalystItems) {
        for (ResourceLocation catalystItem : catalystItems) {
            if (catalystItem == null) continue;
            this.m_206424_(TicEXTags.Items.CATALYSTS).m_176839_(catalystItem);
            this.m_206424_(TinkerTags.Items.TOOL_PARTS).m_176839_(catalystItem);
        }
    }

    @SafeVarargs
    private void addToolTags(ResourceLocation tool, TagKey<Item> ... tags) {
        if (tool != null) {
            for (TagKey<Item> tag : tags) {
                this.m_206424_(tag).m_176839_(tool);
            }
        }
    }

    private TagKey<Item> getArmorTag(ArmorItem.Type slotType) {
        return switch (slotType) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.BOOTS -> TinkerTags.Items.BOOTS;
            case ArmorItem.Type.LEGGINGS -> TinkerTags.Items.LEGGINGS;
            case ArmorItem.Type.CHESTPLATE -> TinkerTags.Items.CHESTPLATES;
            case ArmorItem.Type.HELMET -> TinkerTags.Items.HELMETS;
        };
    }

    private TagKey<Item> getForgeArmorTag(ArmorItem.Type slotType) {
        return switch (slotType) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.BOOTS -> Tags.Items.ARMORS_BOOTS;
            case ArmorItem.Type.LEGGINGS -> Tags.Items.ARMORS_LEGGINGS;
            case ArmorItem.Type.CHESTPLATE -> Tags.Items.ARMORS_CHESTPLATES;
            case ArmorItem.Type.HELMET -> Tags.Items.ARMORS_HELMETS;
        };
    }

    @SafeVarargs
    private void addArmorTags(ResourceLocation armor, TagKey<Item> ... tags) {
        if (armor != null) {
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                for (TagKey<Item> tag : tags) {
                    this.m_206424_(tag).m_176839_(armor.m_266382_("_" + type.m_266355_()));
                }
                this.m_206424_(this.getArmorTag(type)).m_176839_(armor.m_266382_("_" + type.m_266355_()));
                this.m_206424_(this.getForgeArmorTag(type)).m_176839_(armor.m_266382_("_" + type.m_266355_()));
            }
        }
    }

    protected CostTagAppender moltenTools(FluidObject<?> fluid) {
        return CostTagAppender.moltenToolMelting(fluid, tag -> this.m_206424_(ItemTags.create((ResourceLocation)tag)));
    }

    private void addOptional(TagKey<Item> tagkey, ResourceLocation id) {
        this.m_206424_(tagkey).m_176839_(id);
    }

    @NotNull
    public String m_6055_() {
        return "TiCEX Item Tags";
    }
}

