/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.datagen.tool;

import moffy.ticex.lib.CatalystMaterialStatsType;
import moffy.ticex.lib.TicEXMaterials;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialStatsDataProvider;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.tools.modules.ArmorModuleBuilder;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class MaterialStatsProvider
extends AbstractMaterialStatsDataProvider {
    public MaterialStatsProvider(PackOutput packOutput, AbstractMaterialDataProvider materials) {
        super(packOutput, materials);
    }

    public String m_6055_() {
        return "TiCEX Material Stats";
    }

    protected void addMaterialStats() {
        this.addMeleeHarvest();
        this.addRanged();
        this.addArmor();
        this.addMisc();
    }

    private void addMeleeHarvest() {
        this.addMaterialStats(TicEXMaterials.INFINITY, new IMaterialStats[]{new HeadMaterialStats(9999, 999.0f, TicEXRegistry.INFINITY_TIER, 999.1f), HandleMaterialStats.multipliers().attackDamage(9.99f).attackSpeed(9.99f).durability(9.99f).miningSpeed(9.99f).build(), StatlessMaterialStats.BINDING});
        this.addMaterialStats(TicEXMaterials.CRYSTAL_MATRIX, new IMaterialStats[]{new HeadMaterialStats(3200, 13.0f, (Tier)Tiers.NETHERITE, 4.5f), HandleMaterialStats.multipliers().attackDamage(1.5f).attackSpeed(1.5f).durability(1.25f).miningSpeed(1.5f).build(), StatlessMaterialStats.BINDING});
        this.addMaterialStats(TicEXMaterials.DRACONIUM, new IMaterialStats[]{new HeadMaterialStats(512, 7.0f, (Tier)Tiers.NETHERITE, 4.0f), HandleMaterialStats.multipliers().attackDamage(1.1f).attackSpeed(1.1f).durability(1.1f).miningSpeed(1.1f).build(), StatlessMaterialStats.BINDING});
        this.addMaterialStats(TicEXMaterials.WYVERN, new IMaterialStats[]{new HeadMaterialStats(1024, 10.0f, (Tier)Tiers.NETHERITE, 4.5f), HandleMaterialStats.multipliers().attackDamage(1.5f).attackSpeed(1.5f).durability(1.25f).miningSpeed(1.5f).build(), StatlessMaterialStats.BINDING});
        this.addMaterialStats(TicEXMaterials.DRACONIC, new IMaterialStats[]{new HeadMaterialStats(1536, 10.0f, (Tier)Tiers.NETHERITE, 5.0f), HandleMaterialStats.multipliers().attackDamage(1.75f).attackSpeed(1.75f).durability(1.5f).miningSpeed(1.75f).build(), StatlessMaterialStats.BINDING});
        this.addMaterialStats(TicEXMaterials.CHAOTIC, new IMaterialStats[]{new HeadMaterialStats(2048, 10.0f, (Tier)Tiers.NETHERITE, 5.5f), HandleMaterialStats.multipliers().attackDamage(2.2f).attackSpeed(2.2f).durability(2.0f).miningSpeed(2.2f).build(), StatlessMaterialStats.BINDING});
        this.addMaterialStats(TicEXMaterials.ETHERIC, new IMaterialStats[]{new HeadMaterialStats(2434, 7.5f, (Tier)Tiers.NETHERITE, 7.5f), HandleMaterialStats.multipliers().attackDamage(1.25f).attackSpeed(1.3f).durability(0.15f).miningSpeed(1.0f).build(), StatlessMaterialStats.BINDING});
    }

    private void addRanged() {
        this.addMaterialStats(TicEXMaterials.INFINITY, new IMaterialStats[]{new LimbMaterialStats(9999, 99.9f, 99.9f, 1.0f), new GripMaterialStats(9.99f, 1.0f, 4995.5f)});
        this.addMaterialStats(TicEXMaterials.CRYSTAL_MATRIX, new IMaterialStats[]{new LimbMaterialStats(3200, -0.4f, 0.45f, -0.1f), new GripMaterialStats(9.99f, 1.0f, 4995.5f)});
        this.addMaterialStats(TicEXMaterials.ETHERIC, new IMaterialStats[]{new LimbMaterialStats(2434, 0.25f, -0.05f, -0.1f), new GripMaterialStats(9.99f, 1.0f, 1137.5f)});
    }

    private void addArmor() {
        this.addArmorShieldStats(TicEXMaterials.INFINITY, (ArmorModuleBuilder.ArmorShieldModuleBuilder)PlatingMaterialStats.builder().durabilityFactor(9999.0f).armor(8.14f, 17.44f, 30.0f, 9.3f).toughness(15.0f).knockbackResistance(0.25f), new IMaterialStats[]{StatlessMaterialStats.MAILLE});
        this.addArmorShieldStats(TicEXMaterials.NEUTRON, (ArmorModuleBuilder.ArmorShieldModuleBuilder)PlatingMaterialStats.builder().durabilityFactor(1111.0f).armor(3.36f, 7.2f, 9.0f, 3.84f).toughness(15.0f).knockbackResistance(100.0f), new IMaterialStats[]{StatlessMaterialStats.MAILLE});
    }

    private void addMisc() {
        this.addMaterialStats(TicEXMaterials.RECONSTRUCTION, (IMaterialStats[])CatalystMaterialStatsType.getAllCatalystStats().stream().map(materialStat -> (CatalystMaterialStatsType)materialStat.getDefaultStats()).toArray(CatalystMaterialStatsType[]::new));
    }
}

