/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.entity.curios;

import javax.annotation.Nullable;
import moffy.ticex.TicEX;
import moffy.ticex.TicEXConfig;
import moffy.ticex.entity.ItemArrow;
import moffy.ticex.modules.general.TicEXRegistry;
import moffy.ticex.network.curios.TicEXSyncEntityMovements;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;

public class ResonanceToolProjectile
extends ItemArrow {
    private boolean projectileHit;
    private int remainTicks;
    protected static final EntityDataAccessor<Integer> TARGET_TAG = SynchedEntityData.m_135353_(ResonanceToolProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ResonanceToolProjectile(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
    }

    public ResonanceToolProjectile(@Nullable LivingEntity shooter, Level level) {
        super((EntityType<? extends AbstractArrow>)((EntityType)TicEXRegistry.RESONANCE_TOOL_PROJECTILE.get()), shooter, level);
        this.m_20088_().m_135381_(TARGET_TAG, (Object)shooter.m_19879_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TARGET_TAG, (Object)-1);
    }

    @Nullable
    public LivingEntity getArrowTarget() {
        int id = (Integer)this.m_20088_().m_135370_(TARGET_TAG);
        Entity entity = this.m_9236_().m_6815_(id);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return null;
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        this.projectileHit = true;
        super.m_8060_(pResult);
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity target = pResult.m_82443_();
        ItemStack toolStack = this.getItem();
        if (target == this.shooter || this.shooter == null) {
            return;
        }
        if (this.projectileHit) {
            return;
        }
        LivingEntity livingEntity = this.shooter;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                if (toolStack.m_41720_() instanceof IModifiable && !this.m_9236_().f_46443_) {
                    livingTarget.f_19802_ = 1;
                    ToolAttackUtil.attackEntity((ItemStack)toolStack, (Player)player, (Entity)livingTarget);
                }
            }
        }
        this.projectileHit = true;
        this.m_20256_(this.m_20184_().m_82490_(-0.1));
        this.m_146922_(this.m_146908_() + 180.0f);
        this.f_19859_ += 180.0f;
    }

    public void m_5496_(@NotNull SoundEvent pSound, float pVolume, float pPitch) {
    }

    public boolean isValidTarget(LivingEntity target) {
        if (target == this.shooter || this.shooter == null || target.m_21224_()) {
            return false;
        }
        Vec3 start = this.shooter.m_146892_();
        Vec3 end = target.m_146892_();
        ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.shooter);
        BlockHitResult hit = target.m_9236_().m_45547_(context);
        return hit.m_6662_() == HitResult.Type.MISS || !(hit.m_82450_().m_82557_(start) < start.m_82557_(end));
    }

    private boolean shouldRemoveProjectile(int maxRemainTicks) {
        return maxRemainTicks != -1 && this.remainTicks >= maxRemainTicks;
    }

    private void handleDespawn() {
        ++this.remainTicks;
        int maxRemainTicks = (Integer)TicEXConfig.GAUNTLET_REMAIN_TICKS.get();
        if (this.shouldRemoveProjectile(maxRemainTicks)) {
            this.m_146870_();
        }
    }

    private void shootAtTarget(LivingEntity target) {
        float velocity = 2.0f;
        float inaccuracy = 1.0f;
        Vec3 targetPosition = new Vec3(target.m_20185_(), target.m_20227_(0.5), target.m_20189_());
        Vec3 velocityVec = this.m_20184_().m_82541_().m_82490_((double)this.m_20270_((Entity)target) * 0.1).m_82549_(targetPosition.m_82546_(this.m_20182_()).m_82541_());
        this.m_6686_(velocityVec.f_82479_, velocityVec.f_82480_, velocityVec.f_82481_, 2.0f, 1.0f);
        TicEXSyncEntityMovements packet = new TicEXSyncEntityMovements((Entity)this);
        TicEX.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)packet);
    }

    @Nullable
    public LivingEntity findNearestTarget() {
        return this.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(this::isValidTarget), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(35.0));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.handleDespawn();
        if (this.m_213877_()) {
            return;
        }
        if (this.projectileHit) {
            return;
        }
        LivingEntity arrowTarget = this.getArrowTarget();
        if (arrowTarget == null || !this.isValidTarget(arrowTarget)) {
            arrowTarget = this.findNearestTarget();
            if (arrowTarget == null) {
                return;
            }
            this.m_20088_().m_135381_(TARGET_TAG, (Object)arrowTarget.m_19879_());
        }
        this.shootAtTarget(arrowTarget);
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }
}

