/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.event;

import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import moffy.ticex.lib.utils.TicEXCCUtils;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TicEXCCEvent {
    public static void onPlayerAttack(AttackEntityEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            PocketServerComputer computerItem;
            Player player = event.getEntity();
            Entity target = event.getTarget();
            if (TicEXCCEvent.hasModem(player) && (computerItem = TicEXCCEvent.getPocketComputer(player)) != null) {
                computerItem.queueEvent("player_attack", new Object[]{TicEXCCUtils.createEntityMapWithProps(player), TicEXCCUtils.createEntityMap(target)});
            }
        }
    }

    public static void onPlayerDeath(LivingDeathEvent event) {
        PocketServerComputer computerItem;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!event.getEntity().m_9236_().f_46443_ && livingEntity instanceof Player && TicEXCCEvent.hasModem(player = (Player)livingEntity) && (computerItem = TicEXCCEvent.getPocketComputer(player)) != null) {
            computerItem.queueEvent("player_death", new Object[]{TicEXCCUtils.createEntityMapWithProps(player)});
        }
    }

    public static void onPlayerTick(LivingEvent.LivingTickEvent event) {
        PocketServerComputer computerItem;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!event.getEntity().m_9236_().f_46443_ && livingEntity instanceof Player && TicEXCCEvent.hasModem(player = (Player)livingEntity) && (computerItem = TicEXCCEvent.getPocketComputer(player)) != null) {
            computerItem.queueEvent("player_tick", new Object[]{TicEXCCUtils.createEntityMapWithProps(player)});
        }
    }

    public static void onPlayerHurt(LivingHurtEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            PocketServerComputer computerItem;
            Player player;
            Entity source = event.getSource().m_7639_();
            LivingEntity target = event.getEntity();
            if (target instanceof Player && TicEXCCEvent.hasModem(player = (Player)target) && (computerItem = TicEXCCEvent.getPocketComputer(player)) != null) {
                computerItem.queueEvent("player_hurt", new Object[]{TicEXCCUtils.createEntityMap(source), TicEXCCUtils.createEntityMapWithProps(player)});
            }
        }
    }

    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        PocketServerComputer computerItem;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!event.getEntity().m_9236_().f_46443_ && livingEntity instanceof Player && TicEXCCEvent.hasModem(player = (Player)livingEntity) && (computerItem = TicEXCCEvent.getPocketComputer(player)) != null) {
            computerItem.queueEvent("player_jump", new Object[]{TicEXCCUtils.createEntityMapWithProps(player)});
        }
    }

    public static boolean hasModem(Player player) {
        ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
        if (chestStack.m_41720_() instanceof IModifiable) {
            ToolStack chest = ToolStack.from((ItemStack)chestStack);
            return chest.getModifierLevel(TicEXRegistry.MODEM_MODIFIER.get()) > 0;
        }
        return false;
    }

    public static PocketServerComputer getPocketComputer(Player player) {
        ToolStack chest;
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof IModifiable && (chest = ToolStack.from((ItemStack)player.m_6844_(EquipmentSlot.CHEST))).getModifierLevel(TicEXRegistry.MODEM_MODIFIER.get()) > 0) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!(stack.m_41720_() instanceof PocketComputerItem)) continue;
                return PocketComputerItem.getServerComputer((MinecraftServer)player.m_20194_(), (ItemStack)stack);
            }
        }
        return null;
    }
}

