/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.event;

import java.util.UUID;
import moffy.ticex.caps.EmbossmentMaterialCapability;
import moffy.ticex.client.modules.ticex.models.MaterialOverrideModel;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TicEXEvent {
    public static UUID EXTRA_DAMAGE_UUID = UUID.fromString("39f1e204-7c3b-4d51-9a3c-65e1db213f08");

    public static void onEntityAttributeModification(EntityAttributeModificationEvent event) {
        if (TicEXRegistry.DAMAGE_TAKEN != null && TicEXRegistry.HEALING_RECEIVED != null) {
            ForgeRegistries.ENTITY_TYPES.forEach(action -> {
                if (action.m_142225_().isAssignableFrom(LivingEntity.class)) {
                    event.add(action, (Attribute)TicEXRegistry.DAMAGE_TAKEN.get());
                    event.add(action, (Attribute)TicEXRegistry.HEALING_RECEIVED.get());
                }
            });
        }
    }

    public static void onEntityHurt(LivingHurtEvent event) {
        double multiplier;
        float amount = event.getAmount();
        if (amount <= 0.0f) {
            return;
        }
        float newAmount = amount;
        Entity source = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        AttributeInstance attributeInstance = target.m_21051_((Attribute)TicEXRegistry.DAMAGE_TAKEN.get());
        if (attributeInstance != null && (multiplier = attributeInstance.m_22135_()) != 1.0) {
            newAmount = Math.max(newAmount * (float)multiplier, 0.0f);
        }
        event.setAmount(newAmount);
        if ((double)newAmount < 0.01) {
            target.m_20334_(0.0, 0.0, 0.0);
            target.f_20916_ = 0;
            target.f_20917_ = 0;
            event.setCanceled(true);
        }
    }

    public static void onEntityHeal(LivingHealEvent event) {
        double multiplier;
        float amount = event.getAmount();
        if (amount <= 0.0f) {
            return;
        }
        LivingEntity entity = event.getEntity();
        AttributeInstance attributeInstance = entity.m_21051_((Attribute)TicEXRegistry.HEALING_RECEIVED.get());
        if (attributeInstance != null && (multiplier = attributeInstance.m_22135_()) != 1.0) {
            float newAmount = Math.max(amount * (float)multiplier, 0.0f);
            event.setAmount(newAmount);
            if ((double)newAmount < 1.0E-4) {
                event.setCanceled(true);
            }
        }
    }

    public static void modifyAttribute(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        EquipmentSlot slot = event.getSlotType();
        if (stack.m_41720_() instanceof IModifiable && slot == EquipmentSlot.MAINHAND) {
            AttributeModifier modifier = new AttributeModifier(EXTRA_DAMAGE_UUID, "Enchantment Bonus for Modifiable Item", 0.0, AttributeModifier.Operation.ADDITION);
            if (!event.getModifiers().containsValue((Object)modifier)) {
                event.addModifier(Attributes.f_22281_, modifier);
            } else {
                event.removeModifier(Attributes.f_22281_, modifier);
            }
        }
    }

    public static void supplierBouncer(LivingEquipmentChangeEvent event) {
        ItemStack stack = event.getTo();
        if (stack.m_41720_() instanceof IModifiable) {
            ToolStack tool = ToolStack.from((ItemStack)stack);
            if (stack.m_41793_() && tool.getModifierLevel(TicEXRegistry.ENCHANTMENT_SUPPLIER_MODIFIER.get()) < 1) {
                tool.addModifier(TicEXRegistry.ENCHANTMENT_SUPPLIER_MODIFIER.getId(), 1);
            }
        }
    }

    public static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        event.register(EmbossmentMaterialCapability.class);
    }

    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("mat_override_obj", MaterialOverrideModel.LOADER);
    }
}

